/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.action;

import com.wily.ui.IGenericServices;
import com.wily.ui.action.AExtendedActionWrapper;
import com.wily.ui.action.ExtendedActionException;
import com.wily.ui.action.IExtendedAction;
import com.wily.ui.swing.WilyJDialog;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.SwingAssertion;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;

public class ErrorReportingExtendedActionWrapper
extends AExtendedActionWrapper {
    private static final long serialVersionUID = -7437200816191904816L;
    private IGenericServices fGenericServices;
    private Component fParentComponent;
    private boolean fReportSynchronously;

    public ErrorReportingExtendedActionWrapper(IGenericServices genericServices, Component parentComponent, IExtendedAction action) {
        this(genericServices, parentComponent, action, true);
    }

    public ErrorReportingExtendedActionWrapper(IGenericServices genericServices, Component parentComponent, IExtendedAction action, boolean reportSynchronously) {
        super(action);
        this.fGenericServices = genericServices;
        this.fParentComponent = parentComponent;
        this.fReportSynchronously = reportSynchronously;
    }

    protected IGenericServices getGenericServices() {
        return this.fGenericServices;
    }

    public IStringLocalizer getStringLocalizer() {
        return this.getGenericServices().IGenericServices_getStringLocalizer();
    }

    public IModuleFeedbackChannel getModuleFeedback() {
        return this.getGenericServices().IGenericServices_getModuleFeedback();
    }

    public void doTriggerAction(ActionEvent actionEvent) throws ExtendedActionException {
        try {
            super.doTriggerAction(actionEvent);
        }
        catch (ExtendedActionException ae) {
            this.reportError(ae);
            throw ae;
        }
    }

    public void doUndoAction() throws ExtendedActionException {
        try {
            super.doUndoAction();
        }
        catch (ExtendedActionException ae) {
            this.reportError(ae);
            throw ae;
        }
    }

    public void doRedoAction() throws ExtendedActionException {
        try {
            super.doRedoAction();
        }
        catch (ExtendedActionException ae) {
            this.reportError(ae);
            throw ae;
        }
    }

    private void reportError(ExtendedActionException ae) {
        this.getModuleFeedback().debug(ae);
        if (this.fReportSynchronously) {
            this.reportErrorSync(ae);
        } else {
            this.reportErrorAsync(ae);
        }
    }

    private void reportErrorSync(ExtendedActionException ae) {
        SwingAssertion.assertSwingSafe();
        Toolkit.getDefaultToolkit().beep();
        WilyJDialog.showMessageDialog(this.getGenericServices(), this.fParentComponent, ae.getEntireUserMessage(this.getStringLocalizer()), ae.getUserMessageTitle(this.getStringLocalizer()), 0);
    }

    private void reportErrorAsync(final ExtendedActionException ae) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ErrorReportingExtendedActionWrapper.this.reportErrorSync(ae);
            }
        });
    }

    public Object clone() throws CloneNotSupportedException {
        ErrorReportingExtendedActionWrapper newErrorReportingExtendedActionWrapper = (ErrorReportingExtendedActionWrapper)super.clone();
        newErrorReportingExtendedActionWrapper.fGenericServices = this.fGenericServices;
        newErrorReportingExtendedActionWrapper.fParentComponent = this.fParentComponent;
        newErrorReportingExtendedActionWrapper.fReportSynchronously = this.fReportSynchronously;
        return newErrorReportingExtendedActionWrapper;
    }
}

