/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.dnd;

import com.wily.ui.action.ExtendedActionMonitor;
import com.wily.ui.action.IExtendedAction;
import com.wily.ui.action.NullExtendedAction;
import com.wily.ui.datatransfer.KDataTransferConstants;
import com.wily.ui.datatransfer.TransferableSet;
import com.wily.ui.dnd.DnDUtils;
import com.wily.ui.dnd.IAutoDragSourceListener;
import com.wily.ui.dnd.LinkedDragActionBroker;
import com.wily.ui.dnd.TransferablesDraggedEvent;
import com.wily.wilyassert.Assertion;
import java.awt.Component;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.util.List;

public class AutoDragSource
implements KDataTransferConstants {
    private int fActions;
    private IAutoDragSourceListener fAutoDragSourceListener;
    private TransferableSet fTransferableSet;
    private boolean fEnabled;
    private DragGestureRecognizer fDragGestureRecognizer;
    private ItemDragRecognizerListener fItemDragRecognizerListener;

    public AutoDragSource(Component sourceComponent, int actions, IAutoDragSourceListener autoDragSourceListener) {
        this.fActions = actions;
        this.fAutoDragSourceListener = autoDragSourceListener;
        this.fEnabled = true;
        DragSource dragSource = DragSource.getDefaultDragSource();
        this.fItemDragRecognizerListener = new ItemDragRecognizerListener();
        this.fDragGestureRecognizer = dragSource.createDefaultDragGestureRecognizer(sourceComponent, this.fActions, this.fItemDragRecognizerListener);
    }

    public void tearDownDragSource() {
        if (this.fDragGestureRecognizer != null) {
            this.fDragGestureRecognizer.removeDragGestureListener(this.fItemDragRecognizerListener);
        }
        this.fItemDragRecognizerListener = null;
        this.fDragGestureRecognizer = null;
    }

    public void setEnabled(boolean enabled) {
        this.fEnabled = enabled;
    }

    public boolean enabled() {
        return this.fEnabled;
    }

    private IExtendedAction getDropAction(int action) {
        return this.fAutoDragSourceListener.IAutoDragSourceListener_getDropAction(action);
    }

    private ExtendedActionMonitor getDragSourceActionMonitor() {
        return this.fAutoDragSourceListener.IAutoDragSourceListener_getActionMonitor();
    }

    private class GenericDragSourceListener
    implements DragSourceListener {
        private GenericDragSourceListener() {
        }

        public void dragDropEnd(DragSourceDropEvent e) {
            if (!e.getDropSuccess()) {
                return;
            }
            try {
                LinkedDragActionBroker linkedDragActionBroker = (LinkedDragActionBroker)AutoDragSource.this.fTransferableSet.getTransferData(KDataTransferConstants.kLinkedDragActionBrokerDataFlavor);
                IExtendedAction dropAction = null;
                dropAction = linkedDragActionBroker.linkedAction1IsCompleteAction() ? new NullExtendedAction(linkedDragActionBroker.getLinkedAction1().IExtendedAction_getName()) : AutoDragSource.this.getDropAction(e.getDropAction());
                ExtendedActionMonitor dragSourceActionMonitor = AutoDragSource.this.getDragSourceActionMonitor();
                TransferablesDraggedEvent itemsDraggedEvent = new TransferablesDraggedEvent(e.getSource(), (List)AutoDragSource.this.fTransferableSet.getTransferData(KDataTransferConstants.kTransferableSetDataFlavor));
                linkedDragActionBroker.setLinkedAction2(dropAction, dragSourceActionMonitor, itemsDraggedEvent);
                linkedDragActionBroker.triggerLinkedActions();
            }
            catch (UnsupportedFlavorException ufe) {
                Assertion.wilyAssert(false, "GenericDragSourceListener.dragDropEnd unexpected exception");
            }
        }

        public void dragEnter(DragSourceDragEvent e) {
        }

        public void dragExit(DragSourceEvent e) {
        }

        public void dragOver(DragSourceDragEvent e) {
        }

        public void dropActionChanged(DragSourceDragEvent e) {
        }
    }

    private class ItemDragRecognizerListener
    implements DragGestureListener {
        private ItemDragRecognizerListener() {
        }

        public void dragGestureRecognized(DragGestureEvent e) {
            if (AutoDragSource.this.enabled()) {
                AutoDragSource.this.fTransferableSet = AutoDragSource.this.fAutoDragSourceListener.IAutoDragSourceListener_getTransferableSet(e.getComponent(), e.getDragOrigin());
                if (AutoDragSource.this.fTransferableSet.getcontainedTransferableCount() > 0) {
                    e.startDrag(DnDUtils.dragActionToCursor(AutoDragSource.this.fActions), AutoDragSource.this.fTransferableSet, new GenericDragSourceListener());
                }
            }
        }
    }
}

