/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.image;

import com.wily.EDU.oswego.cs.dl.util.concurrent.Latch;
import com.wily.ui.image.DefaultImageFilterFactory;
import com.wily.ui.image.IImageFilterFactory;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.wilyassert.Assertion;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class ImageBroker {
    private static final long kLoadImageTimeOutInMillis = 10000L;
    private IModuleFeedbackChannel fModuleFeedback;
    private MediaTracker fMediaTracker;
    private IImageFilterFactory fImageFilterFactory;
    private Hashtable fKeyToImageMap;
    private Hashtable fURLToRawImageMap;
    private Hashtable fKeyToImageIconMap;
    private Hashtable fKeyToImageURLMap;

    public ImageBroker(IModuleFeedbackChannel moduleFeedback) {
        this.initialize(moduleFeedback, null);
    }

    public ImageBroker(IModuleFeedbackChannel moduleFeedback, IImageFilterFactory imageFilterFactory) {
        this.initialize(moduleFeedback, imageFilterFactory);
    }

    private void initialize(IModuleFeedbackChannel moduleFeedback, IImageFilterFactory imageFilterFactory) {
        this.fMediaTracker = new MediaTracker(new JPanel());
        this.fModuleFeedback = moduleFeedback;
        this.fImageFilterFactory = imageFilterFactory == null ? new DefaultImageFilterFactory() : imageFilterFactory;
        this.fKeyToImageMap = new Hashtable();
        this.fKeyToImageURLMap = new Hashtable();
        this.fURLToRawImageMap = new Hashtable();
        this.fKeyToImageIconMap = new Hashtable();
    }

    public void setImageFilterFactory(IImageFilterFactory imageFilterFactory) {
        this.fImageFilterFactory = imageFilterFactory;
    }

    public void loadImagesFromResourceBundle(ResourceBundle bundle) {
        long preloadStartTime = System.currentTimeMillis();
        Enumeration<String> imageKeys = bundle.getKeys();
        while (imageKeys.hasMoreElements()) {
            String imageKey = imageKeys.nextElement();
            String imageSpecifierString = bundle.getString(imageKey);
            if (StringUtils.isEmpty(imageKey)) break;
            try {
                ImageSpecifier imageSpecifier = new ImageSpecifier(imageSpecifierString);
                String imageURL = imageSpecifier.getURL();
                Image image = null;
                image = this.lookupRawImageUsingURL(imageURL);
                if (image == null) {
                    URL url = this.getClass().getResource(imageURL);
                    image = Toolkit.getDefaultToolkit().createImage(url);
                    this.waitForImage(image, imageKey);
                    this.rememberRawImageUsingURL(imageURL, image);
                }
                if (imageSpecifier.hasFilters()) {
                    image = this.recursivelyFilterImage(image, imageSpecifier.getFilterIDs());
                }
                this.rememberImageUsingKey(imageKey, image);
                this.rememberURLUsingKey(imageKey, imageURL);
            }
            catch (Throwable t) {
                this.getModuleFeedback().error("error loading image with key = \"" + imageKey + "\"");
                this.getModuleFeedback().verbose(t);
            }
        }
    }

    public void preloadImage(String imageKey, String imageURL) {
        URL url = this.getClass().getResource(imageURL);
        Image image = Toolkit.getDefaultToolkit().createImage(url);
        this.waitForImage(image, imageKey);
        this.rememberRawImageUsingURL(imageURL, image);
        this.rememberImageUsingKey(imageKey, image);
    }

    public Enumeration getImageKeys() {
        return this.fKeyToImageMap.keys();
    }

    public Image getImage(String imageKey) {
        return this.lookupImageUsingKey(imageKey);
    }

    public InputStream getImageAsStream(String imageKey) {
        String url = this.lookupURLUsingKey(imageKey);
        return this.getClass().getResourceAsStream(url);
    }

    public Icon getImageIcon(String imageKey) {
        Image image;
        ImageIcon iconImage = this.lookupImageIconUsingKey(imageKey);
        if (iconImage == null && (image = this.lookupImageUsingKey(imageKey)) != null) {
            iconImage = new ImageIcon(image);
            this.fKeyToImageIconMap.put(imageKey, iconImage);
        }
        return iconImage;
    }

    private void waitForImage(Image image, String name) {
        int mediaTrackerID = image.hashCode();
        this.fMediaTracker.addImage(image, mediaTrackerID);
        try {
            this.fMediaTracker.waitForID(mediaTrackerID, 10000L);
            if (!this.fMediaTracker.checkID(mediaTrackerID)) {
                this.getModuleFeedback().error("Timed out loading image: " + image + " named " + name);
            }
            Assertion.wilyAssert(!this.fMediaTracker.isErrorAny());
        }
        catch (InterruptedException e) {
            this.getModuleFeedback().error("Couldn't preload image: " + image);
        }
    }

    private IModuleFeedbackChannel getModuleFeedback() {
        return this.fModuleFeedback;
    }

    private Image recursivelyFilterImage(Image image, String[] filterIDs) {
        Image newImage = null;
        ImageProducer currentProducer = image.getSource();
        try {
            for (int i = 0; i < filterIDs.length; ++i) {
                ImageFilter filter = this.fImageFilterFactory.IImageFilterFactory_getFilter(filterIDs[i]);
                currentProducer = new FilteredImageSource(currentProducer, filter);
            }
            newImage = new JPanel().createImage(currentProducer);
            Latch latch = new Latch();
            MyObserver observer = new MyObserver(latch);
            newImage.getWidth(observer);
            newImage.getHeight(observer);
            latch.acquire();
        }
        catch (Exception e) {
            this.getModuleFeedback().error("error filtering image \"" + image + "\", skipping rest of filters");
            this.getModuleFeedback().verbose(e);
        }
        return newImage;
    }

    private void rememberImageUsingKey(String imageKey, Image image) {
        this.fKeyToImageMap.put(imageKey, image);
    }

    private void rememberRawImageUsingURL(String imageURL, Image image) {
        this.fURLToRawImageMap.put(imageURL, image);
    }

    private void rememberURLUsingKey(String imageKey, String imageURL) {
        this.fKeyToImageURLMap.put(imageKey, imageURL);
    }

    private String lookupURLUsingKey(String imageKey) {
        return (String)this.fKeyToImageURLMap.get(imageKey);
    }

    private Image lookupImageUsingKey(String imageKey) {
        return (Image)this.fKeyToImageMap.get(imageKey);
    }

    private Image lookupRawImageUsingURL(String imageURL) {
        return (Image)this.fURLToRawImageMap.get(imageURL);
    }

    private ImageIcon lookupImageIconUsingKey(String imageKey) {
        return (ImageIcon)this.fKeyToImageIconMap.get(imageKey);
    }

    private class ImageSpecifier {
        private String fImageURL;
        private String[] fFilterIDs;

        public ImageSpecifier(String imageSpecifierString) {
            this.initialize(imageSpecifierString);
        }

        private void initialize(String imageSpecifierString) {
            this.fImageURL = null;
            Vector<String> holder = new Vector<String>();
            StringTokenizer tokenizer = new StringTokenizer(imageSpecifierString);
            if (tokenizer.hasMoreTokens()) {
                this.fImageURL = tokenizer.nextToken();
            }
            while (tokenizer.hasMoreTokens()) {
                holder.add(tokenizer.nextToken());
            }
            this.fFilterIDs = new String[holder.size()];
            this.fFilterIDs = holder.toArray(this.fFilterIDs);
        }

        public String getURL() {
            return this.fImageURL;
        }

        public boolean hasFilters() {
            return this.fFilterIDs.length != 0;
        }

        public String[] getFilterIDs() {
            return this.fFilterIDs;
        }
    }

    private class MyObserver
    implements ImageObserver {
        private boolean fGotWidth = false;
        private boolean fGotHeight = false;
        private boolean fGotAllbits = false;
        private int fWidth = -1;
        private int fHeight = -1;
        private Latch fLatch;

        MyObserver(Latch latch) {
            this.fLatch = latch;
        }

        int getHeight() {
            return this.fHeight;
        }

        int getWidth() {
            return this.fWidth;
        }

        public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            if ((infoflags & 1) == 1) {
                this.fGotWidth = true;
                this.fWidth = width;
            }
            if ((infoflags & 2) == 2) {
                this.fGotHeight = true;
                this.fHeight = height;
            }
            if ((infoflags & 0x20) == 32) {
                this.fGotAllbits = true;
            }
            if (this.fGotWidth && this.fGotHeight && this.fGotAllbits) {
                this.fLatch.release();
                return false;
            }
            return true;
        }
    }
}

