/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing;

import com.wily.properties.KUICommonStringsKeys;
import com.wily.ui.IGenericServices;
import com.wily.ui.KWilyUserInterfaceConstants;
import com.wily.ui.WilyMultiLineLabel;
import com.wily.ui.WilyUIUtilities;
import com.wily.ui.action.AutoDisableExtendedActionWrapper;
import com.wily.ui.action.CompoundExtendedAction;
import com.wily.ui.action.ErrorReportingExtendedActionWrapper;
import com.wily.ui.action.IExtendedAction;
import com.wily.ui.swing.AGenericModalDialog;
import com.wily.wilyassert.SwingAssertion;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ActionPerformingConfirmationDialog
extends AGenericModalDialog
implements KUICommonStringsKeys,
KWilyUserInterfaceConstants {
    private ActionPerformingConfirmationDialog(IGenericServices genericServices, Component parentComponent, String title, String prompt, IExtendedAction[] actions, int defaultActionIndex, boolean allowCancel, boolean syncButtonState) {
        super(genericServices, parentComponent, title);
        this.initUI(prompt, actions, defaultActionIndex, allowCancel, syncButtonState);
    }

    private void initUI(String prompt, IExtendedAction[] actions, int defaultActionIndex, boolean allowCancel, boolean syncButtonState) {
        JPanel contentPane = new JPanel();
        contentPane.setBorder(kStandardDialogBorder);
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel buttonsPanel = new JPanel(new FlowLayout(2));
        WilyMultiLineLabel promptComponent = new WilyMultiLineLabel(prompt);
        promptComponent.setAlignmentY(0.0f);
        JComponent iconComponent = WilyUIUtilities.getStandardWarningIconComponent();
        iconComponent.setAlignmentY(0.0f);
        JPanel messagePanel = new JPanel();
        messagePanel.setLayout(new BoxLayout(messagePanel, 0));
        messagePanel.add(iconComponent);
        messagePanel.add(Box.createHorizontalStrut(5));
        messagePanel.add(promptComponent);
        messagePanel.setAlignmentX(1.0f);
        contentPane.add(messagePanel);
        for (int i = 0; i < actions.length; ++i) {
            CompoundExtendedAction yesAction = new CompoundExtendedAction(actions[i].IExtendedAction_getName());
            yesAction.addExtendedAction(actions[i]);
            yesAction.addExtendedAction(this.getAcceptAction());
            ErrorReportingExtendedActionWrapper reportingYesAction = new ErrorReportingExtendedActionWrapper(this.getGenericServices(), this.getSurrogateDialog(), yesAction);
            AutoDisableExtendedActionWrapper autoDisableYesAction = new AutoDisableExtendedActionWrapper(reportingYesAction);
            JButton yesButton = new JButton();
            WilyUIUtilities.setActionForButton(autoDisableYesAction, yesButton, true, syncButtonState);
            if (i == defaultActionIndex) {
                this.getRootPane().setDefaultButton(yesButton);
            }
            buttonsPanel.add(yesButton);
        }
        if (allowCancel) {
            this.setAllowCloseRequest(allowCancel);
            JButton cancelButton = new JButton(this.getStringLocalizer().IStringLocalizer_getLocalizedString("Cancel"));
            WilyUIUtilities.setActionForButton(this.getCancelAction(), cancelButton);
            buttonsPanel.add(cancelButton);
        }
        buttonsPanel.setAlignmentX(1.0f);
        contentPane.add(buttonsPanel);
        this.setContentPane(contentPane);
    }

    public static boolean showActionPerformingConfirmationDialog(IGenericServices genericServices, Component parentComponent, String title, String prompt, IExtendedAction[] actions, int defaultActionIndex, boolean allowCancel) {
        return ActionPerformingConfirmationDialog.showActionPerformingConfirmationDialog(genericServices, parentComponent, title, prompt, actions, defaultActionIndex, allowCancel, true);
    }

    public static boolean showActionPerformingConfirmationDialog(IGenericServices genericServices, Component parentComponent, String title, String prompt, IExtendedAction[] actions, int defaultActionIndex, boolean allowCancel, boolean syncButtonState) {
        SwingAssertion.assertSwingSafe();
        ActionPerformingConfirmationDialog dialog = new ActionPerformingConfirmationDialog(genericServices, parentComponent, title, prompt, actions, defaultActionIndex, allowCancel, syncButtonState);
        dialog.pack();
        dialog.show();
        return dialog.accepted();
    }
}

