/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.ComboBoxUI;

public class SearchableComboBox
extends JComboBox {
    private static final long serialVersionUID = 2403929966830701397L;
    protected SearchableComboBoxModel fSearchableComboBoxModel;
    protected Action fActionToPerform;
    protected String fOriginalActionCommand = this.getActionCommand();
    private final String fUIClassID = "WilySearchableComboBoxUI";

    public String getUIClassID() {
        return "WilySearchableComboBoxUI";
    }

    public SearchableComboBox(ComboBoxModel model, Action actionToPerform) {
        super(model);
        this.fActionToPerform = actionToPerform;
        this.setEditable(true);
        if (this.fActionToPerform != null) {
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equals(SearchableComboBox.this.getActionCommand())) {
                        SearchableComboBox.this.fActionToPerform.actionPerformed(new ActionEvent(SearchableComboBox.this.editor, 0, "from combobox action performed"));
                    }
                }
            });
        }
    }

    public void setModel(ComboBoxModel aModel) {
        this.fSearchableComboBoxModel = new SearchableComboBoxModel(aModel);
        super.setModel(this.fSearchableComboBoxModel);
    }

    public void resetSelectedIndex() {
    }

    protected void fireActionEvent() {
        ComboBoxUI ui = this.getUI();
        if (ui.isPopupVisible(this)) {
            return;
        }
        super.fireActionEvent();
    }

    public class SearchableComboBoxModel
    extends DefaultComboBoxModel {
        private static final long serialVersionUID = 1023280491034838943L;
        ComboBoxModel fOrigModel;
        String fUppercaseSearchText;
        ArrayList fOrigItems = null;
        ArrayList fCurrentItems;
        Vector fObjects;
        String fDummy = new String("synchronized fIsWaitingToRefresh");
        boolean fIsWaitingToRefresh = false;

        public SearchableComboBoxModel(ComboBoxModel origModel) {
            this.fOrigModel = origModel;
            this.fOrigModel.addListDataListener(new ListDataListener(){

                public void intervalAdded(ListDataEvent e) {
                    SearchableComboBoxModel.this.updateModel();
                }

                public void intervalRemoved(ListDataEvent e) {
                    SearchableComboBoxModel.this.updateModel();
                }

                public void contentsChanged(ListDataEvent e) {
                    SearchableComboBoxModel.this.updateModel();
                }
            });
            this.fUppercaseSearchText = "";
            this.fObjects = new Vector();
            this.setupOrigModelList();
            this.setupItemsBasedOnSearch();
        }

        public void setSelectedItem(Object anObject) {
            this.fOrigModel.setSelectedItem(anObject);
            super.setSelectedItem(this.fOrigModel.getSelectedItem());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateModel() {
            String string = this.fDummy;
            synchronized (string) {
                if (this.fIsWaitingToRefresh) {
                    return;
                }
                this.fIsWaitingToRefresh = true;
            }
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    String string = SearchableComboBoxModel.this.fDummy;
                    synchronized (string) {
                        SearchableComboBoxModel.this.fIsWaitingToRefresh = false;
                    }
                    SearchableComboBoxModel.this.setupOrigModelList();
                    SearchableComboBoxModel.this.setupItemsBasedOnSearch();
                    Object selectedItem = SearchableComboBoxModel.this.fOrigModel.getSelectedItem();
                    if (selectedItem != null) {
                        SearchableComboBox.this.setSelectedItem(null);
                        SearchableComboBox.this.setSelectedItem(selectedItem);
                    }
                }
            });
        }

        private void setupOrigModelList() {
            int i;
            int size = this.fOrigModel.getSize();
            Object[] arraySortedItems = new Object[size];
            for (i = 0; i < size; ++i) {
                arraySortedItems[i] = this.fOrigModel.getElementAt(i);
            }
            this.fOrigItems = new ArrayList(size);
            for (i = 0; i < arraySortedItems.length; ++i) {
                this.fOrigItems.add(arraySortedItems[i]);
            }
        }

        public void setSearchText(String searchText) {
            if (searchText.toUpperCase().compareTo(this.fUppercaseSearchText) != 0) {
                this.fUppercaseSearchText = searchText.toUpperCase();
                this.setupItemsBasedOnSearch();
            }
        }

        public String getSearchText() {
            return this.fUppercaseSearchText;
        }

        private void setupItemsBasedOnSearch() {
            int i;
            this.removeAllElements();
            int size = this.fOrigItems.size();
            ArrayList listMatchingItems = new ArrayList(size);
            for (i = 0; i < size; ++i) {
                Object nextItem = this.fOrigItems.get(i);
                if (this.fUppercaseSearchText.length() == 0) {
                    listMatchingItems.add(nextItem);
                    continue;
                }
                String nextText = nextItem.toString().toUpperCase();
                if (nextText.indexOf(this.fUppercaseSearchText) == -1) continue;
                listMatchingItems.add(nextItem);
            }
            for (i = 0; i < listMatchingItems.size(); ++i) {
                this.insertElementAt(listMatchingItems.get(i), i);
            }
        }

        class ObjectCollator
        implements Comparator {
            Collator fCollator = Collator.getInstance();

            public int compare(Object o1, Object o2) {
                String s1 = o1 == null ? "" : (o1 instanceof String ? (String)o1 : o1.toString());
                String s2 = o2 == null ? "" : (o2 instanceof String ? (String)o2 : o2.toString());
                return this.fCollator.compare(s1, s2);
            }
        }
    }
}

