/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing;

import com.wily.ui.WilyUIUtilities;
import com.wily.ui.swing.WilyButtonComboBoxModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComboBoxUI;

public class WilyButtonComboBox
extends JComboBox {
    private static final long serialVersionUID = -7710908928208489281L;
    protected JButton fButton;
    protected WilyButtonComboBoxModel fModel;
    private static final String uiClassID = "WilyButtonComboBoxUI";

    public WilyButtonComboBox(WilyButtonComboBoxModel wilyButtonComboBoxModel, String buttonString, Icon buttonIcon) {
        super(wilyButtonComboBoxModel.getComboBoxModel());
        this.setMaximumRowCount(10);
        this.fModel = wilyButtonComboBoxModel;
        this.setButton(buttonString, buttonIcon);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals(WilyButtonComboBox.this.getActionCommand())) {
                    WilyButtonComboBox.this.fireActionDueToComboBoxSelectionChanging();
                }
            }
        });
    }

    public void resetSelectedIndex() {
        this.fireActionEvent();
    }

    protected void fireActionEvent() {
        ComboBoxUI ui = this.getUI();
        if (ui.isPopupVisible(this)) {
            return;
        }
        super.fireActionEvent();
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void setButton(String buttonString, Icon buttonIcon) {
        JButton oldButton = this.fButton;
        this.fButton = new JButton(buttonString, buttonIcon);
        this.fButton.setMargin(WilyUIUtilities.kDefaultToolbarButtonInsets);
        WilyUIUtilities.setActionForButton(new ButtonAction(), this.fButton);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                WilyButtonComboBox.this.setEnabled(WilyButtonComboBox.this.fModel.isEnabled());
            }
        });
        this.fModel.addEnabledChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Boolean enabledBoolean = (Boolean)evt.getNewValue();
                WilyButtonComboBox.this.setEnabled(enabledBoolean);
            }
        });
        if (oldButton == null && this.fButton != null || oldButton != null && !oldButton.equals(this.fButton)) {
            this.firePropertyChange("button", oldButton, this.fButton);
        }
    }

    protected void fireActionDueToComboBoxSelectionChanging() {
        this.fModel.performSelectionAction(this.getSelectedItem());
    }

    public JButton getButton() {
        return this.fButton;
    }

    public WilyButtonComboBoxModel getWilyButtonComboBoxModel() {
        return this.fModel;
    }

    public boolean isEditable() {
        return true;
    }

    protected class ButtonAction
    extends AbstractAction
    implements PropertyChangeListener {
        private static final long serialVersionUID = -5037412910954257643L;

        public ButtonAction() {
            WilyButtonComboBox.this.fModel.addEnabledChangeListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            WilyButtonComboBox.this.fModel.performDefaultAction();
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    }
}

