/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.CellRendererPane;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicComboPopup;

class WilyComboPopup
extends BasicComboPopup {
    private static final long serialVersionUID = -5020744577342689272L;
    protected WilyComboPopupSupport wilyComboPopupSupport;

    public WilyComboPopup(WilyComboPopupSupport wilyComboPopupSupport, JComboBox combo) {
        super(combo);
        this.wilyComboPopupSupport = wilyComboPopupSupport;
    }

    public void show() {
        this.showAtLocation(new Point(0, this.comboBox.getBounds().height));
    }

    public void showAtLocation(Point preferredPopupLocation) {
        int selectedIndex = this.comboBox.getSelectedIndex();
        if (selectedIndex == -1) {
            this.list.clearSelection();
        } else {
            this.list.setSelectedIndex(selectedIndex);
            this.list.ensureIndexIsVisible(selectedIndex);
        }
        Point location = this.getPopupLocation(preferredPopupLocation);
        this.show(this.comboBox, location.x, location.y);
    }

    private Point getPopupLocation(Point preferredPopupLocation) {
        Dimension popupSize = this.comboBox.getSize();
        int popupWidth = this.getPopupWidth();
        int maximumRowCount = this.comboBox.getMaximumRowCount();
        int itemCount = this.comboBox.getItemCount();
        if (itemCount > maximumRowCount) {
            int widthScrollbar = this.getScrollbarWidth();
            popupWidth += widthScrollbar;
        }
        popupSize.setSize(popupWidth, this.getPopupHeightForRowCount(maximumRowCount));
        Rectangle popupBounds = this.computePopupBounds(preferredPopupLocation.x, preferredPopupLocation.y, popupSize.width, popupSize.height);
        Dimension scrollSize = popupBounds.getSize();
        Point popupLocation = popupBounds.getLocation();
        this.scroller.setMaximumSize(scrollSize);
        this.scroller.setPreferredSize(scrollSize);
        this.scroller.setMinimumSize(scrollSize);
        this.list.revalidate();
        return popupLocation;
    }

    protected int getScrollbarWidth() {
        int widthScrollbar = this.scroller.getVerticalScrollBar().getWidth();
        if (widthScrollbar <= 0 && (widthScrollbar = UIManager.getInt("ScrollBar.width")) <= 0) {
            widthScrollbar = 16;
        }
        return widthScrollbar;
    }

    protected int getPopupWidth() {
        DefaultListCellRenderer renderer = this.comboBox.getRenderer();
        if (renderer == null) {
            renderer = new DefaultListCellRenderer();
        }
        ComboBoxModel model = this.comboBox.getModel();
        int modelSize = model.getSize();
        Insets insets = this.getInsets();
        int minWidth = this.comboBox.getSize().width - insets.left - insets.right;
        int maximumRowCount = this.comboBox.getMaximumRowCount();
        int widthScrollbar = 0;
        int itemCount = this.comboBox.getItemCount();
        if (itemCount > maximumRowCount) {
            widthScrollbar = this.getScrollbarWidth();
            minWidth -= widthScrollbar;
        }
        int bestWidth = minWidth;
        if (modelSize > 0) {
            for (int i = 0; i < modelSize; ++i) {
                Component cpn = renderer.getListCellRendererComponent(this.list, model.getElementAt(i), -1, false, false);
                this.wilyComboPopupSupport.getCurrentValuePane().add(cpn);
                cpn.setFont(this.comboBox.getFont());
                Dimension d = cpn.getPreferredSize();
                this.wilyComboPopupSupport.getCurrentValuePane().remove(cpn);
                bestWidth = Math.max(bestWidth, d.width);
            }
        } else {
            bestWidth = minWidth;
            if (this.comboBox.isEditable()) {
                bestWidth = Math.max(100, minWidth);
            }
        }
        int maxSizeBasedOnScreenSize = Toolkit.getDefaultToolkit().getScreenSize().width - widthScrollbar;
        bestWidth = Math.min(bestWidth, maxSizeBasedOnScreenSize);
        return bestWidth;
    }

    public static interface WilyComboPopupSupport {
        public Dimension getComboDefaultSize();

        public CellRendererPane getCurrentValuePane();
    }
}

