/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing.layout;

import com.wily.wilyassert.Assertion;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;

public class AlignedNameValuePairsLayout
implements LayoutManager {
    private int fValueLabelMinWidth;
    private int fMaxPreferredWidth;

    public AlignedNameValuePairsLayout(int valueLabelMinWidth, int maxPreferredWidth) {
        Assertion.wilyAssert(valueLabelMinWidth < maxPreferredWidth);
        this.fValueLabelMinWidth = valueLabelMinWidth;
        this.fMaxPreferredWidth = maxPreferredWidth;
    }

    public void addLayoutComponent(String name, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        Assertion.wilyAssert(container.getComponentCount() % 2 == 0);
        Component[] children = container.getComponents();
        Insets insets = container.getInsets();
        int maxLineHeight = 0;
        int maxLineWidth = 0;
        int count = container.getComponentCount();
        for (int i = 0; i < count; i += 2) {
            int lineHeight = Math.max(children[i].getPreferredSize().height, children[i + 1].getPreferredSize().height);
            maxLineHeight = Math.max(lineHeight, maxLineHeight);
            maxLineWidth = Math.max(children[i].getPreferredSize().width + children[i + 1].getPreferredSize().width, maxLineWidth);
        }
        int preferredWidth = Math.min(maxLineWidth, this.fMaxPreferredWidth);
        return new Dimension(this.fMaxPreferredWidth, maxLineHeight * container.getComponentCount() / 2 + insets.top + insets.bottom);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public void layoutContainer(Container container) {
        int i;
        Assertion.wilyAssert(container.getComponentCount() % 2 == 0);
        Component[] children = container.getComponents();
        Insets insets = container.getInsets();
        int nextY = insets.top;
        int maxLineHeight = 0;
        int valueLabelMaxWidth = 0;
        int nameLabelMaxWidth = 0;
        for (i = 0; i < children.length; ++i) {
            maxLineHeight = Math.max(children[i].getPreferredSize().height, maxLineHeight);
            if (i % 2 == 0) {
                nameLabelMaxWidth = Math.max(children[i].getPreferredSize().width, nameLabelMaxWidth);
                continue;
            }
            valueLabelMaxWidth = Math.max(children[i].getPreferredSize().width, valueLabelMaxWidth);
        }
        valueLabelMaxWidth = Math.max(this.fValueLabelMinWidth, valueLabelMaxWidth);
        nameLabelMaxWidth = Math.min(container.getSize().width - valueLabelMaxWidth - insets.left - insets.right, nameLabelMaxWidth);
        for (i = 0; i < children.length; ++i) {
            Component child = children[i];
            if (i % 2 == 0) {
                child.setLocation(new Point(insets.left, nextY));
                child.setSize(new Dimension(nameLabelMaxWidth, child.getPreferredSize().height));
                continue;
            }
            child.setLocation(new Point(nameLabelMaxWidth + insets.left, nextY));
            child.setSize(new Dimension(valueLabelMaxWidth, child.getPreferredSize().height));
            nextY += maxLineHeight;
        }
    }
}

