/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing.layout;

import com.wily.ui.swing.layout.ATitleComponentPairsPanel;
import com.wily.ui.swing.layout.TitleComponentPair;
import com.wily.util.text.IStringLocalizer;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class BorderedTitleComponentPairsPanel
extends ATitleComponentPairsPanel {
    private static final long serialVersionUID = -6628213556363916213L;
    private int fAxis;
    private Dimension fDimension;

    public BorderedTitleComponentPairsPanel(TitleComponentPair[] titleComponentPairs, IStringLocalizer stringLocalizer) {
        this(titleComponentPairs, 1, stringLocalizer);
    }

    public BorderedTitleComponentPairsPanel(TitleComponentPair[] titleComponentPairs, int axis, IStringLocalizer stringLocalizer) {
        super(titleComponentPairs, stringLocalizer);
        this.fAxis = axis;
        this.initUI();
    }

    private void initUI() {
        this.setLayout(new BoxLayout(this, this.fAxis));
        Enumeration pairs = this.getTitleComponentPairs();
        while (pairs.hasMoreElements()) {
            TitleComponentPair pair = (TitleComponentPair)pairs.nextElement();
            JPanel titlePanel = new JPanel();
            TitledBorder border = (TitledBorder)this.createTitledBorder(pair.getTitle());
            Dimension dim = border.getMinimumSize(pair.getComponent());
            if (dim.width > this.fDimension.width) {
                this.fDimension.width = dim.width;
            }
            if (dim.height > this.fDimension.height) {
                this.fDimension.height = dim.height;
            }
            titlePanel.setBorder(border);
            Component comp = pair.getComponent();
            titlePanel.add(comp);
            titlePanel.setAlignmentX(0.0f);
            this.add(titlePanel);
            if (!pairs.hasMoreElements()) continue;
            this.add(Box.createRigidArea(new Dimension(this.getHorizontalGap(), this.getVerticalGap())));
        }
    }

    private Border createTitledBorder(String title) {
        if (title == null) {
            return BorderFactory.createEtchedBorder();
        }
        return BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title, 1, 2);
    }
}

