/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;

public class SimpleVerticalLayout
implements LayoutManager {
    public static final int kDefaultStyle = 0;
    public static final int kEqualWidthStyle = 1;
    public static final int kForceExpandStyle = 2;
    private static final int kDefaultGap = 5;
    private int fGap;
    private int fStyle;

    public SimpleVerticalLayout() {
        this(0, 5);
    }

    public SimpleVerticalLayout(int style) {
        this(style, 5);
    }

    public SimpleVerticalLayout(int style, int gap) {
        this.fStyle = style;
        this.fGap = gap;
    }

    public void addLayoutComponent(String name, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        int layoutWidth = 0;
        int layoutHeight = 0;
        Component[] children = container.getComponents();
        for (int i = 0; i < children.length; ++i) {
            Dimension childSize = children[i].getPreferredSize();
            int childWidth = childSize.width;
            int childHeight = childSize.height;
            layoutWidth = Math.max(layoutWidth, childWidth);
            layoutHeight += childHeight;
            if (i + 1 >= children.length) continue;
            layoutHeight += this.fGap;
        }
        Insets insets = container.getInsets();
        return new Dimension(layoutWidth += insets.left + insets.right, layoutHeight += insets.top + insets.bottom);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int i;
            Dimension size = container.getSize();
            Insets insets = container.getInsets();
            int maxChildWidth = 0;
            int containerWidth = container.getSize().width - insets.left - insets.right;
            int nextX = insets.left;
            int nextY = insets.top;
            Component[] children = container.getComponents();
            Dimension[] childSizes = new Dimension[children.length];
            for (i = 0; i < children.length; ++i) {
                childSizes[i] = children[i].getPreferredSize();
            }
            if (this.useEqualWidthStyle()) {
                for (i = 0; i < children.length; ++i) {
                    maxChildWidth = Math.max(maxChildWidth, childSizes[i].width);
                }
            }
            for (i = 0; i < children.length; ++i) {
                int childHeight = childSizes[i].height;
                int childWidth = childSizes[i].width;
                children[i].setLocation(new Point(nextX, nextY));
                if (this.useEqualWidthStyle()) {
                    childWidth = maxChildWidth;
                }
                if (this.useForceExpandStyle()) {
                    childWidth = containerWidth;
                }
                childWidth = this.useEqualWidthStyle() ? maxChildWidth : childWidth;
                children[i].setSize(childWidth, childHeight);
                nextY += childHeight + this.fGap;
            }
        }
    }

    private boolean useEqualWidthStyle() {
        return (this.fStyle & 1) != 0;
    }

    private boolean useForceExpandStyle() {
        return (this.fStyle & 2) != 0;
    }
}

