/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.widget;

import com.wily.ui.KWilyUserInterfaceConstants;
import com.wily.ui.RadialMeasurements;
import com.wily.ui.widget.ATrafficLightWidget;
import com.wily.wilyassert.SwingAssertion;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;

public class TrafficLightWidget
extends ATrafficLightWidget
implements KWilyUserInterfaceConstants {
    private static final int kIntraLampOffset = 4;
    private boolean fHorizontal = true;
    private static final int kRedLamp = 0;
    private static final int kYellowLamp = 1;
    private static final int kGreenLamp = 2;

    public TrafficLightWidget() {
    }

    public TrafficLightWidget(int state) {
        super(state);
    }

    public Dimension getPreferredSize() {
        return new Dimension(270, 90);
    }

    public void setHorizontal(boolean horizontal) {
        this.fHorizontal = horizontal;
    }

    public synchronized void draw(Graphics g, Dimension d) {
        SwingAssertion.assertSwingSafe("must draw on the swing thread");
        Graphics2D g2D = (Graphics2D)g;
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RadialMeasurements[] lampMeasurementsList = this.getLampMeasurements(d);
        this.drawRedLamp(g2D, lampMeasurementsList[0], this.fState == 457);
        this.drawYellowLamp(g2D, lampMeasurementsList[1], this.fState == 458);
        this.drawGreenLamp(g2D, lampMeasurementsList[2], this.fState == 459);
    }

    private RadialMeasurements[] getLampMeasurements(Dimension d) {
        Point greenLampCenter;
        Point yellowLampCenter;
        Point redLampCenter;
        int maxRadius;
        RadialMeasurements[] lampMeasurements = new RadialMeasurements[3];
        if (this.fHorizontal) {
            maxRadius = d.height * 3 > d.width ? d.width / 6 : d.height / 2;
            redLampCenter = new Point(maxRadius, maxRadius);
            yellowLampCenter = new Point(maxRadius * 3, maxRadius);
            greenLampCenter = new Point(maxRadius * 5, maxRadius);
        } else {
            maxRadius = d.width * 3 > d.height ? d.height / 6 : d.width / 2;
            redLampCenter = new Point(maxRadius, maxRadius);
            yellowLampCenter = new Point(maxRadius, maxRadius * 3);
            greenLampCenter = new Point(maxRadius, maxRadius * 5);
        }
        int adjustedRadius = maxRadius - 4;
        lampMeasurements[0] = new RadialMeasurements(redLampCenter, adjustedRadius);
        lampMeasurements[1] = new RadialMeasurements(yellowLampCenter, adjustedRadius);
        lampMeasurements[2] = new RadialMeasurements(greenLampCenter, adjustedRadius);
        return lampMeasurements;
    }
}

