/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.wizard;

import com.wily.ui.swing.ExtendedJFrame;
import com.wily.ui.wizard.AWizard;
import com.wily.ui.wizard.IWizardListener;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.JButton;

public class WizardWindow
extends ExtendedJFrame
implements IWizardListener {
    private static final long serialVersionUID = -2348045274697088770L;
    private AWizard fWizard;
    private boolean fExitOnCancel;
    private boolean fExitOnFinish;

    public WizardWindow(String localizedTitle, AWizard wizard) {
        super(wizard.getGenericServices(), localizedTitle);
        this.initialize(wizard);
    }

    public WizardWindow(String localizedTitle, String windowIconKey, AWizard wizard) {
        super(wizard.getGenericServices(), localizedTitle, windowIconKey);
        this.initialize(wizard);
    }

    private void initialize(AWizard wizard) {
        this.fWizard = wizard;
        this.fWizard.addWizardListener(this);
        this.setContentPane(this.fWizard);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getPreferredSize();
        this.setSize(frameSize);
        this.setResizable(false);
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    protected void doRespondToCloseRequest() {
        this.fWizard.cancel();
    }

    public void exitOnCancel(boolean exitOnCancel) {
        this.fExitOnCancel = exitOnCancel;
    }

    public void exitOnFinish(boolean exitOnFinish) {
        this.fExitOnFinish = exitOnFinish;
    }

    public void IWizardListener_wizardCancelled(AWizard wizard) {
        if (this.fExitOnCancel) {
            System.exit(0);
        }
        this.IWizardListener_wizardFinished(wizard);
    }

    public void IWizardListener_wizardFinished(AWizard wizard) {
        if (this.fExitOnFinish) {
            System.exit(0);
        }
    }

    public void IWizardListener_setDefaultButton(AWizard wizard, JButton button) {
        this.getRootPane().setDefaultButton(button);
    }
}

