/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util;

import com.wily.util.HashCodeUtils;
import com.wily.wilyassert.Assertion;
import java.io.Serializable;

public class Range
implements Serializable {
    private static final long serialVersionUID = 4038186240995080238L;
    private final double fLowerBound;
    private final double fUpperBound;
    private final boolean fLowerBoundIncluded;
    private final boolean fUpperBoundIncluded;
    private final boolean fIsEmpty;

    public Range() {
        this.fIsEmpty = true;
        this.fUpperBound = 0.0;
        this.fLowerBound = 0.0;
        this.fUpperBoundIncluded = true;
        this.fLowerBoundIncluded = true;
    }

    public Range(double bound1, double bound2) {
        this(bound1, bound2, true, true);
    }

    public Range(double bound1, double bound2, boolean bound1Included, boolean bound2Included) {
        this.fIsEmpty = false;
        if (bound1 <= bound2) {
            this.fLowerBound = bound1;
            this.fUpperBound = bound2;
            this.fLowerBoundIncluded = bound1Included;
            this.fUpperBoundIncluded = bound2Included;
        } else {
            this.fLowerBound = bound2;
            this.fUpperBound = bound1;
            this.fLowerBoundIncluded = bound2Included;
            this.fUpperBoundIncluded = bound1Included;
        }
    }

    public boolean isEmpty() {
        return this.fIsEmpty;
    }

    public boolean valueInRange(double value) {
        return !this.valueBelowRange(value) && !this.valueAboveRange(value);
    }

    public boolean contains(Range candidateRange) {
        return Range.compareRangeLowValues(this, candidateRange) <= 0 && Range.compareRangeHighValues(this, candidateRange) >= 0;
    }

    public Range intersect(Range intersectingRange) {
        Range highestRange;
        if (this.isEmpty() || intersectingRange.isEmpty()) {
            return new Range();
        }
        Range intersection = null;
        Range lowestRange = Range.compareRangeLowValues(this, intersectingRange) < 0 ? this : intersectingRange;
        Range range = highestRange = Range.compareRangeHighValues(this, intersectingRange) < 0 ? intersectingRange : this;
        if (lowestRange == highestRange) {
            Range encompassedRange;
            intersection = encompassedRange = lowestRange == this ? intersectingRange : this;
        } else {
            int comparison = Range.compareRangeHighValueToRangeLowValue(lowestRange, highestRange);
            switch (comparison) {
                case -1: {
                    intersection = new Range();
                    break;
                }
                case 0: {
                    intersection = new Range(lowestRange.getUpperBound(), lowestRange.getUpperBound());
                    break;
                }
                case 1: {
                    intersection = new Range(lowestRange.getUpperBound(), highestRange.getLowerBound(), lowestRange.isUpperBoundIncluded(), highestRange.isLowerBoundIncluded());
                    break;
                }
                default: {
                    Assertion.wilyAssert("unexpected error computing intersection");
                }
            }
        }
        Assertion.wilyAssert(intersection != null, "unexpected error computing intersection");
        return intersection;
    }

    public static Range getBoundingRange(Range r1, Range r2) {
        boolean upperIncluded;
        double upper;
        boolean lowerIncluded;
        double lower;
        if (r1.isEmpty()) {
            return r2;
        }
        if (r2.isEmpty()) {
            return r1;
        }
        if (Range.compareRangeLowValues(r1, r2) < 0) {
            lower = r1.fLowerBound;
            lowerIncluded = r1.fLowerBoundIncluded;
        } else {
            lower = r2.fLowerBound;
            lowerIncluded = r2.fLowerBoundIncluded;
        }
        if (Range.compareRangeHighValues(r1, r2) > 0) {
            upper = r1.fUpperBound;
            upperIncluded = r1.fUpperBoundIncluded;
        } else {
            upper = r2.fUpperBound;
            upperIncluded = r2.fUpperBoundIncluded;
        }
        return new Range(lower, upper, lowerIncluded, upperIncluded);
    }

    public boolean equals(Object candidateObject) {
        if (!(candidateObject instanceof Range)) {
            return false;
        }
        Range candidateRange = (Range)candidateObject;
        if (candidateRange.isEmpty() && this.isEmpty()) {
            return true;
        }
        if (candidateRange.isEmpty() || this.isEmpty()) {
            return false;
        }
        return this.getLowerBound() == candidateRange.getLowerBound() && this.getUpperBound() == candidateRange.getUpperBound() && this.isLowerBoundIncluded() == candidateRange.isLowerBoundIncluded() && this.isUpperBoundIncluded() == candidateRange.isUpperBoundIncluded();
    }

    public int hashCode() {
        int hash = 17;
        hash = HashCodeUtils.accumulateHashCode(hash, this.isEmpty());
        hash = HashCodeUtils.accumulateHashCode(hash, this.getLowerBound());
        hash = HashCodeUtils.accumulateHashCode(hash, this.getUpperBound());
        hash = HashCodeUtils.accumulateHashCode(hash, this.isLowerBoundIncluded());
        hash = HashCodeUtils.accumulateHashCode(hash, this.isUpperBoundIncluded());
        return hash;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getName());
        if (this.isEmpty()) {
            buffer.append(": empty range");
        } else {
            buffer.append(": LowerBound = ");
            buffer.append(this.getLowerBound());
            if (this.isLowerBoundIncluded()) {
                buffer.append(" (included)");
            } else {
                buffer.append(" (not included)");
            }
            buffer.append(", UpperBound = ");
            buffer.append(this.getUpperBound());
            if (this.isUpperBoundIncluded()) {
                buffer.append(" (included)");
            } else {
                buffer.append(" (not included)");
            }
        }
        return buffer.toString();
    }

    public double getLowerBound() {
        return this.fLowerBound;
    }

    public double getUpperBound() {
        return this.fUpperBound;
    }

    public boolean isLowerBoundIncluded() {
        return this.fLowerBoundIncluded;
    }

    public boolean isUpperBoundIncluded() {
        return this.fUpperBoundIncluded;
    }

    private boolean valueBelowRange(double value) {
        return this.isLowerBoundIncluded() ? value < this.getLowerBound() : value <= this.getLowerBound();
    }

    private boolean valueAboveRange(double value) {
        return this.isUpperBoundIncluded() ? value > this.getUpperBound() : value >= this.getUpperBound();
    }

    private static int compareRangeHighValueToRangeLowValue(Range range1, Range range2) {
        int comparison = range1.isEmpty() && range2.isEmpty() ? 0 : (range1.isEmpty() != range2.isEmpty() ? (range2.isEmpty() ? -1 : 1) : Range.compareBounds(range1.getUpperBound(), range2.getLowerBound(), range1.isUpperBoundIncluded(), range2.isLowerBoundIncluded(), -1));
        return comparison;
    }

    private static int compareRangeLowValues(Range range1, Range range2) {
        int comparison = range1.isEmpty() && range2.isEmpty() ? 0 : (range1.isEmpty() != range2.isEmpty() ? (range2.isEmpty() ? -1 : 1) : Range.compareBounds(range1.getLowerBound(), range2.getLowerBound(), range1.isLowerBoundIncluded(), range2.isLowerBoundIncluded(), 0));
        return comparison;
    }

    private static int compareRangeHighValues(Range range1, Range range2) {
        int comparison = range1.isEmpty() && range2.isEmpty() ? 0 : (range1.isEmpty() != range2.isEmpty() ? (range2.isEmpty() ? -1 : 1) : Range.compareBounds(range1.getUpperBound(), range2.getUpperBound(), range1.isUpperBoundIncluded(), range2.isUpperBoundIncluded(), 0));
        return comparison;
    }

    private static int compareBounds(double bound1, double bound2, boolean bound1Included, boolean bound2Included, int direction) {
        if (bound1 == bound2) {
            if (bound1Included && bound2Included) {
                return 0;
            }
            if (!bound1Included && !bound2Included) {
                return direction;
            }
            return bound1Included ? -1 : 1;
        }
        if (bound1Included == bound2Included) {
            return bound1 < bound2 ? -1 : 1;
        }
        boolean bound1lower = bound1Included ? bound1 <= bound2 : bound2 >= bound1;
        return bound1lower ? -1 : 1;
    }
}

