/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.event;

import com.wily.util.event.AListenerEvent;
import com.wily.util.event.EventPump;
import com.wily.util.event.IBasket;
import com.wily.util.event.IBasketable;
import com.wily.util.event.ITrackableListener;
import com.wily.util.event.ListenerTracker;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.wilyassert.Assertion;

public abstract class ARewindingBasketable
implements IBasketable {
    private final IBasket fBasket;
    private final ListenerTracker fListeners;

    public ARewindingBasketable(IBasket basket, Class basketableListenerClass) {
        this.fBasket = basket;
        this.fListeners = new ListenerTracker(basket.IBasket_getModuleFeedback(), "basketable", basketableListenerClass);
    }

    public abstract void doBasketableRewind(ITrackableListener var1);

    protected abstract Object getEggLock();

    public IModuleFeedbackChannel IBasketable_getModuleFeedback() {
        return this.getBasket().IBasket_getModuleFeedback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewind(ITrackableListener listener) {
        Assertion.wilyAssert(listener != null, "Listener is null, see dhalem");
        Object object = this.getEggLock();
        synchronized (object) {
            this.noticeStateChanged(listener, this.getCurrentState(), null);
            this.doBasketableRewind(listener);
            AListenerEvent rewindCompleteEvent = this.IBasketable_allocateEvent(1007);
            this.postTargetedEvent(listener, rewindCompleteEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void IBasketable_addBroadcastListenerWithRewind(ITrackableListener listener) {
        Assertion.wilyAssert(listener != null, "Listener is null, see dhalem");
        Object object = this.getEggLock();
        synchronized (object) {
            this.rewind(listener);
            this.getEventPump().postAddBroadcastListener(this.getListenerTracker(), listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void IBasketable_addBroadcastListener(ITrackableListener listener) {
        Assertion.wilyAssert(listener != null, "Listener is null, see dhalem");
        Object object = this.getEggLock();
        synchronized (object) {
            this.getEventPump().postAddBroadcastListener(this.getListenerTracker(), listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void IBasketable_removeBroadcastListener(ITrackableListener listener) {
        Assertion.wilyAssert(listener != null, "Listener is null, see dhalem");
        Object object = this.getEggLock();
        synchronized (object) {
            this.doRemoveBroadcastListener(listener);
        }
    }

    protected void doRemoveBroadcastListener(ITrackableListener listener) {
        Assertion.wilyAssert(listener != null, "Listener is null, see dhalem");
        this.coreRemoveBroadcastListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void coreRemoveBroadcastListener(ITrackableListener listener) {
        Assertion.wilyAssert(listener != null, "Listener is null, see dhalem");
        Object object = this.getEggLock();
        synchronized (object) {
            this.getEventPump().postRemoveBroadcastListener(this.getListenerTracker(), listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void postTargetedEvent(ITrackableListener listener, AListenerEvent event) {
        Assertion.wilyAssert(listener != null, "Listener is null, see dhalem");
        Object object = this.getEggLock();
        synchronized (object) {
            this.doPostTargetedEvent(listener, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void corePostTargetedEvent(ITrackableListener listener, AListenerEvent event) {
        Assertion.wilyAssert(listener != null, "Listener is null, see dhalem");
        Object object = this.getEggLock();
        synchronized (object) {
            this.getEventPump().postTargetedEvent(this.getListenerTracker(), listener, event);
        }
    }

    protected void doPostTargetedEvent(ITrackableListener listener, AListenerEvent event) {
        Assertion.wilyAssert(listener != null, "Listener is null, see dhalem");
        this.corePostTargetedEvent(listener, event);
    }

    public void noticeStateChanged(ITrackableListener listener, Object newState, Object oldState) {
        Assertion.wilyAssert(listener != null, "Listener is null, see dhalem");
        AListenerEvent changeEvent = this.allocateStateChangedEvent(1005, newState, oldState);
        this.postTargetedEvent(listener, changeEvent);
    }

    private IBasket getBasket() {
        return this.fBasket;
    }

    private ListenerTracker getListenerTracker() {
        return this.fListeners;
    }

    private EventPump getEventPump() {
        return this.getBasket().IBasket_getEventPump();
    }

    private final Object getCurrentState() {
        return this.doGetCurrentState();
    }

    private final AListenerEvent allocateStateChangedEvent(int id, Object newState, Object oldState) {
        return this.doAllocateStateChangedEvent(id, newState, oldState);
    }

    protected abstract Object doGetCurrentState();

    protected abstract AListenerEvent doAllocateStateChangedEvent(int var1, Object var2, Object var3);
}

