/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.ds.classmonitor;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

class ClassCacheEntry
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private byte[] digest;
    private long size;
    private transient ClassLoader loader;

    public ClassCacheEntry() {
    }

    ClassCacheEntry(byte[] digest, long size, ClassLoader loader) {
        this.digest = digest;
        this.size = size;
        this.loader = loader;
    }

    byte[] getDigest() {
        return this.digest;
    }

    long getSize() {
        return this.size;
    }

    void setDigest(byte[] digest) {
        this.digest = digest;
    }

    void setSize(long size) {
        this.size = size;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public void setClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    @Override
    public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
        this.size = oi.readLong();
        Object object = oi.readObject();
        int digestBytes = (Integer)object;
        if (digestBytes == 0) {
            this.digest = null;
        } else {
            this.digest = new byte[digestBytes];
            oi.readFully(this.digest);
        }
    }

    @Override
    public void writeExternal(ObjectOutput oo) throws IOException {
        oo.writeLong(this.size);
        oo.writeObject(this.digest != null ? new Integer(this.digest.length) : new Integer(0));
        if (this.digest != null) {
            oo.write(this.digest);
        }
    }
}

