/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.ds.file;

import com.wily.rave.agent.config.DirectoryScanSpec;
import com.wily.rave.agent.ds.IDataSourceListener;
import com.wily.rave.agent.ds.exception.StopCollectionException;
import com.wily.rave.agent.ds.file.DirScannerListener;
import com.wily.rave.agent.ds.file.FileSet;
import com.wily.rave.agent.ds.file.FileSystemMonitor;
import com.wily.rave.agent.ds.file.fileSpec.RealFileSpec;
import com.wily.rave.agent.ds.task.IDataSourceTask;
import com.wily.rave.agent.task.Schedule;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.File;
import java.io.IOException;

class DirectoryScanner
implements IDataSourceTask {
    private FileSystemMonitor fsMonitor;
    private DirectoryScanSpec scanSpec;
    private IModuleFeedbackChannel feedback;
    private DirScannerListener scanListener;
    private static final Schedule kSchedule = Schedule.getOneRunSchedule();

    public DirectoryScanner(FileSystemMonitor monitor, DirectoryScanSpec spec, DirScannerListener scanListener) {
        this.fsMonitor = monitor;
        this.scanSpec = spec;
        this.feedback = this.fsMonitor.getDSListener().getFeedback();
        this.scanListener = scanListener;
    }

    public void schedule() {
        this.fsMonitor.getDSListener().addCollectionTask(this, kSchedule, String.valueOf(this.fsMonitor.getDataSourceName()) + ":" + this.getClass().getName() + ':' + this.scanSpec.toString());
    }

    @Override
    public void collect() {
        FileSet fileSet = new FileSet(this.feedback);
        try {
            try {
                this.feedback.debug("Looking for file changes in root directory " + this.scanSpec.getRootDirectory().getCanonicalPath());
                this.findFilesToTrack(fileSet, this.scanSpec.getRootDirectory());
                this.feedback.debug(String.valueOf(fileSet.size()) + " files in " + this.scanSpec);
            }
            catch (IOException ioe) {
                this.feedback.error("Failed scanning directory!", ioe);
                throw new StopCollectionException("Failed scanning directory" + ioe.getMessage());
            }
        }
        finally {
            this.scanListener.report(this, fileSet);
        }
    }

    private void findFilesToTrack(FileSet fileSet, File fileOrDirectory) {
        File[] subFiles;
        if (fileOrDirectory.isDirectory() && this.scanSpec.shouldProcessSubDirectory(fileOrDirectory) && (subFiles = fileOrDirectory.listFiles(this.scanSpec.getFilePatternFilter())) != null) {
            int i = 0;
            while (i < subFiles.length) {
                if (subFiles[i].isFile()) {
                    try {
                        fileSet.addFile(RealFileSpec.get(subFiles[i]));
                    }
                    catch (IOException e) {
                        this.feedback.error("Failed scanning directory!", e);
                        throw new StopCollectionException("Failed scanning directory!" + e.getMessage());
                    }
                } else if (this.scanSpec.isRecursive()) {
                    this.findFilesToTrack(fileSet, subFiles[i]);
                }
                ++i;
            }
        }
    }

    @Override
    public void init(IDataSourceListener listener) {
    }

    @Override
    public void stop() {
    }

    @Override
    public void restartScan() {
        this.fsMonitor.restartScan();
    }

    @Override
    public void restartCollection() {
        this.fsMonitor.restartCollection();
    }
}

