/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.ds.file;

import com.wily.rave.agent.ds.exception.RestartCollectionException;
import com.wily.rave.agent.ds.exception.RestartScanException;
import com.wily.rave.agent.ds.file.ArchiveFileInfoHolder;
import com.wily.rave.agent.ds.file.ArchiveMonitor;
import com.wily.rave.agent.ds.file.FileSet;
import com.wily.rave.agent.ds.file.FileSystemMonitor;
import com.wily.rave.agent.ds.file.fileSpec.IFileSpecRuntime;
import com.wily.rave.agent.ds.file.fileSpec.ZipEntryFileSpec;
import com.wily.rave.agent.ds.file.fileSpec.ZipEntryFileSpecRuntime;
import com.wily.rave.spec.ds.filemonitor.BinaryFileContent;
import com.wily.rave.spec.ds.filemonitor.FileContent;
import com.wily.rave.utils.FastMD5Encoder;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

class JarFileWalker {
    private final FileSet fPrevFileSet;
    private ArchiveMonitor fArchiveMonitor;
    private IModuleFeedbackChannel fFeedback;
    private ArchiveFileInfoHolder fArchive;

    public JarFileWalker(ArchiveMonitor archiveMonitor, ArchiveFileInfoHolder archive, FileSet prevFileSet) {
        this.fArchive = archive;
        this.fArchiveMonitor = archiveMonitor;
        this.fFeedback = this.fArchiveMonitor.getFileSystemMonitor().getDSListener().getFeedback();
        this.fPrevFileSet = prevFileSet;
    }

    public void collectContent() throws RestartCollectionException, RestartScanException {
        ZipFile jarFile = null;
        FileSet newFileSet = new FileSet(this.fFeedback);
        try {
            File archiveFile = this.fArchive.getFile();
            if (!archiveFile.exists()) {
                this.fFeedback.info("Archive file " + this.fArchive + " deleted before archive monitor could process it. Ignoring...");
                return;
            }
            try {
                try {
                    jarFile = new JarFile(this.fArchive.getFile());
                    Enumeration<JarEntry> fEntries = ((JarFile)jarFile).entries();
                    while (fEntries.hasMoreElements()) {
                        ZipEntry nextEntry = fEntries.nextElement();
                        if (nextEntry.isDirectory()) continue;
                        ZipEntryFileSpecRuntime fileS = new ZipEntryFileSpecRuntime(ZipEntryFileSpec.get(this.fArchive.getFileSpec(), nextEntry.getName()), jarFile, nextEntry);
                        this.pollAndReportFileContent(fileS, newFileSet);
                    }
                    this.reportDeletions();
                }
                catch (ZipException ex) {
                    if (this.fArchive.getSize() != 0L) {
                        this.fFeedback.warn("File " + this.fArchive + " does not appear to be an archive file, treating as regular file (see exception)!", ex);
                    }
                }
                catch (InternalError ex) {
                    this.fFeedback.warn("Caught InternalError exception while enumerating jar, this is probably due to Java bug ID 4615343, and if so, should not persist. Ignoring this error.");
                    this.fFeedback.debug("Stack", ex);
                }
                FileSystemMonitor fileSystemMonitor = this.fArchiveMonitor.getFileSystemMonitor();
                BinaryFileContent fileContent = null;
                if (fileSystemMonitor.getConfigurationProps().useDigest != 2) {
                    byte[] digest = new byte[]{};
                    try {
                        digest = FastMD5Encoder.getInstance().encode(this.fArchive.getFile());
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                    fileContent = new BinaryFileContent(fileSystemMonitor.getDSListener().getDSInstance(), this.fArchive.getFileSpec().getFullName(), this.fArchive.getFileSpec().getFileOwner(), this.fArchive.getLastModifiedTime(), this.fArchive.getSize(), digest);
                } else {
                    fileContent = new BinaryFileContent(fileSystemMonitor.getDSListener().getDSInstance(), this.fArchive.getFileSpec().getFullName(), this.fArchive.getFileSpec().getFileOwner(), this.fArchive.getLastModifiedTime(), this.fArchive.getSize());
                }
                fileSystemMonitor.reportChangeEvent((FileContent)fileContent, this.fArchive.getFileSpec(), this.fArchive.newFile());
                this.fPrevFileSet.addAll(newFileSet);
            }
            catch (IOException ex) {
                this.fFeedback.error("Error tracking change in file " + this.fArchive + ". No data will be reported for this file in this run (although data for its contents may have already been reported).", ex);
            }
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException ex) {
                    this.fFeedback.error("Failed closing file " + this.fArchive, ex);
                }
            }
        }
    }

    private void reportDeletions() throws RestartCollectionException, RestartScanException {
        FileSystemMonitor fileSystemMonitor = this.fArchiveMonitor.getFileSystemMonitor();
        Iterator oldFiles = this.fPrevFileSet.getFileIterator();
        while (oldFiles.hasNext()) {
            ZipEntryFileSpec fileS = (ZipEntryFileSpec)oldFiles.next();
            fileSystemMonitor.reportDeletion(fileS);
        }
    }

    private void pollAndReportFileContent(IFileSpecRuntime fileS, FileSet newFileSet) throws IOException, RestartCollectionException, RestartScanException {
        newFileSet.addFile(fileS.getFileSpec());
        this.fPrevFileSet.removeFile(fileS.getFileSpec());
        this.fArchiveMonitor.getFileSystemMonitor().pollAndReportFileContent(fileS);
    }
}

