/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.ds.states;

import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.rave.agent.ds.DataSourceListener;
import com.wily.rave.agent.ds.exception.ADataSourceCollectionException;
import com.wily.rave.agent.ds.exception.StopCollectionException;
import com.wily.rave.agent.ds.states.AAgentDataSourceState;
import com.wily.rave.agent.ds.states.IAgentDataSourceState;
import com.wily.rave.agent.ds.states.ReadyForData;
import com.wily.rave.exceptions.ACommException;
import java.io.IOException;

public class StartState
extends AAgentDataSourceState {
    private static final long serialVersionUID = 1L;
    private static final StartState singletonState = new StartState();

    public static AAgentDataSourceState getDataSourceState() {
        return singletonState;
    }

    @Override
    public IAgentDataSourceState transitionToState(DataSourceListener dsCtx) throws ConnectionException, ACommException, ADataSourceCollectionException {
        super.transitionToState(dsCtx);
        try {
            dsCtx.newCache();
        }
        catch (IOException e) {
            dsCtx.getFeedback().error("Failed to rewrite cache!", e);
            throw new StopCollectionException("Failed to rewrite cache! " + e.getMessage());
        }
        dsCtx.getWatchedAgentBean().newDS(dsCtx.getDSInstance());
        return ReadyForData.getDataSourceState();
    }

    @Override
    public IAgentDataSourceState crash(DataSourceListener dsCtx, Throwable ex) throws ACommException, ConnectionException, ADataSourceCollectionException {
        if (ex == null || ex instanceof ConnectionException) {
            return this.transitionToState(dsCtx);
        }
        return super.crash(dsCtx, ex);
    }

    private Object readResolve() {
        return singletonState;
    }
}

