/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.leakhunter;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.leakhunter.BadCollectionFilter;
import com.wily.util.IConfigurationListener;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.io.ExtendedFile;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.resource.IResource;
import com.wily.util.text.IStringLocalizer;
import java.io.File;

public final class LeakHunterSettings {
    private static final String kLeakHunterPropertyPrefix = "introscope.agent.leakhunter.";
    private static final String kLeakHunterLogFilePropertyPrefix = "introscope.agent.leakhunter.logfile.";
    private static final String kEnablePropertyKey = "introscope.agent.leakhunter.enable";
    private static final String kLogFileAppendPropertyKey = "introscope.agent.leakhunter.logfile.append";
    private static final String kLogFileLocationPropertyKey = "introscope.agent.leakhunter.logfile.location";
    private static final String kLeakSensitivityPropertyKey = "introscope.agent.leakhunter.leakSensitivity";
    private static final String kTimeoutInMinutesPropertyKey = "introscope.agent.leakhunter.timeoutInMinutes";
    private static final String kPotentialLeakLimitPropertyKey = "introscope.agent.leakhunter.potentialLeakLimit";
    private static final String kTrackedReferenceLimitPropertyKey = "introscope.agent.leakhunter.trackedReferenceLimit";
    public static final String kPollPeriodInSecondsPropertyKey = "introscope.agent.leakhunter.pollPeriodInSeconds";
    private static final String kCollectAllocationStackTracesPropertyKey = "introscope.agent.leakhunter.collectAllocationStackTraces";
    public static final String kBadCollectionGlobListKeyPrefix = "introscope.agent.leakhunter.ignore";
    private static final boolean kEnableDefaultValue = false;
    private static final boolean kLogFileAppendDefaultValue = false;
    private static final String kLogFileLocationDefaultValue = null;
    private static final int kLeakSensitivityDefaultValue = 5;
    public static final int kTimeoutInMinutesDefaultValue = 120;
    private static final int kPotentialLeakLimitDefaultValue = 1000;
    private static final int kTrackedReferenceLimitDefaultValue = 100000;
    public static final int kPollPeriodInSecondsDefaultValue = 15;
    private static final boolean kCollectAllocationStackTracesDefaultValue = false;
    private final boolean fEnabled;
    private final boolean fLogFileAppend;
    private final String fLogFileLocation;
    private final int fLeakSensitivity;
    private final long fTimeoutInMinutes;
    private final int fPotentialLeakLimit;
    private final int fTrackedReferenceLimit;
    private final int fPollPeriodInSeconds;
    private boolean fCollectAllocationStackTraces;
    private final IModuleFeedbackChannel fFeedback;
    private final IStringLocalizer fLocalizer;
    private final IResource fResource;
    private BadCollectionFilter fBadCollectionFilter;
    private IAgent fAgent;
    private IConfigurationListener fListener;

    LeakHunterSettings(IndexedProperties properties, IModuleFeedbackChannel feedback, IStringLocalizer localizer, IResource resource) {
        this.fFeedback = feedback;
        this.fLocalizer = localizer;
        this.fResource = resource;
        this.fEnabled = this.loadEnabled(properties);
        this.fLogFileAppend = this.fEnabled ? this.loadLogFileAppend(properties) : false;
        this.fLogFileLocation = this.fEnabled ? this.loadLogFileLocation(properties) : kLogFileLocationDefaultValue;
        this.fLeakSensitivity = this.fEnabled ? this.loadLeakSensitivity(properties) : 5;
        this.fTimeoutInMinutes = this.fEnabled ? (long)this.loadTimeoutInMinutes(properties) : 120L;
        this.fPotentialLeakLimit = this.fEnabled ? this.loadPotentialLeakLimit(properties) : 1000;
        this.fTrackedReferenceLimit = this.fEnabled ? this.loadTrackedReferenceLimit(properties) : 100000;
        this.fPollPeriodInSeconds = this.fEnabled ? this.loadPollPeriodInSeconds(properties) : 15;
        this.fCollectAllocationStackTraces = this.fEnabled ? this.loadCollectAllocationStackTraces(properties) : false;
        this.fBadCollectionFilter = new BadCollectionFilter(properties.getAndCondenseAllTrimmedIndexedProperties(kBadCollectionGlobListKeyPrefix));
        try {
            this.fAgent = AgentShim.getAgent();
            this.fListener = new IConfigurationListener(){

                @Override
                public void onChange(IndexedProperties props) {
                    boolean collectAllocationStackTraces = props.safeGetBooleanProperty(LeakHunterSettings.kCollectAllocationStackTracesPropertyKey, false, LeakHunterSettings.this.getModuleFeedback(), LeakHunterSettings.this.getStringLocalizer());
                    if (LeakHunterSettings.this.fCollectAllocationStackTraces != collectAllocationStackTraces) {
                        LeakHunterSettings.this.fCollectAllocationStackTraces = collectAllocationStackTraces;
                        LeakHunterSettings.this.fAgent.IAgent_getModuleFeedback().info("Leakhunter CollectAllocationStackTraces property has been updated to " + LeakHunterSettings.this.fCollectAllocationStackTraces);
                    }
                }
            };
            this.fAgent.addConfigurationListener(this.fListener);
        }
        catch (AgentNotAvailableException agentNotAvailableException) {}
    }

    public IModuleFeedbackChannel getModuleFeedback() {
        return this.fFeedback;
    }

    public IStringLocalizer getStringLocalizer() {
        return this.fLocalizer;
    }

    private boolean loadEnabled(IndexedProperties properties) {
        boolean enabled = properties.safeGetBooleanProperty(kEnablePropertyKey, false, this.getModuleFeedback(), this.getStringLocalizer());
        if (enabled) {
            this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getLocalizedString("LeakHunter_Settings_Enabled"));
        } else {
            this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getLocalizedString("LeakHunter_Settings_Disabled"));
        }
        return enabled;
    }

    private boolean loadLogFileAppend(IndexedProperties properties) {
        return properties.safeGetBooleanProperty(kLogFileAppendPropertyKey, false, this.getModuleFeedback(), this.getStringLocalizer());
    }

    private String loadLogFileLocation(IndexedProperties properties) {
        String location = properties.getTrimmedProperty(kLogFileLocationPropertyKey, kLogFileLocationDefaultValue);
        if (location != null && location.length() == 0) {
            location = null;
        }
        if (location == null) {
            this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getLocalizedString("LeakHunter_Settings_No_Log_File"));
        } else {
            File f = new File(location);
            if (!f.isAbsolute() && this.fResource != null && this.fResource.IResource_isFileResource()) {
                String userDir;
                File logFileLocation = new File(f.getAbsolutePath());
                String logFileParentPath = logFileLocation.getParent();
                if (logFileParentPath.startsWith(userDir = System.getProperty("user.dir"))) {
                    File resourceFile = new File(this.fResource.IResource_getLocation()).getParentFile();
                    location = String.valueOf(resourceFile.getPath()) + File.separator + location;
                } else {
                    location = logFileLocation.getAbsolutePath();
                }
            }
            ExtendedFile logFile = new ExtendedFile(location);
            location = logFile.safeGetCanonicalPath();
        }
        return location;
    }

    private int loadLeakSensitivity(IndexedProperties properties) {
        int leakSensitivity = properties.safeGetIntProperty(kLeakSensitivityPropertyKey, 5, this.getModuleFeedback(), this.getStringLocalizer());
        if (leakSensitivity < 1 || leakSensitivity > 10) {
            this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("LeakHunter_Settings_Invalid_Leak_Sensitivity", String.valueOf(leakSensitivity), String.valueOf(5)));
            leakSensitivity = 5;
        } else {
            this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("LeakHunter_Settings_Leak_Sensitivity", String.valueOf(leakSensitivity)));
        }
        return leakSensitivity;
    }

    private int loadTimeoutInMinutes(IndexedProperties properties) {
        int timeoutInMinutes = properties.safeGetNonNegativeIntProperty(kTimeoutInMinutesPropertyKey, 120, this.getModuleFeedback(), this.getStringLocalizer());
        if (timeoutInMinutes == 0) {
            this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getLocalizedString("LeakHunter_Settings_No_Timeout"));
        } else {
            this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("LeakHunter_Settings_Timeout_In_Minutes", String.valueOf(timeoutInMinutes)));
        }
        return timeoutInMinutes;
    }

    private int loadPotentialLeakLimit(IndexedProperties properties) {
        int potentialLeakLimit = 1000;
        if (properties.getProperty(kPotentialLeakLimitPropertyKey) != null) {
            potentialLeakLimit = properties.safeGetPositiveIntProperty(kPotentialLeakLimitPropertyKey, 1000, this.getModuleFeedback(), this.getStringLocalizer());
            this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("LeakHunter_Settings_Potential_Leak_Limit", String.valueOf(potentialLeakLimit)));
        }
        return potentialLeakLimit;
    }

    private int loadTrackedReferenceLimit(IndexedProperties properties) {
        int potentialLeakLimit = 100000;
        if (properties.getProperty(kTrackedReferenceLimitPropertyKey) != null) {
            potentialLeakLimit = properties.safeGetPositiveIntProperty(kTrackedReferenceLimitPropertyKey, 100000, this.getModuleFeedback(), this.getStringLocalizer());
            this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("LeakHunter_Settings_Tracked_Reference_Limit", String.valueOf(potentialLeakLimit)));
        }
        return potentialLeakLimit;
    }

    private int loadPollPeriodInSeconds(IndexedProperties properties) {
        int pollPeriodInSeconds = 15;
        if (properties.getProperty(kPollPeriodInSecondsPropertyKey) != null) {
            pollPeriodInSeconds = properties.safeGetPositiveIntProperty(kPollPeriodInSecondsPropertyKey, 15, this.getModuleFeedback(), this.getStringLocalizer());
            this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("LeakHunter_Settings_Polling_Period", String.valueOf(pollPeriodInSeconds)));
        }
        return pollPeriodInSeconds;
    }

    private boolean loadCollectAllocationStackTraces(IndexedProperties properties) {
        boolean collectAllocationStackTraces = properties.safeGetBooleanProperty(kCollectAllocationStackTracesPropertyKey, false, this.getModuleFeedback(), this.getStringLocalizer());
        if (collectAllocationStackTraces) {
            this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getLocalizedString("LeakHunter_Settings_Collect_Allocation_Stack_Traces"));
        } else {
            this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getLocalizedString("LeakHunter_Settings_Do_Not_Collect_Allocation_Stack_Traces"));
        }
        return collectAllocationStackTraces;
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    public boolean isAppendMode() {
        return this.fLogFileAppend;
    }

    public String getLogFileLocation() {
        return this.fLogFileLocation;
    }

    public int getLeakSensitivity() {
        return this.fLeakSensitivity;
    }

    public boolean hasTimeout() {
        return this.fTimeoutInMinutes > 0L;
    }

    public long getTimeoutInMinutes() {
        return this.fTimeoutInMinutes;
    }

    public int getPotentialLeakLimit() {
        return this.fPotentialLeakLimit;
    }

    public int getTrackedReferenceLimit() {
        return this.fTrackedReferenceLimit;
    }

    public int getPollPeriodInSeconds() {
        return this.fPollPeriodInSeconds;
    }

    public boolean collectAllocationStackTraces() {
        return this.fCollectAllocationStackTraces;
    }

    public void addToIgnoreList(String className) {
        this.fBadCollectionFilter.ignoreClassOfName(className);
    }

    public BadCollectionFilter getBadCollectionFilter() {
        return this.fBadCollectionFilter;
    }
}

