/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.leakhunter;

import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.leakhunter.ITrackedLeakReference;
import com.wily.introscope.agent.leakhunter.ITrackedLeakReferenceCreator;
import com.wily.introscope.agent.leakhunter.LeakHunterLogFile;
import com.wily.introscope.agent.leakhunter.LeakHunterMetrics;
import com.wily.introscope.agent.leakhunter.LeakHunterSettings;
import com.wily.introscope.agent.leakhunter.PotentialLeakHashMap;
import com.wily.util.adt.IGuaranteedCounter;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;

final class PotentialLeakTracker {
    private final PotentialLeakHashMap fTrackedReferences = new PotentialLeakHashMap();
    private final IAgent fAgent;
    private final LeakHunterSettings fSettings;
    private final LeakHunterMetrics fGeneralMetrics;
    private final LeakHunterLogFile fLogFile;
    private final IntervalHeartbeat fHeartbeat;
    private int fPotentialLeakCount;
    private final IGuaranteedCounter fTrackedReferenceCount;
    private static volatile boolean sTrackedReferenceLimitReached = false;

    PotentialLeakTracker(IAgent agent, LeakHunterSettings settings, LeakHunterLogFile logFile) {
        this.fAgent = agent;
        this.fSettings = settings;
        this.fGeneralMetrics = new LeakHunterMetrics(this.fSettings);
        this.fLogFile = logFile;
        this.fHeartbeat = agent.IAgent_getCommonHeartbeat();
        this.fPotentialLeakCount = 0;
        this.fTrackedReferenceCount = agent.IAgent_getGuaranteedCounter();
        this.fTrackedReferenceCount.reset();
        this.getHeartbeat().addBehavior((ITimestampedRunnable)new PotentialLeakPoller(), "LeakHunter Potential Leak Poller", true, (long)(this.fSettings.getPollPeriodInSeconds() * 1000), false);
        if (this.fSettings.getTimeoutInMinutes() > 0L) {
            long millisecondTimeout = this.fSettings.getTimeoutInMinutes() * 1000L * 60L;
            if (millisecondTimeout < 0L) {
                this.getAgent().IAgent_getModuleFeedback().warn(this.getAgent().IAgent_getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("LeakHunter_Timeout_Invalid_Value", String.valueOf(this.fSettings.getTimeoutInMinutes()), String.valueOf(millisecondTimeout), String.valueOf(120)));
                millisecondTimeout = 120L;
            }
            this.getHeartbeat().addBehavior(new LeakHunterTimeoutHandler(), "LeakHunter Timeout Handler", true, millisecondTimeout, false, 1);
        }
    }

    private LeakHunterSettings getLeakHunterSettings() {
        return this.fSettings;
    }

    private LeakHunterLogFile getLeakHunterLogFile() {
        return this.fLogFile;
    }

    public final IAgent getAgent() {
        return this.fAgent;
    }

    public final IModuleFeedbackChannel getModuleFeedback() {
        return this.getLeakHunterSettings().getModuleFeedback();
    }

    public final IStringLocalizer getStringLocalizer() {
        return this.getLeakHunterSettings().getStringLocalizer();
    }

    private int getPotentialLeakLimit() {
        return this.getLeakHunterSettings().getPotentialLeakLimit();
    }

    private int getTrackedReferenceLimit() {
        return this.getLeakHunterSettings().getTrackedReferenceLimit();
    }

    private IntervalHeartbeat getHeartbeat() {
        return this.fHeartbeat;
    }

    private int getPotentialLeakCount() {
        return this.fPotentialLeakCount;
    }

    public boolean isActive() {
        return this.fTrackedReferences.isActive();
    }

    public ITrackedLeakReference createIfNecessary(Object trackedObject, ITrackedLeakReferenceCreator creator) {
        ITrackedLeakReference result = this.fTrackedReferences.get(trackedObject);
        if (result == null && this.isActive()) {
            if (this.fTrackedReferenceCount.peek() >= this.getTrackedReferenceLimit()) {
                if (!sTrackedReferenceLimitReached) {
                    this.getModuleFeedback().warn(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("LeakHunter_Tracked_Reference_Limit_Reached", String.valueOf(this.getTrackedReferenceLimit())));
                    sTrackedReferenceLimitReached = true;
                }
                return null;
            }
            ITrackedLeakReference reference = creator.createReference(trackedObject);
            if (reference != null && (result = this.fTrackedReferences.put(trackedObject, reference)) == reference) {
                this.fGeneralMetrics.addTrackedLeakReference(reference);
                this.fTrackedReferenceCount.next();
                Assertion.wilyAssert(false);
            }
        }
        return result;
    }

    public ITrackedLeakReference findLeakReference(Object trackedObject) {
        ITrackedLeakReference result = this.fTrackedReferences.get(trackedObject);
        return result;
    }

    private void removeTrackedLeakReference(ITrackedLeakReference trackedLeakReference) {
        Assertion.wilyAssert(false);
        if (trackedLeakReference != null) {
            this.fTrackedReferences.remove(trackedLeakReference);
            this.fGeneralMetrics.removeTrackedLeakReference(trackedLeakReference);
            if (trackedLeakReference.ITrackedLeakReference_isPotentialLeak()) {
                --this.fPotentialLeakCount;
            }
            trackedLeakReference.ITrackedLeakReference_tearDown();
            this.fTrackedReferenceCount.prev();
        }
    }

    private void checkTrackedLeakReferences(long nowInMillis) {
        ITrackedLeakReference[] snapshot = this.fTrackedReferences.snapshot();
        int i = 0;
        while (i < snapshot.length) {
            this.checkTrackedLeakReference(snapshot[i], nowInMillis);
            if (this.getPotentialLeakCount() >= this.getPotentialLeakLimit()) {
                this.handleOverPotentialLeakLimit();
                this.checkRemainingReferencesInSnapshot(snapshot, i, nowInMillis);
                break;
            }
            ++i;
        }
    }

    private void checkRemainingReferencesInSnapshot(ITrackedLeakReference[] trackedLeakReferencesSnapshot, int currentIndex, long nowInMillis) {
        int i = currentIndex + 1;
        while (i < trackedLeakReferencesSnapshot.length) {
            ITrackedLeakReference reference = trackedLeakReferencesSnapshot[i];
            if (this.fTrackedReferences.contains(reference)) {
                Assertion.wilyAssert(false);
                this.checkTrackedLeakReference(reference, nowInMillis);
            }
            ++i;
        }
    }

    private void checkTrackedLeakReference(ITrackedLeakReference reference, long nowInMillis) {
        if (reference.ITrackedLeakReference_isValidReference()) {
            boolean wasPotentialLeak;
            block5: {
                wasPotentialLeak = reference.ITrackedLeakReference_isPotentialLeak();
                try {
                    reference.ITrackedLeakReference_checkForLeak(nowInMillis);
                }
                catch (Exception e) {
                    Object referent = reference.ITrackedLeakReference_getReference().get();
                    if (referent == null) break block5;
                    String className = referent.getClass().getName();
                    this.getAgent().IAgent_getModuleFeedback().warn("Class " + className + " appears to have an unsafe size() method. " + "Objects of this type will no longer be checked. " + "Add " + className + " to the list of introscope.agent.leakhunter.ignore properties");
                    this.getAgent().IAgent_getModuleFeedback().verbose(e);
                    this.fSettings.addToIgnoreList(className);
                }
            }
            boolean isPotentialLeak = reference.ITrackedLeakReference_isPotentialLeak();
            if (isPotentialLeak && !wasPotentialLeak) {
                this.fGeneralMetrics.addPotentialLeak(reference);
                ++this.fPotentialLeakCount;
            }
        } else {
            this.removeTrackedLeakReference(reference);
        }
    }

    private void handleOverPotentialLeakLimit() {
        if (this.isActive()) {
            this.getModuleFeedback().warn(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("LeakHunter_Potential_Leak_Limit_Reached", String.valueOf(this.getPotentialLeakLimit())));
            this.switchToPassiveMode();
        }
    }

    private void handleTimeout() {
        if (this.isActive()) {
            if (this.fSettings.isEnabled()) {
                this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("LeakHunter_Timeout_Occurred", String.valueOf(this.getPotentialLeakCount())));
                this.getLeakHunterLogFile().logTimeout(this.getPotentialLeakCount());
            }
            this.switchToPassiveMode();
        }
    }

    public void switchToPassiveMode() {
        if (this.fTrackedReferences.setInactive()) {
            this.removeAllNonPotentialLeakReferences();
        }
    }

    private void removeAllNonPotentialLeakReferences() {
        ITrackedLeakReference[] snapshot = this.fTrackedReferences.snapshot();
        int i = 0;
        while (i < snapshot.length) {
            ITrackedLeakReference reference = snapshot[i];
            if (!reference.ITrackedLeakReference_isPotentialLeak()) {
                this.fTrackedReferences.remove(reference);
                reference.ITrackedLeakReference_tearDown();
            }
            ++i;
        }
        this.fGeneralMetrics.setTrackedLeakReferenceCount(this.fTrackedReferences.size());
    }

    public int debug_getTrackedLeakCount() {
        return this.fTrackedReferences.size();
    }

    private class LeakHunterTimeoutHandler
    implements ITimestampedRunnable {
        private LeakHunterTimeoutHandler() {
        }

        @Override
        public void ITimestampedRunnable_execute(long nowInMillis) {
            try {
                PotentialLeakTracker.this.handleTimeout();
            }
            catch (Throwable t) {
                try {
                    PotentialLeakTracker.this.getAgent().IAgent_safeReportError("LeakHunter error handling timeout", t);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private class PotentialLeakPoller
    implements ITimestampedRunnable {
        private PotentialLeakPoller() {
        }

        @Override
        public void ITimestampedRunnable_execute(long nowInMillis) {
            try {
                PotentialLeakTracker.this.checkTrackedLeakReferences(nowInMillis);
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError((String)"LeakHunter error on potential leak check", (Throwable)t);
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

