/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util;

import com.wily.util.IComparer;
import java.util.Vector;

public class Sorter {
    private Sorter() {
    }

    public static void sort(Object[] objs, IComparer comparer) {
        Sorter.quicksort(objs, comparer, 0, objs.length - 1);
    }

    public static void sort(Vector vec, IComparer comparer) {
        Object[] objs = new Object[vec.size()];
        vec.copyInto(objs);
        Sorter.quicksort(objs, comparer, 0, objs.length - 1);
        vec.removeAllElements();
        vec.ensureCapacity(objs.length);
        for (int i = 0; i < objs.length; ++i) {
            vec.addElement(objs[i]);
        }
    }

    public static void quicksort(Object[] objs, IComparer comparer, int left, int right) {
        if (left >= right) {
            return;
        }
        if (right - left < 9) {
            Sorter.selectionSort(objs, comparer, left, right);
            return;
        }
        Object pivot = objs[(left + right) / 2];
        int i = left;
        int j = right;
        while (i < j) {
            while (comparer.lessThan(objs[i], pivot)) {
                ++i;
            }
            while (i < j && comparer.lessThan(pivot, objs[j])) {
                --j;
            }
            if (i >= j) continue;
            Sorter.swap(objs, i, j);
            if (objs[i] != pivot) {
                ++i;
            }
            if (objs[j] == pivot) continue;
            --j;
        }
        Sorter.quicksort(objs, comparer, left, i - 1);
        Sorter.quicksort(objs, comparer, j + 1, right);
    }

    public static void selectionSort(Object[] objs, IComparer comparer, int left, int right) {
        for (int i = left; i < right; ++i) {
            int least = i;
            for (int j = i; j < right + 1; ++j) {
                if (!comparer.lessThan(objs[j], objs[least])) continue;
                least = j;
            }
            Sorter.swap(objs, i, least);
        }
    }

    private static void swap(Object[] objs, int i, int j) {
        Object temp = objs[i];
        objs[i] = objs[j];
        objs[j] = temp;
    }
}

