/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public final class NonSyncBufferedWriter
extends FilterWriter {
    protected static final int kDefaultBufferSize = 8192;
    private char[] fBuffer = new char[8192];
    private int fBufferIndex;

    public NonSyncBufferedWriter(Writer output) {
        super(output);
    }

    public void close() throws IOException {
        this.checkWriter();
        if (this.fBufferIndex != 0) {
            this.flush();
        }
        this.out.close();
        this.out = null;
    }

    public void flush() throws IOException {
        this.checkWriter();
        this.out.write(this.fBuffer, 0, this.fBufferIndex);
        this.out.flush();
        this.fBufferIndex = 0;
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.checkWriter();
        do {
            if (this.fBufferIndex == 8192) {
                this.flush();
            }
            int bufferLeft = 8192 - this.fBufferIndex;
            int newOff = -1;
            int newLen = -1;
            if (len > bufferLeft) {
                newLen = len - bufferLeft;
                newOff = off + bufferLeft;
                len = bufferLeft;
            }
            System.arraycopy(cbuf, off, this.fBuffer, this.fBufferIndex, len);
            this.fBufferIndex += len;
            len = newLen;
            off = newOff;
        } while (len > 0);
    }

    public void write(int c) throws IOException {
        this.checkWriter();
        if (this.fBufferIndex == 8192) {
            this.flush();
        }
        this.fBuffer[this.fBufferIndex++] = (char)c;
    }

    public void write(String str, int off, int len) throws IOException {
        this.write(str.toCharArray(), off, len);
    }

    private void checkWriter() throws IOException {
        if (this.out == null) {
            throw new IOException("Writer may have been closed");
        }
    }
}

