/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.preflight;

import com.wily.util.ApplicationUIHelper;
import com.wily.util.preflight.PreflightMessage;
import com.wily.util.preflight.modules.IPreflightModule;
import java.util.Vector;

public class PreflightCaptain {
    public static PreflightMessage[] performCheck(IPreflightModule[] modules) {
        Vector<PreflightMessage[]> messageBag = new Vector<PreflightMessage[]>();
        int totalMessageCount = 0;
        for (int i = 0; i < modules.length; ++i) {
            PreflightMessage[] messageList = modules[i].IPreflightModule_doCheck();
            messageBag.addElement(messageList);
            totalMessageCount += messageList.length;
        }
        PreflightMessage[] resultMessages = new PreflightMessage[totalMessageCount];
        int resultIndex = 0;
        for (int i = 0; i < messageBag.size(); ++i) {
            PreflightMessage[] messageList = (PreflightMessage[])messageBag.elementAt(i);
            for (int j = 0; j < messageList.length; ++j) {
                resultMessages[resultIndex++] = messageList[j];
            }
        }
        return resultMessages;
    }

    public static PreflightMessage[] performCheck(IPreflightModule module) {
        return PreflightCaptain.performCheck(new IPreflightModule[]{module});
    }

    public static boolean performCheckWithExit(IPreflightModule[] modules, boolean useUI) {
        PreflightMessage[] messages = PreflightCaptain.performCheck(modules);
        Vector<String> errorMessages = new Vector<String>();
        for (int i = 0; i < messages.length; ++i) {
            if (messages[i].isFatal()) {
                errorMessages.addElement(messages[i].getMessage());
                continue;
            }
            if (messages[i].isSuccessful() || messages[i].isFatal()) continue;
            System.err.println(messages[i].getMessage());
        }
        if (errorMessages.size() > 0) {
            String[] errorStrings = new String[errorMessages.size()];
            for (int i = 0; i < errorMessages.size(); ++i) {
                errorStrings[i] = (String)errorMessages.elementAt(i);
            }
            ApplicationUIHelper.handleLaunchFailure(errorStrings, useUI);
            return true;
        }
        return false;
    }
}

