/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.soa.wm.agent.tracers;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.introscope.soa.wm.agent.tracers.WmAgentClassLoaderUtils;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Method;

public class SoapRequestDataOutboundTracer
extends ASingleInstanceTracerFactory {
    private static final String kCOR_HEADER_NAME = "WSCorIDSOAPHeader";
    private static final String kCOR_HEADER_NS = "http://www.ca.com/apm";

    public SoapRequestDataOutboundTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void ITracer_finishTrace(int arg0, InvocationData data) {
        try {
            WMUtils.getLogger().debug("START:SoapRequestDataOutboundTracer.ITracer_finishTrace()");
            data.getInvocationParameterAsObject(0);
            WmAgentClassLoaderUtils.getClassIntance("com.wm.data.IData", data);
            WmAgentClassLoaderUtils.getClassIntance("com.wm.data.ValuesEmulator", data);
            Object objValue = data.get("outbound");
            WMUtils.getLogger().debug("SoapRequestDataOutboundTracer.ITracer_finishTrace() objValue" + objValue);
            if (objValue != null && objValue.toString().equals("Y")) {
                if (!WMUtils.correlationSOAPInsertionEnabled()) {
                    return;
                }
            } else {
                WMUtils.getLogger().debug(" Return without update in SoapRequestDataOutboundTracer.ITracer_finishTrace()");
                return;
            }
            Object objSoapMessage = data.getInvocationReturnValueAsObject();
            Object objSoapHeader = objSoapMessage.getClass().getMethod("getSOAPHeader", new Class[0]).invoke(objSoapMessage, new Object[0]);
            Class<?> clsJavaXMLName = Class.forName("javax.xml.soap.Name", false, Thread.currentThread().getContextClassLoader());
            Class<?> clsName = Class.forName("com.wm.app.b2b.server.saaj.Name", false, Thread.currentThread().getContextClassLoader());
            Method mthCreateName = clsName.getMethod("create", String.class, String.class, String.class);
            Object objName = mthCreateName.invoke(null, kCOR_HEADER_NAME, "", kCOR_HEADER_NS);
            Object objCorSoapHeader = objSoapHeader.getClass().getMethod("addHeaderElement", clsJavaXMLName).invoke(objSoapHeader, objName);
            objCorSoapHeader.getClass().getMethod("addNamespaceDeclaration", String.class, String.class).invoke(objCorSoapHeader, kCOR_HEADER_NAME, kCOR_HEADER_NS);
            Method mthCreateAttrib = clsName.getMethod("create", String.class);
            Object objCorID = mthCreateAttrib.invoke(null, "CorID");
            String corID = new CorrelationId().getCurrentOutgoingCorrelationIdStrippedForHeader();
            WMUtils.getLogger().debug(String.valueOf(((Object)((Object)this)).getClass().getName()) + " corID:" + corID);
            objCorSoapHeader.getClass().getMethod("addAttribute", clsJavaXMLName, String.class).invoke(objCorSoapHeader, objCorID, corID);
            Object objRtrnValue = data.getInvocationReturnValueAsObject();
            WMUtils.getLogger().debug("objRtrnValue:" + objRtrnValue);
            WMUtils.getLogger().debug("END:SoapRequestDataOutboundTracer.ITracer_finishTrace()");
        }
        catch (Exception e) {
            WMUtils.getLogger().error(e.getMessage());
            WMUtils.getLogger().debug((Throwable)e);
        }
    }

    public void ITracer_startTrace(int arg0, InvocationData data) {
        try {
            Object objIData = data.getInvocationParameterAsObject(0);
            Class clsIData = WmAgentClassLoaderUtils.getClassIntance("com.wm.data.IData", data);
            Class clsValuesEmulator = WmAgentClassLoaderUtils.getClassIntance("com.wm.data.ValuesEmulator", data);
            Method mthGetValuesEm = clsValuesEmulator.getMethod("get", clsIData, String.class);
            Object objValue = mthGetValuesEm.invoke(null, objIData, "outbound");
            WMUtils.getLogger().debug("SoapRequestDataOutboundTracer.ITracer_finishTrace() objValue" + objValue);
            if (objValue != null && objValue.toString().equals("Y")) {
                data.put("outbound", (Object)"Y");
                Method mthRemovetValuesEm = clsValuesEmulator.getMethod("remove", clsIData, String.class);
                mthRemovetValuesEm.invoke(null, objIData, "outbound");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }
}

