/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.soa.wm.tn.agent.tracers;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.introscope.soa.wm.tn.agent.util.WmCache;
import com.wily.util.clock.MasterClock;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Method;
import java.sql.Timestamp;

public class ServiceExecTaskTracer
extends ASingleInstanceTracerFactory {
    public static final String kMethodNameGetTimestamp = "getTimestamp";
    public static final String kMethodNameGetBizDocEnvelope = "getBizDocEnvelope";
    public static final String kMethodNameDone = "done";
    public static final String kMethodNameFail = "fail";
    public static final String kRPIMetric = "RPIMetric";
    public static final String kARTMetric = "ARTMetric";
    public static final String kMetricSeperator = ":";

    public ServiceExecTaskTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    private Class getClassInstance(String className, InvocationData data) {
        Class<?> clsIData = null;
        try {
            clsIData = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception exception) {
            try {
                clsIData = Class.forName(className);
            }
            catch (Exception exception2) {}
        }
        if (clsIData == null) {
            try {
                clsIData = Class.forName(className, false, data.getInvocationObject().getClass().getClassLoader());
            }
            catch (Exception exception) {}
        }
        return clsIData;
    }

    public void ITracer_finishTrace(int arg0, InvocationData data) {
        try {
            data.getProbeInformation().getProbeIdentification().getProbeMethodName();
            Object objInvocationObject = data.getInvocationObject();
            try {
                String strProbeMethod;
                Object objOutputData = objInvocationObject.getClass().getMethod("getInputData", new Class[0]).invoke(objInvocationObject, new Object[0]);
                Class clsIData = this.getClassInstance("com.wm.data.IData", data);
                Class clsValuesEmulator = this.getClassInstance("com.wm.data.ValuesEmulator", data);
                Method mtGetValuesEm = clsValuesEmulator.getMethod("get", clsIData, String.class);
                Object objCorIdFound = mtGetValuesEm.invoke(null, objOutputData, "CorID");
                if (objCorIdFound != null) {
                    String cacheCorrelationId = objCorIdFound.toString();
                    this.getAgent().IAgent_getModuleFeedback().debug("ServiceExecTaskTracer.ITracer_finishTrace() cacheCorrelationId:" + cacheCorrelationId);
                    new CorrelationId(cacheCorrelationId, true);
                }
                if ((strProbeMethod = data.getProbeInformation().getProbeIdentification().getProbeMethodName()).equals("invoke")) {
                    return;
                }
            }
            catch (Exception e) {
                this.getAgent().IAgent_getModuleFeedback().error((Throwable)e);
            }
            Object objBizdocEnvelope = objInvocationObject.getClass().getMethod(kMethodNameGetBizDocEnvelope, new Class[0]).invoke(objInvocationObject, new Object[0]);
            Object objSQLTimestamp = objBizdocEnvelope.getClass().getMethod(kMethodNameGetTimestamp, new Class[0]).invoke(objBizdocEnvelope, new Object[0]);
            Timestamp startTimestamp = (Timestamp)objSQLTimestamp;
            long startTime = startTimestamp.getTime();
            long endTime = MasterClock.currentTimeMillis();
            long responsetime = endTime - startTime;
            this.getAgent().IAgent_getModuleFeedback().debug("ServiceExecTaskTracer.ITracer_finishTrace()responsetime is " + responsetime);
            String componentname = this.formatParameterizedName(data);
            DataAccumulatorFactory factory = this.getAgent().IAgent_getDataAccumulatorFactory();
            String strRPIMetricname = String.valueOf(componentname) + kMetricSeperator + this.getParameter(kRPIMetric);
            factory.safeGetLongIntervalCounterDataAccumulator(strRPIMetricname).ILongIntervalCounterDataAccumulator_addSingleIncident();
            String strARTMetricname = String.valueOf(componentname) + kMetricSeperator + this.getParameter(kARTMetric);
            factory.safeGetIntegerAverageDataAccumulator(strARTMetricname).IIntegerAggregatingDataAccumulator_recordDataPoint((int)responsetime);
        }
        catch (Exception e) {
            this.getAgent().IAgent_getModuleFeedback().error(e.getMessage());
        }
    }

    public void ITracer_startTrace(int arg0, InvocationData data) {
        block5: {
            WmCache.enableActivityErrorLog(true);
            try {
                String strProbemethodName = data.getProbeInformation().getProbeIdentification().getProbeMethodName();
                if (strProbemethodName == null || !strProbemethodName.equals("invoke")) break block5;
                Object objInvocationObject = data.getInvocationObject();
                try {
                    Object objOutputData = objInvocationObject.getClass().getMethod("getInputData", new Class[0]).invoke(objInvocationObject, new Object[0]);
                    Class clsIData = this.getClassInstance("com.wm.data.IData", data);
                    Class clsValuesEmulator = this.getClassInstance("com.wm.data.ValuesEmulator", data);
                    Method mtGetValuesEm = clsValuesEmulator.getMethod("get", clsIData, String.class);
                    Object objCorIdFound = mtGetValuesEm.invoke(null, objOutputData, "CorID");
                    if (objCorIdFound != null) {
                        String cacheCorrelationId = objCorIdFound.toString();
                        this.getAgent().IAgent_getModuleFeedback().debug("ServiceExecTaskTracer.ITracer_finishTrace() cacheCorrelationId:" + cacheCorrelationId);
                        new CorrelationId(cacheCorrelationId, true);
                    }
                }
                catch (Exception e) {
                    this.getAgent().IAgent_getModuleFeedback().error((Throwable)e);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }
}

