/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.soa.wm.tn.agent.tracers.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.properties.AttributeListing;
import java.util.concurrent.atomic.AtomicReference;

public class TNServiceExecutionTracer
extends ASingleInstanceTracerFactory {
    private final AtomicReference<IRepository> fRPIRep = new AtomicReference();
    private final AtomicReference<IRepository> fARTRep = new AtomicReference();
    private final AtomicReference<IRepository> fTCPIRep = new AtomicReference();
    private final AtomicReference<IRepository> fTFPIRep = new AtomicReference();

    public TNServiceExecutionTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void ITracer_finishTrace(int arg0, InvocationData data) {
        IRepository newArt;
        long responseTime = data.getWallClockElapsedTime();
        String componentname = this.formatParameterizedName(data);
        long startTime = data.getWallClockStartTime();
        long endTime = data.getWallClockFinishTime();
        String probeMethodName = data.getProbeInformation().getProbeIdentification().getProbeMethodName();
        String strARTMetricname = String.valueOf(componentname) + "|" + probeMethodName + ":" + "Average Response Time (ms)";
        AgentMetric artMetric = this.getDataAccumulatorFactory().safeGetMetricOfType(strARTMetricname, 1025, "Invalid Names:Invalid name given for an integer duration metric");
        IRepository prevArt = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AgentMetric)artMetric, (IRepository)(newArt = BlamePointTracer.getAverageMetricRepository()));
        if (prevArt != null) {
            this.fARTRep.set(prevArt);
        } else {
            this.fARTRep.set(newArt);
        }
        this.fARTRep.get().update(BlamePointTracer.getUpdater(), responseTime, startTime, endTime);
        String strRPIMetricname = String.valueOf(componentname) + "|" + probeMethodName + ":" + "Responses Per Interval";
        AgentMetric rpiMetric = this.getDataAccumulatorFactory().safeGetMetricOfType(strRPIMetricname, 8194, "Invalid Names:Invalid name given for a long interval counter metric");
        IRepository newRpi = BlamePointTracer.getCountQueuedRepository((boolean)true);
        IRepository prevRpi = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AgentMetric)rpiMetric, (IRepository)newRpi);
        if (prevRpi != null) {
            this.fRPIRep.set(prevRpi);
        } else {
            this.fRPIRep.set(newRpi);
        }
        this.fRPIRep.get().update(BlamePointTracer.getIncreaser(), 0L, startTime, endTime);
        try {
            IRepository prevTask;
            IRepository newTask;
            AgentMetric taskMetric;
            Object objTask = data.getInvocationObject();
            Object objPending = objTask.getClass().getMethod("isPending", new Class[0]).invoke(objTask, new Object[0]);
            if (objPending != null) {
                Boolean cfr_ignored_0 = (Boolean)objPending;
            }
            if ((objPending = objTask.getClass().getMethod("isComplete", new Class[0]).invoke(objTask, new Object[0])) != null && ((Boolean)objPending).booleanValue()) {
                strRPIMetricname = String.valueOf(componentname) + ":" + "Tasks Completed  Per Interval";
                taskMetric = this.getDataAccumulatorFactory().safeGetMetricOfType(strRPIMetricname, 8194, "Invalid Names:Invalid name given for a long interval counter metric");
                prevTask = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AgentMetric)taskMetric, (IRepository)(newTask = BlamePointTracer.getCountQueuedRepository((boolean)true)));
                if (prevTask != null) {
                    this.fTCPIRep.set(prevTask);
                } else {
                    this.fTCPIRep.set(newTask);
                }
                this.fTCPIRep.get().update(BlamePointTracer.getIncreaser(), 0L, startTime, endTime);
            }
            if ((objPending = objTask.getClass().getMethod("isFailed", new Class[0]).invoke(objTask, new Object[0])) != null && ((Boolean)objPending).booleanValue()) {
                strRPIMetricname = String.valueOf(componentname) + ":" + "Task Failures Per Interval";
                taskMetric = this.getDataAccumulatorFactory().safeGetMetricOfType(strRPIMetricname, 8194, "Invalid Names:Invalid name given for a long interval counter metric");
                prevTask = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AgentMetric)taskMetric, (IRepository)(newTask = BlamePointTracer.getCountQueuedRepository((boolean)true)));
                if (prevTask != null) {
                    this.fTFPIRep.set(prevTask);
                } else {
                    this.fTFPIRep.set(newTask);
                }
                this.fTFPIRep.get().update(BlamePointTracer.getIncreaser(), 0L, startTime, endTime);
            }
        }
        catch (Exception e) {
            WMUtils.getLogger().error((Throwable)e);
        }
    }

    public void ITracer_startTrace(int arg0, InvocationData data) {
        try {
            data.storeWallClockStartTime();
        }
        catch (Exception e) {
            WMUtils.getLogger().error((Throwable)e);
        }
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }
}

