/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.soa.wm.tn.agent.tracers.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicReference;

public class TNServiceThreadTracer
extends ASingleInstanceTracerFactory {
    private final AtomicReference<IRepository> fRPIRep = new AtomicReference();
    private final AtomicReference<IRepository> fARTRep = new AtomicReference();

    public TNServiceThreadTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    private Field getServiceField(Object objInvocationObject) throws SecurityException, NoSuchFieldException {
        Field fldService = null;
        try {
            fldService = objInvocationObject.getClass().getDeclaredField("service");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            fldService = objInvocationObject.getClass().getSuperclass().getDeclaredField("service");
        }
        return fldService;
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        try {
            Object objInvocationObject = data.getInvocationObject();
            Field fldNSService = this.getServiceField(objInvocationObject);
            fldNSService.setAccessible(true);
            Object objNSName = fldNSService.get(objInvocationObject);
            if (objNSName == null || !objNSName.toString().equals("wm.tn.route:invokeWrapper")) {
                WMUtils.getLogger().debug("TNServiceThreadTracer.Does not match NSName as wm.tn.route:invokeWrapper..Hence return");
                data.put("tn-service-thread", (Object)"N");
                return;
            }
            data.put("tn-service-thread", (Object)"Y");
            data.storeWallClockStartTime();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        String isTNServiceThread = (String)data.get("tn-service-thread");
        if (isTNServiceThread != null && isTNServiceThread.equals("Y")) {
            long responseTime = data.getWallClockElapsedTime();
            long startTime = data.getWallClockStartTime();
            long endTime = data.getWallClockFinishTime();
            String componentname = this.formatParameterizedName(data);
            WMUtils.getLogger().debug("TNServiceThreadTracer.ITracer_finishTrace():" + data.getProbeInformation().getTracerCount());
            String strARTMetricname = String.valueOf(componentname) + ":" + "Average Response Time (ms)";
            AgentMetric artMetric = this.getDataAccumulatorFactory().safeGetMetricOfType(strARTMetricname, 1025, "Invalid Names:Invalid name given for an integer duration metric");
            IRepository newArt = BlamePointTracer.getAverageMetricRepository();
            IRepository prevArt = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AgentMetric)artMetric, (IRepository)newArt);
            if (prevArt != null) {
                this.fARTRep.set(prevArt);
            } else {
                this.fARTRep.set(newArt);
            }
            this.fARTRep.get().update(BlamePointTracer.getUpdater(), responseTime, startTime, endTime);
            String strRPIMetricname = String.valueOf(componentname) + ":" + "Responses Per Interval";
            AgentMetric rpiMetric = this.getDataAccumulatorFactory().safeGetMetricOfType(strRPIMetricname, 8194, "Invalid Names:Invalid name given for a long interval counter metric");
            IRepository newRpi = BlamePointTracer.getCountQueuedRepository((boolean)true);
            IRepository prevRpi = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AgentMetric)rpiMetric, (IRepository)newRpi);
            if (prevRpi != null) {
                this.fRPIRep.set(prevRpi);
            } else {
                this.fRPIRep.set(newRpi);
            }
            this.fRPIRep.get().update(BlamePointTracer.getIncreaser(), 0L, startTime, endTime);
        }
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }
}

