/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.webmethods.adapters.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ICacheableBlameKeyNameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.cas.IBlameComponent;
import com.wily.introscope.agent.trace.hc2.ABlameComponent;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;

public class AdapterNotificationFormatter
implements ICacheableBlameKeyNameFormatter {
    private IAgent fAgent;

    public AdapterNotificationFormatter(IAgent agent) {
        this.fAgent = agent;
    }

    protected IAgent getAgent() {
        return this.fAgent;
    }

    public String INameFormatter_format(String name, InvocationData data) {
        try {
            Object adapterNotification = data.getInvocationObject();
            if (adapterNotification != null && name != null) {
                if (name.indexOf("{adaptername}", 0) >= 0) {
                    String adaptername = null;
                    if (adaptername == null || adaptername.trim().equals("")) {
                        adaptername = (String)WMUtils.invokeMethodOnObject(adapterNotification, "getConnectionDataNode");
                    }
                    if ((adaptername = WMUtils.formatToBeResourceSafe(adaptername)) == null || adaptername.length() == 0) {
                        adaptername = "UnknownConnection";
                    }
                    name = StringUtils.replace((String)name, (String)"{adaptername}", (String)adaptername);
                    WMUtils.getLogger().debug("AdapterNotificationNameFormatter::Connection:" + adaptername);
                }
                if (name.indexOf("{adapternotification}", 0) >= 0) {
                    String notificationNode = this.getAdapterNotificationName(adapterNotification);
                    notificationNode = WMUtils.convertToServiceNode(notificationNode);
                    notificationNode = WMUtils.formatToBeResourceSafe(notificationNode);
                    name = StringUtils.replace((String)name, (String)"{adapternotification}", (String)notificationNode);
                    WMUtils.getLogger().debug("AdapterNotificationNameFormatter::Node name:" + notificationNode);
                }
            } else {
                name = StringUtils.replace((String)name, (String)"{adaptername}", (String)"UnknownConnection");
                name = StringUtils.replace((String)name, (String)"{adapternotification}", (String)"UnknownNotification");
            }
        }
        catch (Throwable bomb) {
            WMUtils.handleError(this.getAgent(), "ERROR_IN_NAMEFORMATTER", bomb);
        }
        return name;
    }

    private String getAdapterNotificationName(Object adapterNotification) {
        String notificationNode = null;
        try {
            notificationNode = (String)WMUtils.invokeMethodOnObject(adapterNotification, "nodeName");
        }
        catch (Exception e) {
            WMUtils.getLogger().error(e.getMessage());
        }
        if (notificationNode == null || notificationNode.length() == 0) {
            notificationNode = "UnknownNotification";
        }
        return notificationNode;
    }

    public Object getObjectKey(IModuleFeedbackChannel imodulefeedbackchannel, int i, InvocationData invocationdata) {
        return null;
    }

    public IBlameComponent getKey(IModuleFeedbackChannel imodulefeedbackchannel, String name, InvocationData data) {
        try {
            return ABlameComponent.getArrayInstance((Object[])new Object[]{name, this.getAdapterNotificationName(data.getInvocationObject())});
        }
        catch (Exception e) {
            WMUtils.getLogger().error(e.getMessage());
            return null;
        }
    }
}

