/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.webmethods.adapters.tracer;

import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.soaextension.webmethods.pools.PoolContainer;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.task.ASimpleExecutableItem;
import com.wily.util.task.IExecutableItem;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class JcaPoolMonitor
implements ITimestampedRunnable {
    private static final boolean debugEnabled = false;
    private static JcaPoolMonitor instance = null;
    private static final char[] instanceLock = new char[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final String BEGIN_METRIC_NAME = "WebMethods|Adapter Connection Pools|";
    private static final String AVAILABLE_JCA_CONNECTION_METRIC_NAME = ":Available Connections";
    private static final String SIZE_JCA_CONNECTION_POOL_METRIC_NAME = ":Current Size";
    private static final String MAX_SIZE_JCA_CONNECTION_POOL_METRIC_NAME = ":Max Size";
    private static final String MIN_SIZE_JCA_CONNECTION_POOL_METRIC_NAME = ":Min Size";
    private final PoolContainer poolContainer = new PoolContainer();
    private IAgent agent = null;
    private final Module module = WMUtils.getModule();
    private Method wmConnectionPool_getAvailConnections = null;
    private Method wmConnectionPool_totalConnections = null;
    private Method wmConnectionPool_getMaxConnections = null;
    private Method wmConnectionPool_getMinConnections = null;
    private Field wmConnectionPool__pooleable = null;
    private Field wmConnectionPool__mcf = null;
    private Method wmManagedConnectionFactory_getNodeName = null;
    private Class wmManagedConnectionFactoryClass = null;

    static void noticeJCAPool(Object jcaConnectionPool) {
        JcaPoolMonitor monitor = JcaPoolMonitor.getInstance(jcaConnectionPool);
        if (monitor != null) {
            monitor.monitorPool(jcaConnectionPool);
        }
    }

    static void removeJCAPool(Object jcaConnectionPool) {
        JcaPoolMonitor monitor = JcaPoolMonitor.getInstance(jcaConnectionPool);
        if (monitor != null) {
            monitor.stopMonitoringPool(jcaConnectionPool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static JcaPoolMonitor getInstance(Object jcaConnectionPool) {
        JcaPoolMonitor returnedObject = null;
        if (jcaConnectionPool == null) return returnedObject;
        String className = jcaConnectionPool.getClass().getName();
        if (className == null) return returnedObject;
        if (!"com.wm.app.b2b.server.jca.WmConnectionPool".equals(className)) return returnedObject;
        char[] cArray = instanceLock;
        synchronized (instanceLock) {
            if (instance != null) return instance;
            instance = new JcaPoolMonitor(jcaConnectionPool.getClass().getClassLoader());
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return instance;
        }
    }

    private JcaPoolMonitor(ClassLoader jcaConnectionPoolClassLoader) {
        try {
            this.agent = AgentShim.getAgent();
            this.wmConnectionPool_getAvailConnections = this.getMethod("com.wm.app.b2b.server.jca.WmConnectionPool", "getAvailConnections", jcaConnectionPoolClassLoader);
            this.wmConnectionPool_totalConnections = this.getMethod("com.wm.app.b2b.server.jca.WmConnectionPool", "getTotalConnections", jcaConnectionPoolClassLoader);
            this.wmConnectionPool_getMaxConnections = this.getMethod("com.wm.app.b2b.server.jca.WmConnectionPool", "getMaxConnections", jcaConnectionPoolClassLoader);
            this.wmConnectionPool_getMinConnections = this.getMethod("com.wm.app.b2b.server.jca.WmConnectionPool", "getMinConnections", jcaConnectionPoolClassLoader);
            this.wmConnectionPool__pooleable = this.getField("com.wm.app.b2b.server.jca.WmConnectionPool", "_pooleable", jcaConnectionPoolClassLoader);
            this.wmConnectionPool__mcf = this.getField("com.wm.app.b2b.server.jca.WmConnectionPool", "_mcf", jcaConnectionPoolClassLoader);
            this.agent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)this, "WebMethods JCA Connection Pool Monitor", true, 7500L, true);
            WMUtils.getLogger().info("WebMethods JCA Connection Pools monitor started");
        }
        catch (Throwable t) {
            WMUtils.getLogger().error("Failed to start the WebMethods JCA Connection Pools monitor", t);
        }
    }

    private void monitorPool(Object jcaConnectionPool) {
        String className;
        if (jcaConnectionPool != null && (className = jcaConnectionPool.getClass().getName()) != null && "com.wm.app.b2b.server.jca.WmConnectionPool".equals(className) && this.isPoolable(jcaConnectionPool)) {
            this.poolContainer.add(jcaConnectionPool);
        }
    }

    private void stopMonitoringPool(Object jcaConnectionPool) {
        if (jcaConnectionPool != null) {
            this.poolContainer.remove(jcaConnectionPool);
        }
    }

    private Method getMethod(String className, String methodName, ClassLoader cl) throws ClassNotFoundException, NoSuchMethodException {
        Method method = null;
        Class<?> clazz = Class.forName(className, false, cl);
        method = clazz.getDeclaredMethod(methodName, EMPTY_CLASS_ARRAY);
        return method;
    }

    private Method getMethod(Class clazz, String methodName) throws ClassNotFoundException, NoSuchMethodException {
        Method method = null;
        method = clazz.getDeclaredMethod(methodName, EMPTY_CLASS_ARRAY);
        return method;
    }

    private Field getField(String className, String fieldName, ClassLoader cl) throws ClassNotFoundException, SecurityException, NoSuchFieldException {
        Field field = null;
        Class<?> clazz = Class.forName(className, false, cl);
        field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        return field;
    }

    private boolean isPoolable(Object jcaConnectionPool) {
        boolean result = false;
        String className = jcaConnectionPool.getClass().getName();
        if (className != null && "com.wm.app.b2b.server.jca.WmConnectionPool".equals(className)) {
            try {
                result = this.wmConnectionPool__pooleable.getBoolean(jcaConnectionPool);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return result;
    }

    private void getJCAPoolMetrics() {
        Object[] array = this.poolContainer.get();
        int i = 0;
        while (i < array.length) {
            String poolName;
            Object jcaPool = array[i];
            if (jcaPool != null && (poolName = this.getJCAPoolName(jcaPool)) != null) {
                this.getJCAPoolMetric(jcaPool, this.wmConnectionPool_getAvailConnections, BEGIN_METRIC_NAME + poolName + AVAILABLE_JCA_CONNECTION_METRIC_NAME);
                this.getJCAPoolMetric(jcaPool, this.wmConnectionPool_totalConnections, BEGIN_METRIC_NAME + poolName + SIZE_JCA_CONNECTION_POOL_METRIC_NAME);
                this.getJCAPoolMetric(jcaPool, this.wmConnectionPool_getMaxConnections, BEGIN_METRIC_NAME + poolName + MAX_SIZE_JCA_CONNECTION_POOL_METRIC_NAME);
                this.getJCAPoolMetric(jcaPool, this.wmConnectionPool_getMinConnections, BEGIN_METRIC_NAME + poolName + MIN_SIZE_JCA_CONNECTION_POOL_METRIC_NAME);
            }
            ++i;
        }
    }

    private String getJCAPoolName(Object jcaPool) {
        String poolName = null;
        if (this.wmConnectionPool__mcf != null) {
            try {
                Object managedConnectionFactory = this.wmConnectionPool__mcf.get(jcaPool);
                if (this.wmManagedConnectionFactoryClass == null) {
                    this.wmManagedConnectionFactoryClass = Class.forName("com.wm.adk.connection.WmManagedConnectionFactory", false, managedConnectionFactory.getClass().getClassLoader());
                    if (this.wmManagedConnectionFactoryClass != null) {
                        this.wmManagedConnectionFactory_getNodeName = this.getMethod(this.wmManagedConnectionFactoryClass, "getNodeName");
                    }
                }
                if (this.wmManagedConnectionFactoryClass != null && this.wmManagedConnectionFactory_getNodeName != null && managedConnectionFactory != null && this.wmManagedConnectionFactoryClass != null && this.wmManagedConnectionFactoryClass.isAssignableFrom(managedConnectionFactory.getClass())) {
                    Object nodeNameObject = this.wmManagedConnectionFactory_getNodeName.invoke(managedConnectionFactory, EMPTY_OBJECT_ARRAY);
                    if (nodeNameObject != null && nodeNameObject instanceof String) {
                        poolName = (String)nodeNameObject;
                        poolName = poolName.trim();
                        poolName = WMUtils.formatToBeResourceSafe(poolName);
                    } else {
                        poolName = "UnknownConnection";
                        WMUtils.getLogger().debug("In getJCAPoolName, assigned a default value to poolName: " + poolName);
                    }
                }
            }
            catch (Throwable e) {
                WMUtils.getLogger().warn("Failed to get the name of the pool", e);
            }
            if (poolName != null && poolName.length() < 1) {
                poolName = null;
                WMUtils.getLogger().debug("In getJCAPoolName, poolName was empty, changing it to \"Unknown\"");
            }
        } else {
            WMUtils.getLogger().debug("In getJCAPoolName: objectPool_getPoolName is null!");
        }
        return poolName;
    }

    private void getJCAPoolMetric(Object jcaPool, Method method, String metricName) {
        block7: {
            if (method != null) {
                try {
                    Object numberObject = method.invoke(jcaPool, EMPTY_OBJECT_ARRAY);
                    if (numberObject != null) {
                        if (numberObject instanceof Integer) {
                            Integer numberInteger = (Integer)numberObject;
                            int numberInt = numberInteger;
                            IIntegerFluctuatingCounterDataAccumulator counter = this.agent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(metricName);
                            if (!counter.IDataAccumulator_isShutOff()) {
                                counter.IIntegerCounterDataAccumulator_setValue(numberInt);
                            }
                        }
                        break block7;
                    }
                    WMUtils.getLogger().debug("In getJCAPoolMetric, Got null for metric " + metricName);
                }
                catch (Throwable e) {
                    WMUtils.getLogger().warn("In getJCAPoolMetric: Failed to get the value for metric " + metricName, e);
                }
            } else {
                WMUtils.getLogger().debug("In getJCAPoolMetric: the method object for metric " + metricName + " is null!");
            }
        }
    }

    public void ITimestampedRunnable_execute(long arg0) {
        if (this.agent != null) {
            this.agent.IAgent_getSharedAsyncQueue().IExecutionQueue_addExecutableItem((IExecutableItem)new ASimpleExecutableItem(){

                public void IExecutableItem_execute() {
                    JcaPoolMonitor.this.getJCAPoolMetrics();
                }
            });
        }
    }
}

