/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.webmethods.bproc.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.IComponentParameterCallback;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.stat.ILongAverageDataAccumulator;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.IInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.soaextension.webmethods.bproc.BPCache;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class BPStepTracer
extends ASingleInstanceTracerFactory
implements IInvocationDataParameterCallback {
    private IAgent fAgent;

    public BPStepTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.fAgent = agent;
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        String component = data.getComponentNameAt(tracerIndex);
        WMUtils.getLogger().debug("BPStepTracer.ITracer_finishTrace() component=" + component);
        this.postStepLevelMetrics(data, component);
        if (BPCache.isProcessComplete()) {
            this.postProcessLevelMetrics(data, component);
        }
    }

    private void postStepLevelMetrics(InvocationData data, String component) {
        try {
            String stepConMetric;
            IIntegerFluctuatingCounterDataAccumulator ciCounter;
            DataAccumulatorFactory factory = this.getAgent().IAgent_getDataAccumulatorFactory();
            if (!BPCache.isIntermediateStep()) {
                Object sdaObj = data.getInvocationObject();
                Field sdeffield = sdaObj.getClass().getDeclaredField("sdef");
                sdeffield.setAccessible(true);
                Object sdefObj = sdeffield.get(sdaObj);
                Method getMhd = sdefObj.getClass().getMethod("getSubEnd", new Class[0]);
                boolean isSubEnd = false;
                isSubEnd = (Boolean)getMhd.invoke(sdefObj, new Object[0]);
                String stepARTMetric = String.valueOf(component) + ":" + "Average Response Time (ms)";
                String stepRPIMetric = String.valueOf(component) + ":" + "Responses Per Interval";
                if (!BPCache.isSrcIntermediate() && !isSubEnd) {
                    long startTime = 0L;
                    if (data.getInvocationParameterCount() > 0) {
                        Date startDate = (Date)data.getInvocationParameterAsObject(0);
                        if (startDate != null) {
                            startTime = startDate.getTime();
                            WMUtils.getLogger().debug("BPStepTracer.ITracer_finishTrace:startDate(execute start time)" + startTime);
                        } else {
                            startTime = data.getWallClockStartTime();
                            WMUtils.getLogger().debug("BPStepTracer.ITracer_finishTrace:Blame stack start time)" + startTime);
                        }
                    } else {
                        startTime = data.getWallClockStartTime();
                        WMUtils.getLogger().debug("BPStepTracer.ITracer_finishTrace:Blame stack start time)" + startTime);
                    }
                    long avgResponseTime = data.getWallClockFinishTime() - startTime;
                    ILongAverageDataAccumulator aveResTimeAccumulator = factory.safeGetLongAverageDataAccumulator(stepARTMetric);
                    aveResTimeAccumulator.ILongAggregatingDataAccumulator_recordDataPoint(avgResponseTime);
                    ILongIntervalCounterDataAccumulator resPerIntAccumulator = factory.safeGetLongIntervalCounterDataAccumulator(stepRPIMetric);
                    if (!resPerIntAccumulator.IDataAccumulator_isShutOff()) {
                        resPerIntAccumulator.ILongIntervalCounterDataAccumulator_addSingleIncident();
                    }
                    WMUtils.getLogger().debug("BPStepTracer.ITracer_finishTrace:normal step avgResponseTime " + avgResponseTime);
                } else if (BPCache.isRunStep()) {
                    String key = BPCache.getStepsId();
                    Long stepStartTime = (Long)BPCache.get(key);
                    long avgResponseTime = 0L;
                    if (stepStartTime != null && stepStartTime > 0L) {
                        avgResponseTime = data.getWallClockFinishTime() - stepStartTime;
                    }
                    WMUtils.getLogger().debug("BPStepTracer.ITracer_finishTrace:stepStartTime " + stepStartTime);
                    WMUtils.getLogger().debug("BPStepTracer.ITracer_finishTrace:avgResponseTime " + avgResponseTime);
                    if (avgResponseTime == 0L) {
                        WMUtils.getLogger().debug("BPStepTracer.ITracer_finishTrace(): Intermediate step start time is not found for:" + component.substring(component.indexOf("Business Processes|") + 19));
                        avgResponseTime = data.getWallClockFinishTime() - data.getWallClockStartTime();
                    } else if (avgResponseTime < 0L) {
                        WMUtils.getLogger().error("Intermediate step start time is manipulated for:" + component.substring(component.indexOf("Business Processes|") + 19));
                        avgResponseTime = data.getWallClockFinishTime() - data.getWallClockStartTime();
                    }
                    ILongAverageDataAccumulator aveResTimeAccumulator = factory.safeGetLongAverageDataAccumulator(stepARTMetric);
                    aveResTimeAccumulator.ILongAggregatingDataAccumulator_recordDataPoint(avgResponseTime);
                    ILongIntervalCounterDataAccumulator resPerIntAccumulator = factory.safeGetLongIntervalCounterDataAccumulator(stepRPIMetric);
                    if (!resPerIntAccumulator.IDataAccumulator_isShutOff()) {
                        resPerIntAccumulator.ILongIntervalCounterDataAccumulator_addSingleIncident();
                    }
                    WMUtils.getLogger().debug("BPStepTracer.ITracer_finishTrace:aggregated avgResponseTime " + avgResponseTime);
                }
            }
            if ((ciCounter = factory.safeGetIntegerFluctuatingCounterDataAccumulator(stepConMetric = String.valueOf(component) + ":" + "Concurrent Invocations")) != null) {
                ciCounter.IIntegerFluctuatingCounterDataAccumulator_decrement();
            }
            String tt_filter_param_key = this.getParameter("WM_SERVICE_TYPE");
            String processname = BPCache.getProcessName();
            if (processname != null) {
                this.getComponentTracer().addExtraParameter(tt_filter_param_key, processname);
            }
            this.getComponentTracer().removeComponent(component);
        }
        catch (Throwable t) {
            WMUtils.handleError(this.fAgent, "ERROR_IN_STEPTRACER_FT_POST_STEP_METRICS", t);
        }
    }

    private void postProcessLevelMetrics(InvocationData data, String component) {
        String parentComponent = component.substring(0, component.lastIndexOf("|"));
        WMUtils.getLogger().debug("BPStepTracer.ITracer_finishTrace() parent component is=" + parentComponent);
        String procARTMetric = String.valueOf(parentComponent) + ":" + "Average Response Time (ms)";
        String procRPIMetric = String.valueOf(parentComponent) + ":" + "Responses Per Interval";
        WMUtils.getLogger().debug("BPStepTracer.ITracer_finishTrace;Computing 'Average response time' of the process");
        try {
            ILongIntervalCounterDataAccumulator resPerIntAccumulator;
            long pstartTime = 0L;
            String processName = BPCache.getProcessName();
            Object pstartTimeexists = BPCache.get(processName);
            if (pstartTimeexists == null) {
                HashMap pMap = (HashMap)BPCache.getPipelineMap();
                if (pMap != null && pMap.containsKey(processName)) {
                    pstartTime = (Long)pMap.get(processName);
                }
            } else {
                pstartTime = (Long)pstartTimeexists;
            }
            if (!(resPerIntAccumulator = this.getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(procRPIMetric)).IDataAccumulator_isShutOff()) {
                resPerIntAccumulator.ILongIntervalCounterDataAccumulator_addSingleIncident();
            }
            if (pstartTime > 0L) {
                WMUtils.getLogger().debug("BPStepTracer.ITracer_finishTrace():Retreiving start time " + pstartTime);
                WMUtils.getLogger().debug("BPStepTracer.ITracer_finishTrace():Retreiving End time " + data.getWallClockFinishTime());
                long avgResponseTime = data.getWallClockFinishTime() - pstartTime;
                WMUtils.getLogger().debug("BPStepTracer.ITracer_finishTrace():avgResponseTime is " + avgResponseTime);
                if (avgResponseTime >= 0L) {
                    this.getAgent().IAgent_getDataAccumulatorFactory();
                    ILongAverageDataAccumulator aveResTimeAccumulator = this.getDataAccumulatorFactory().safeGetLongAverageDataAccumulator(procARTMetric);
                    aveResTimeAccumulator.ILongAggregatingDataAccumulator_recordDataPoint(avgResponseTime);
                } else if (processName != null) {
                    WMUtils.getLogger().error("Process start time of " + processName + " is manipulated, ART is not posted");
                } else {
                    WMUtils.getLogger().error("Process start time is manipulated, ART is not posted");
                }
            } else if (pstartTime == 0L) {
                if (processName != null) {
                    WMUtils.getLogger().warn("Process start time of " + processName + " is not found, ART is not posted");
                } else {
                    WMUtils.getLogger().warn("Process start time is not found, ART is not posted");
                }
            } else if (processName != null) {
                WMUtils.getLogger().error("Process start time of " + processName + " is manipulated, ART is not posted");
            } else {
                WMUtils.getLogger().error("Process start time is manipulated, ART is not posted");
            }
            BPCache.remove(BPCache.getPipelineMap());
        }
        catch (Throwable t) {
            WMUtils.handleError(this.fAgent, "ERROR_IN_STEPTRACER_FT_POST_PROCESS_METRICS", t);
        }
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        try {
            data.storeWallClockStartTime();
            String oriSid = null;
            String sid = null;
            String component = this.formatParameterizedName(data);
            WMUtils.getLogger().debug("BPStepTracer.startTrace() component= " + component);
            data.setComponentNameAt(component, tracerIndex);
            oriSid = BPCache.getOriStepID();
            sid = BPCache.getStepsId();
            BPCache.setSpEnd(BPStepTracer.isSubPrcsEndStep(oriSid));
            Boolean procStarted = BPCache.isProcessStarted();
            if (procStarted != null && procStarted.booleanValue()) {
                this.setProcessStartTimetoCache(data);
            }
            BPCache.setProcessStarted(false);
            if (BPStepTracer.isinterstep(oriSid)) {
                this.setInterStepStartTimeToCache(data, sid);
            } else {
                BPCache.setIntermediateStep(false);
            }
            if (!data.isParameterCallbackInitialized()) {
                data.setParameterCallback((IInvocationDataParameterCallback)this);
            }
            this.getComponentTracer().addComponent(component, (IComponentParameterCallback)data);
            String stepConMetric = String.valueOf(component) + ":" + "Concurrent Invocations";
            this.getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(stepConMetric).IIntegerFluctuatingCounterDataAccumulator_increment();
        }
        catch (Throwable t) {
            WMUtils.handleError(this.fAgent, "ERROR_IN_STEPTRACER", t);
        }
    }

    private void setInterStepStartTimeToCache(InvocationData data, String sid) {
        WMUtils.getLogger().debug("BPStepTracer.ITracer_startTrace() setting intermediate step to true");
        BPCache.setIntermediateStep(true);
        long startTime = 0L;
        if (data.getInvocationParameterCount() > 0) {
            Date startTimeD = (Date)data.getInvocationParameterAsObject(0);
            startTime = startTimeD.getTime();
        } else {
            startTime = data.getWallClockStartTime();
        }
        BPCache.put(sid, startTime);
        WMUtils.getLogger().debug("BPStepTracer.startTrace() Storing start time of interstep " + data.getWallClockStartTime() + "to Cache");
    }

    private void setProcessStartTimetoCache(InvocationData data) {
        Date startDate;
        long startTime = 0L;
        startTime = data.getInvocationParameterCount() > 0 ? ((startDate = (Date)data.getInvocationParameterAsObject(0)) != null ? startDate.getTime() : data.getWallClockStartTime()) : data.getWallClockStartTime();
        BPCache.setProcessStartTime(startTime);
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    public static boolean isinterstep(String stepname) {
        boolean interstep = false;
        if (stepname.contains("PRESUB_")) {
            interstep = true;
        } else if (stepname.contains("PRETDE_")) {
            interstep = true;
        } else if (stepname.contains("_Start")) {
            interstep = true;
        }
        return interstep;
    }

    public static boolean isSubPrcsEndStep(String stepname) {
        boolean spend = false;
        if (stepname.endsWith("_End")) {
            spend = true;
        }
        return spend;
    }

    public void IInvocationDataParameterCallback_addParameters(InvocationData data, Map parameters) {
        String processname;
        String tt_filter_param_key = this.getParameter("WM_SERVICE_TYPE");
        if (data.getInvocationObject() != null && (processname = BPCache.getProcessName()) != null) {
            parameters.put(tt_filter_param_key, processname);
        }
    }
}

