/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.webmethods.bproc.tracer.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.feature.ErrorFeature;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ProbeInformation;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.cas.IBlameTransactionElement;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.trace.hc2.WilyTransactionElement;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.soaextension.webmethods.bproc.BPCache;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.properties.AttributeListing;
import java.util.HashMap;

public class BPMethodExceptionTracer
extends BlamePointTracer {
    private static final String kProbeMethod_handleSubprocessDone = "handleSubprocessDone";
    private static final String kProbeMethod_requestFail = "requestFail";
    private static final String kProbeMethod_handleServiceError = "handleServiceError";
    private static final String kProbeMethod_invokeWrapper = "invokeWrapper";
    private IAgent fAgent;

    public BPMethodExceptionTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.fAgent = agent;
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        String strProbeMethodName = null;
        try {
            strProbeMethodName = data.getProbeInformation().getProbeIdentification().getProbeMethodName();
            if (!strProbeMethodName.equals(kProbeMethod_handleSubprocessDone)) {
                data.put("ProbeMethod", (Object)strProbeMethodName);
                super.ITracer_finishTrace(tracerIndex, data);
            }
        }
        catch (Throwable t) {
            WMUtils.handleError(this.fAgent, "ERROR_IN_BPMETHODEXCEPTIONTRACER", t);
        }
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        String strProbeMethodName = data.getProbeInformation().getProbeIdentification().getProbeMethodName();
        if (strProbeMethodName.equals(kProbeMethod_handleSubprocessDone)) {
            BPCache.setStepId((String)data.getInvocationParameterAsObject(3));
        } else {
            super.doStartBlamePointTrace(tracerIndex, data);
        }
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    protected WilyTransactionElement constructTransactionElement(Object key, String metricName, int blameStatus, boolean isStartTrace, ITransactionElement parent, IBlameTransactionElement previous, IBlameTransactionElement start, ProbeInformation probeInformation) {
        HashMap<IRepository, AgentMetric[]> metrics = new HashMap<IRepository, AgentMetric[]>(1);
        IRepository errorsSds = null;
        AgentMetric[] errorMetric = this.createErrorsMetric(this.getErrorsMetricName(metricName));
        errorsSds = super.getSharedRepository(true, this.fNumberOfStripes);
        metrics.put(errorsSds, errorMetric);
        WilyTransactionElement result = new WilyTransactionElement(key, metricName, this.getBlameStatus(), isStartTrace, parent, previous, start, metrics, null, null, null, errorsSds, null, probeInformation, true, true);
        return result;
    }

    public void doOnEndTrace(int tracerIndex, IStackElement elementData, ITransactionElement element) {
        String errorMessage = null;
        InvocationData data = (InvocationData)elementData;
        String strProbeMethodName = (String)data.get("ProbeMethod");
        String component = data.getComponentName();
        if (strProbeMethodName.equals(kProbeMethod_invokeWrapper)) {
            WMUtils.getLogger().debug("BPMethodExceptionTracer.ITracer_finishTrace, invokeWrapper has been invoked");
            if (data.hasInvocationThrownException()) {
                Throwable error = data.getInvocationThrownException();
                errorMessage = error.getMessage();
                ErrorFeature.constructAndSendErrorSnapshotToServer((InvocationData)data, (String)errorMessage, (IAgent)this.getAgent());
                WMUtils.getLogger().debug("BPMethodExceptionTracer.ITracer_finishTrace Adding EPI for invokeWrapper: " + component);
                ErrorFeature.decorateTransactionsWithError((InvocationData)data, (String)errorMessage);
                ErrorFeature.incrementErrorMetric((IStackElement)data);
            }
        } else if (strProbeMethodName.equals(kProbeMethod_handleServiceError)) {
            WMUtils.getLogger().debug("BPMethodExceptionTracer.ITracer_finishTrace, handleServiceError has been invoked");
            Throwable error = (Throwable)data.getInvocationParameterAsObject(0);
            errorMessage = error.getMessage();
            ErrorFeature.constructAndSendErrorSnapshotToServer((InvocationData)data, (String)errorMessage, (IAgent)this.getAgent());
            WMUtils.getLogger().debug("BPMethodExceptionTracer.ITracer_finishTrace Adding EPI for handleServiceError: " + component);
            ErrorFeature.decorateTransactionsWithError((InvocationData)data, (String)errorMessage);
            ErrorFeature.incrementErrorMetric((IStackElement)data);
        } else if (strProbeMethodName.equals(kProbeMethod_requestFail)) {
            WMUtils.getLogger().debug("BPMethodExceptionTracer.ITracer_finishTrace, requestFail has been invoked");
            ErrorFeature.incrementErrorMetric((IStackElement)data);
            WMUtils.getLogger().debug("BPMethodExceptionTracer.ITracer_finishTrace Adding EPI for requestFail: " + component);
        }
    }

    public void doOnStartTrace(int tracerIndex, IStackElement elementData, ITransactionElement element) {
        InvocationData data = (InvocationData)elementData;
        data.setStartCursorAt(element, tracerIndex);
    }
}

