/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.webmethods.bproc.tracer.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.soaextension.webmethods.bproc.BPCache;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.StringUtils;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicReference;

public class BPStatusMetricTracer
extends ASingleInstanceTracerFactory {
    private static final String kFld_INST_ACTION = "INST_ACTION";
    private static final String kCls_PRTConstants = "com.wm.app.prt.PRTConstants";
    private static final String kMethod_getModelVersion = "getModelVersion";
    private static final String kMethod_getModelId = "getModelId";
    private static final String kMethod_requestFail = "requestFail";
    private static final String kFailStatus = "FAIL";
    private static final String kCancelStatus = "CANCEL";
    private static final String kSuspendStatus = "SUSPEND";
    private static final String kResumeStatus = "RESUME";
    private static final String kRestartStatus = "RESTART";
    private static final String kUnderscore = "_";
    private IAgent fAgent;
    private final AtomicReference<IRepository> fStatusFailRep = new AtomicReference();
    private final AtomicReference<IRepository> fStatusCancelRep = new AtomicReference();
    private final AtomicReference<IRepository> fStatusSuspendRep = new AtomicReference();
    private final AtomicReference<IRepository> fStatusResumeRep = new AtomicReference();
    private final AtomicReference<IRepository> fStatusRestartRep = new AtomicReference();

    public BPStatusMetricTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.fAgent = agent;
    }

    public void ITracer_finishTrace(int index, InvocationData data) {
        try {
            if (!data.hasInvocationThrownException()) {
                String processName = null;
                String statusMetric = "UnknownStatus";
                String status = null;
                String[] action = null;
                String probeMethodname = data.getProbeInformation().getProbeIdentification().getProbeMethodName();
                if (probeMethodname.equalsIgnoreCase(kMethod_requestFail)) {
                    status = kFailStatus;
                } else {
                    Integer statusObj = (Integer)data.getInvocationParameterAsObject(0);
                    ClassLoader threadclassloader = Thread.currentThread().getContextClassLoader();
                    Class<?> prtConstants_cls = Class.forName(kCls_PRTConstants, false, threadclassloader);
                    Field actionArrayField = prtConstants_cls.getDeclaredField(kFld_INST_ACTION);
                    action = (String[])actionArrayField.get(null);
                    status = action[statusObj];
                }
                this.getAgent().IAgent_getModuleFeedback().debug("BPStatusMetricTracer.ITracer_startTrace():Got status as" + status);
                long startTime = data.getWallClockStartTime();
                long endTime = data.getWallClockFinishTime();
                String metricName = this.getFormattedName();
                processName = this.getProcessName(data);
                if (status.equals(kFailStatus)) {
                    IRepository newStatus;
                    statusMetric = "Errors Per Interval";
                    metricName = String.valueOf(metricName.replaceAll("\\{processName\\}", processName)) + ":" + statusMetric;
                    AgentMetric failMetric = this.getDataAccumulatorFactory().safeGetMetricOfType(metricName, 8194, "Invalid Names:Invalid name given for a long interval counter metric");
                    IRepository prevStatus = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AgentMetric)failMetric, (IRepository)(newStatus = BlamePointTracer.getCountQueuedRepository((boolean)true)));
                    if (prevStatus != null) {
                        this.fStatusFailRep.set(prevStatus);
                    } else {
                        this.fStatusFailRep.set(newStatus);
                    }
                    this.fStatusFailRep.get().update(BlamePointTracer.getIncreaser(), 0L, startTime, endTime);
                } else if (status.equals(kCancelStatus)) {
                    IRepository newStatus;
                    statusMetric = "Cancels Per Interval";
                    metricName = String.valueOf(metricName.replaceAll("\\{processName\\}", processName)) + ":" + statusMetric;
                    AgentMetric cancelMetric = this.getDataAccumulatorFactory().safeGetMetricOfType(metricName, 8194, "Invalid Names:Invalid name given for a long interval counter metric");
                    IRepository prevStatus = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AgentMetric)cancelMetric, (IRepository)(newStatus = BlamePointTracer.getCountQueuedRepository((boolean)true)));
                    if (prevStatus != null) {
                        this.fStatusCancelRep.set(prevStatus);
                    } else {
                        this.fStatusCancelRep.set(newStatus);
                    }
                    this.fStatusCancelRep.get().update(BlamePointTracer.getIncreaser(), 0L, startTime, endTime);
                    BPCache.setProcessComplete(true);
                } else if (status.equals(kSuspendStatus)) {
                    IRepository newStatus;
                    statusMetric = "Suspends Per Interval";
                    metricName = String.valueOf(metricName.replaceAll("\\{processName\\}", processName)) + ":" + statusMetric;
                    AgentMetric suspendMetric = this.getDataAccumulatorFactory().safeGetMetricOfType(metricName, 8194, "Invalid Names:Invalid name given for a long interval counter metric");
                    IRepository prevStatus = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AgentMetric)suspendMetric, (IRepository)(newStatus = BlamePointTracer.getCountQueuedRepository((boolean)true)));
                    if (prevStatus != null) {
                        this.fStatusSuspendRep.set(prevStatus);
                    } else {
                        this.fStatusSuspendRep.set(newStatus);
                    }
                    this.fStatusSuspendRep.get().update(BlamePointTracer.getIncreaser(), 0L, startTime, endTime);
                } else if (status.equals(kResumeStatus)) {
                    IRepository newStatus;
                    statusMetric = "Resumes Per Interval";
                    metricName = String.valueOf(metricName.replaceAll("\\{processName\\}", processName)) + ":" + statusMetric;
                    AgentMetric resumeMetric = this.getDataAccumulatorFactory().safeGetMetricOfType(metricName, 8194, "Invalid Names:Invalid name given for a long interval counter metric");
                    IRepository prevStatus = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AgentMetric)resumeMetric, (IRepository)(newStatus = BlamePointTracer.getCountQueuedRepository((boolean)true)));
                    if (prevStatus != null) {
                        this.fStatusResumeRep.set(prevStatus);
                    } else {
                        this.fStatusResumeRep.set(newStatus);
                    }
                    this.fStatusResumeRep.get().update(BlamePointTracer.getIncreaser(), 0L, startTime, endTime);
                } else if (status.equals(kRestartStatus)) {
                    IRepository newStatus;
                    statusMetric = "Restarts Per Interval";
                    metricName = String.valueOf(metricName.replaceAll("\\{processName\\}", processName)) + ":" + statusMetric;
                    AgentMetric restartMetric = this.getDataAccumulatorFactory().safeGetMetricOfType(metricName, 8194, "Invalid Names:Invalid name given for a long interval counter metric");
                    IRepository prevStatus = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AgentMetric)restartMetric, (IRepository)(newStatus = BlamePointTracer.getCountQueuedRepository((boolean)true)));
                    if (prevStatus != null) {
                        this.fStatusRestartRep.set(prevStatus);
                    } else {
                        this.fStatusRestartRep.set(newStatus);
                    }
                    this.fStatusRestartRep.get().update(BlamePointTracer.getIncreaser(), 0L, startTime, endTime);
                }
                if (!statusMetric.equals("UnknownStatus")) {
                    WMUtils.getLogger().debug("BPStatusMetricTracer.ITracer_startTrace(),Posted Status Metric for" + metricName);
                }
            }
        }
        catch (Throwable t) {
            WMUtils.handleError(this.fAgent, "ERROR_IN_BPSTATUSMETRICTRACER", t);
        }
    }

    public void ITracer_startTrace(int i, InvocationData data) {
        BPCache.remove("com_wily_wm_pmap");
    }

    private String getProcessName(InvocationData data) {
        String processName;
        Object modelIdentifierObj = null;
        String probeMethodname = data.getProbeInformation().getProbeIdentification().getProbeMethodName();
        modelIdentifierObj = probeMethodname.equalsIgnoreCase(kMethod_requestFail) ? data.getInvocationParameterAsObject(1) : data.getInvocationParameterAsObject(2);
        try {
            String modelid = null;
            String modelversion = null;
            Method method = modelIdentifierObj.getClass().getMethod(kMethod_getModelId, new Class[0]);
            method.setAccessible(true);
            modelid = (String)method.invoke(modelIdentifierObj, new Object[0]);
            modelid = StringUtils.replace((String)modelid, (String)"/", (String)".");
            method = null;
            method = modelIdentifierObj.getClass().getMethod(kMethod_getModelVersion, new Class[0]);
            method.setAccessible(true);
            modelversion = (String)method.invoke(modelIdentifierObj, new Object[0]);
            modelversion = StringUtils.replace((String)modelversion, (String)":", (String)kUnderscore);
            modelid = modelid.concat(kUnderscore);
            processName = modelid.concat(modelversion);
            processName = StringUtils.replace((String)processName, (String)":", (String)kUnderscore);
            BPCache.setProcessName(processName);
        }
        catch (Throwable t) {
            processName = "UnknownProcess";
            WMUtils.handleError(this.fAgent, "ERROR_IN_BPSTATUSMETRICTRACER_PROCESS", t);
        }
        return processName;
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }
}

