/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.webmethods.pools;

import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.soaextension.webmethods.pools.PoolContainer;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.task.ASimpleExecutableItem;
import com.wily.util.task.IExecutableItem;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Vector;

public class JdbcPoolMonitor
implements ITimestampedRunnable {
    private static final PoolContainer tsArray = new PoolContainer();
    private static final ArrayList<String> deletedPools = new ArrayList();
    private static final ArrayList<String> monitoredPools = new ArrayList();
    private static JdbcPoolMonitor instance = null;
    private static final char[] instanceLock = new char[0];
    private IAgent agent = null;
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final String BEGIN_METRIC_NAME = "WebMethods|JDBC Connection Pools|";
    private static final String AVAILABLE_JDBC_CONNECTION_METRIC_NAME = ":Available Connections";
    private static final String SIZE_JDBC_CONNECTION_POOL_METRIC_NAME = ":Current Size";
    private static final String MAX_SIZE_JDBC_CONNECTION_POOL_METRIC_NAME = ":Max Size";
    private static final String MIN_SIZE_JDBC_CONNECTION_POOL_METRIC_NAME = ":Min Size";
    private Method jDBCConnectionPool_avail = null;
    private Method jDBCConnectionPool_size = null;
    private Method jDBCConnectionPool_getPoolName = null;
    private Method jDBCConnectionPool_getMaxConnections = null;
    private Method jDBCConnectionPool_getMinConnections = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static void noticeJDBCPool(Object jdbcConnectionPool) {
        if (jdbcConnectionPool == null) return;
        String className = jdbcConnectionPool.getClass().getName();
        if (className != null && "com.wm.app.jdbc.JDBCConnectionPool".equals(className)) {
            char[] cArray = instanceLock;
            // MONITORENTER : instanceLock
            if (instance == null) {
                instance = new JdbcPoolMonitor(jdbcConnectionPool.getClass().getClassLoader());
            }
            // MONITOREXIT : cArray
            tsArray.add(jdbcConnectionPool);
        }
        try {
            String poolname = (String)WMUtils.invokeMethodOnObject(jdbcConnectionPool, "getPoolName");
            monitoredPools.add(poolname);
            return;
        }
        catch (Exception e) {
            WMUtils.getLogger().debug((Throwable)e);
            WMUtils.getLogger().error(e.getMessage());
        }
    }

    static void stopMonitoringPool(String poolname) {
        if (poolname != null || !poolname.equals("")) {
            deletedPools.add(poolname);
            while (monitoredPools.contains(poolname)) {
                monitoredPools.remove(poolname);
            }
        }
    }

    private JdbcPoolMonitor(ClassLoader jdbcConnectionPoolClassLoader) {
        try {
            this.agent = AgentShim.getAgent();
            this.jDBCConnectionPool_avail = this.getMethod("com.wm.app.jdbc.JDBCConnectionPool", "avail", jdbcConnectionPoolClassLoader);
            this.jDBCConnectionPool_size = this.getMethod("com.wm.app.jdbc.JDBCConnectionPool", "size", jdbcConnectionPoolClassLoader);
            this.jDBCConnectionPool_getPoolName = this.getMethod("com.wm.app.jdbc.JDBCConnectionPool", "getPoolName", jdbcConnectionPoolClassLoader);
            this.jDBCConnectionPool_getMaxConnections = this.getMethod("com.wm.app.jdbc.JDBCConnectionPool", "getMaxConnections", jdbcConnectionPoolClassLoader);
            this.jDBCConnectionPool_getMinConnections = this.getMethod("com.wm.app.jdbc.JDBCConnectionPool", "getMinConnections", jdbcConnectionPoolClassLoader);
            this.agent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)this, "WebMethods JDBC Connection Pool Monitor", true, 7500L, true);
            WMUtils.getLogger().info("WebMethods JDBC Connection Pools monitor started");
        }
        catch (Throwable t) {
            WMUtils.getLogger().error("Failed to start the WebMethods JDBC Connection Pools monitor", t);
        }
    }

    private Method getMethod(String className, String methodName, ClassLoader cl) throws ClassNotFoundException, NoSuchMethodException {
        Method method = null;
        Class<?> clazz = Class.forName(className, false, cl);
        method = clazz.getDeclaredMethod(methodName, EMPTY_CLASS_ARRAY);
        return method;
    }

    private void clearDeadMetrics() {
        Vector<String> deadMetrics = new Vector<String>();
        String metrickey = null;
        for (String pool : deletedPools) {
            metrickey = BEGIN_METRIC_NAME + pool + AVAILABLE_JDBC_CONNECTION_METRIC_NAME;
            deadMetrics.addElement(metrickey);
            metrickey = BEGIN_METRIC_NAME + pool + SIZE_JDBC_CONNECTION_POOL_METRIC_NAME;
            deadMetrics.addElement(metrickey);
            metrickey = BEGIN_METRIC_NAME + pool + MAX_SIZE_JDBC_CONNECTION_POOL_METRIC_NAME;
            deadMetrics.addElement(metrickey);
            metrickey = BEGIN_METRIC_NAME + pool + MIN_SIZE_JDBC_CONNECTION_POOL_METRIC_NAME;
            deadMetrics.addElement(metrickey);
        }
        for (String metricname : deadMetrics) {
            WMUtils.getLogger().debug("Destroying metric:" + metricname);
            this.destroyMetric(metricname);
        }
        deletedPools.clear();
    }

    private void destroyMetric(String name) {
        try {
            this.agent.IAgent_getDataAccumulatorFactory().removeMetric(name);
        }
        catch (Exception e) {
            this.agent.IAgent_safeReportError("Could not remove JDBC Pool metric " + name, (Throwable)e);
        }
    }

    private void getJDBCConnectionPoolMetrics() {
        Object[] array = tsArray.get();
        int i = 0;
        while (i < array.length) {
            String poolName;
            Object jdbcConnectionPool = array[i];
            if (jdbcConnectionPool != null && (poolName = this.getJDBCConnectionPoolName(jdbcConnectionPool)) != null) {
                if (monitoredPools.contains(poolName)) {
                    this.getJDBCConnectionPoolMetric(jdbcConnectionPool, this.jDBCConnectionPool_avail, BEGIN_METRIC_NAME + poolName + AVAILABLE_JDBC_CONNECTION_METRIC_NAME);
                    this.getJDBCConnectionPoolMetric(jdbcConnectionPool, this.jDBCConnectionPool_size, BEGIN_METRIC_NAME + poolName + SIZE_JDBC_CONNECTION_POOL_METRIC_NAME);
                    this.getJDBCConnectionPoolMetric(jdbcConnectionPool, this.jDBCConnectionPool_getMaxConnections, BEGIN_METRIC_NAME + poolName + MAX_SIZE_JDBC_CONNECTION_POOL_METRIC_NAME);
                    this.getJDBCConnectionPoolMetric(jdbcConnectionPool, this.jDBCConnectionPool_getMinConnections, BEGIN_METRIC_NAME + poolName + MIN_SIZE_JDBC_CONNECTION_POOL_METRIC_NAME);
                } else {
                    tsArray.remove(jdbcConnectionPool);
                }
            }
            ++i;
        }
    }

    private String getJDBCConnectionPoolName(Object threadPool) {
        String poolName = null;
        if (this.jDBCConnectionPool_getPoolName != null) {
            try {
                Object poolNameObject = this.jDBCConnectionPool_getPoolName.invoke(threadPool, EMPTY_OBJECT_ARRAY);
                if (poolNameObject != null && poolNameObject instanceof String) {
                    poolName = (String)poolNameObject;
                    poolName = poolName.trim();
                    poolName = WMUtils.formatToBeResourceSafe(poolName);
                } else {
                    poolName = "UnknownPool";
                    WMUtils.getLogger().debug("In getJDBCConnectionPoolName, assigned a default value to poolName: " + poolName);
                }
            }
            catch (Throwable e) {
                WMUtils.getLogger().warn("Failed to get the name of the pool", e);
            }
            if (poolName != null && poolName.length() < 1) {
                poolName = null;
                WMUtils.getLogger().debug("In getJDBCConnectionPoolName, poolName was empty, changing it to null");
            }
        } else {
            WMUtils.getLogger().debug("In getJDBCConnectionPoolName: objectPool_getPoolName is null!");
        }
        return poolName;
    }

    private void getJDBCConnectionPoolMetric(Object threadPool, Method method, String metricName) {
        block5: {
            if (method != null) {
                try {
                    Object numberObject = method.invoke(threadPool, EMPTY_OBJECT_ARRAY);
                    if (numberObject == null || !(numberObject instanceof Integer)) break block5;
                    Integer numberInteger = (Integer)numberObject;
                    int numberInt = numberInteger;
                    IIntegerFluctuatingCounterDataAccumulator counter = this.agent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(metricName);
                    if (!counter.IDataAccumulator_isShutOff()) {
                        counter.IIntegerCounterDataAccumulator_setValue(numberInt);
                    }
                }
                catch (Throwable e) {
                    WMUtils.getLogger().warn("WMJDBCConnectionPoolMonitor: Failed to get the value for metric " + metricName, e);
                }
            } else {
                WMUtils.getLogger().debug("In getJDBCConnectionPoolMetric: the method object for metric " + metricName + " is null!");
            }
        }
    }

    public void ITimestampedRunnable_execute(long arg0) {
        if (this.agent != null) {
            this.agent.IAgent_getSharedAsyncQueue().IExecutionQueue_addExecutableItem((IExecutableItem)new ASimpleExecutableItem(){

                public void IExecutableItem_execute() {
                    JdbcPoolMonitor.this.clearDeadMetrics();
                    JdbcPoolMonitor.this.getJDBCConnectionPoolMetrics();
                }
            });
        }
    }
}

