/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.webmethods.services.tracer.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.feature.ErrorFeature;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ProbeInformation;
import com.wily.introscope.agent.trace.cas.IBlameTransactionElement;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.trace.hc2.WilyTransactionElement;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.properties.AttributeListing;
import java.util.HashMap;

public class WMErrorReportingTracer
extends BlamePointTracer {
    public WMErrorReportingTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        try {
            boolean acl;
            Boolean retObj = (Boolean)data.getInvocationReturnValueAsObject();
            if (retObj != null && !(acl = retObj.booleanValue())) {
                super.doStartBlamePointTrace(tracerIndex, data);
                String errorMessage = "An AccessException Occured in WebMethods::Access Denied";
                ErrorFeature.constructAndSendErrorSnapshotToServer((InvocationData)data, (String)errorMessage, (IAgent)super.getAgent());
                ErrorFeature.decorateTransactionsWithError((InvocationData)data, (String)errorMessage);
                ErrorFeature.incrementErrorMetric((IStackElement)data);
                super.ITracer_finishTrace(tracerIndex, data);
            }
        }
        catch (Throwable bomb) {
            WMUtils.handleError(this.getAgent(), "ERROR_IN_FAULT_TRACER", bomb);
            WMUtils.getLogger().error("Error in WMErrorReportingTracer:" + bomb.getMessage());
            bomb.printStackTrace();
        }
    }

    public void doOnEndTrace(int i, InvocationData data, ITransactionElement element) {
    }

    public void doOnStartTrace(int tracerIndex, InvocationData data, ITransactionElement element) {
        data.setStartCursorAt(element, tracerIndex);
    }

    public WilyTransactionElement constructTransactionElement(Object key, String metricName, int blameStatus, boolean b, ITransactionElement parent, IBlameTransactionElement previous, IBlameTransactionElement start, ProbeInformation probeInformation) {
        HashMap<IRepository, AgentMetric[]> metrics = new HashMap<IRepository, AgentMetric[]>(1);
        IRepository errorsSds = null;
        AgentMetric[] errorMetric = this.createErrorsMetric(this.getErrorsMetricName(metricName));
        errorsSds = super.getSharedRepositoryNoSharedStructure(true);
        metrics.put(errorsSds, errorMetric);
        WilyTransactionElement result = new WilyTransactionElement(key, metricName, blameStatus, true, parent, previous, start, metrics, null, null, null, errorsSds, null, probeInformation, false, false);
        return result;
    }
}

