/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.webmethods.webservices.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.soaextension.webmethods.KConstants;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.soaextension.webmethods.webservices.tracer.WSBlamePointTracer;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Field;

public class WS80BlamePointTracer
extends WSBlamePointTracer {
    public WS80BlamePointTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        WMUtils.getLogger().debug("WS80BlamePointTracer::startTrace()");
        try {
            Object wsdObj = null;
            String soapactionObj = null;
            Object wsImplObject = data.getInvocationObject();
            Field wsdObjectField = WMUtils.getWsdField(wsImplObject);
            wsdObj = wsdObjectField.get(wsImplObject);
            Field soapActionField = WMUtils.getSoapActionField(wsImplObject);
            soapactionObj = (String)soapActionField.get(wsImplObject);
            if (soapactionObj == null) {
                soapactionObj = WMUtils.getSoapActionFromProtocolState(wsImplObject);
            }
            data.put(KConstants.kSoapAction, (Object)soapactionObj);
            if (data != null && wsdObj != null) {
                this.process(tracerIndex, data, wsdObj, soapactionObj);
            }
        }
        catch (Exception e) {
            WMUtils.handleError(this.getAgent(), "ERROR_IN_WM_TRACER", e);
        }
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        WMUtils.getLogger().debug("WS80BlamePointTracer::finishTrace()");
        super.ITracer_finishTrace(tracerIndex, data);
    }
}

