/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.webmethods.webservices.tracer.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.feature.ErrorFeature;
import com.wily.introscope.agent.feature.FaultFeature;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.StringUtils;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicReference;

public class WebServicesClientFaultTracer
extends ASingleInstanceTracerFactory {
    private final AtomicReference<IRepository> fFaultRep = new AtomicReference();

    public WebServicesClientFaultTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void ITracer_finishTrace(int index, InvocationData data) {
        WMUtils.getLogger().debug("WSClientFaultTracer::finishTrace()");
        try {
            Object idataObj;
            Object[] objArr;
            Object responseMsg;
            String component = (String)data.get("ComponentName");
            if (data.hasInvocationThrownException()) {
                try {
                    String errorMessage = this.constructErrorMessage(data);
                    ErrorFeature.constructAndSendErrorSnapshotToServer((InvocationData)data, (String)errorMessage, (IAgent)this.getAgent());
                    ErrorFeature.decorateTransactionsWithError((InvocationData)data, (String)errorMessage);
                    ErrorFeature.incrementErrorMetric((IStackElement)data);
                }
                catch (Exception e) {
                    WMUtils.handleError(this.getAgent(), "ERROR_IN_FAULT_TRACER", e);
                    WMUtils.getLogger().debug("Error in Fault Tracer:" + e.getMessage());
                }
            }
            if ((responseMsg = WMUtils.invokeGetOnValuesEmulator(objArr = new Object[]{idataObj = data.getInvocationParameterAsObject(0), "soapResponseData"})) != null) {
                Object soapBody = null;
                soapBody = responseMsg.getClass().getSimpleName().toString().trim().equals("SOAPEnvelopeImpl") ? WMUtils.invokeMethodOnObject(responseMsg, "getBody") : WMUtils.invokeMethodOnObject(responseMsg, "getSOAPBody");
                boolean hasFault = (Boolean)WMUtils.invokeMethodOnObject(soapBody, "hasFault");
                data.put("hasFault", (Object)hasFault);
                if (hasFault) {
                    Object detailObj;
                    String faultMessage = null;
                    String faulttext = null;
                    Object faultObj = WMUtils.invokeMethodOnObject(soapBody, "getFault");
                    faulttext = (String)WMUtils.invokeMethodOnObject(faultObj, "getFaultString");
                    if (faulttext == null && (detailObj = WMUtils.invokeMethodOnObject(faultObj, "getDetail")) != null) {
                        faulttext = (String)WMUtils.invokeMethodOnObject(detailObj, "getText");
                    }
                    faultMessage = faulttext != null ? (!(faulttext = faulttext.trim()).equals("") ? "SOAP Fault:" + faulttext : "SOAP Fault:" + component + ":" + "SOAP Fault occured") : "SOAP Fault:" + component + ":" + "SOAP Fault occured";
                    data.put("faultMessage", (Object)faultMessage);
                    try {
                        FaultFeature.constructAndSendFaultSnapshotToServer((InvocationData)data, (String)faultMessage, (IAgent)this.getAgent());
                        FaultFeature.decorateTransactionsWithFault((InvocationData)data, (String)faultMessage);
                        FaultFeature.incrementFaultMetric((InvocationData)data);
                    }
                    catch (Exception e) {
                        WMUtils.handleError(this.getAgent(), "ERROR_IN_FAULT_TRACER", e);
                        WMUtils.getLogger().debug("Error in Fault Tracer:" + e.getMessage());
                    }
                }
            } else {
                String errorMessage = null;
                Object[] resArr = new Object[]{idataObj, "response"};
                Object response = WMUtils.invokeGetOnValuesEmulator(resArr);
                if (response != null) {
                    Object[] faultArr = new Object[]{response, "fault"};
                    Object fault = WMUtils.invokeGetOnValuesEmulator(faultArr);
                    if (fault != null) {
                        Object[] reasonsArr = new Object[]{fault, "reasons"};
                        Object reasons = WMUtils.invokeGetOnValuesEmulator(reasonsArr);
                        if (reasons != null) {
                            Object[] reasonsArrObj = (Object[])reasons;
                            Object[] bodyArr = new Object[]{reasonsArrObj[0], "*body"};
                            Object body = WMUtils.invokeGetOnValuesEmulator(bodyArr);
                            if (body != null) {
                                errorMessage = body.toString();
                                ErrorFeature.constructAndSendErrorSnapshotToServer((InvocationData)data, (String)errorMessage, (IAgent)this.getAgent());
                                ErrorFeature.decorateTransactionsWithError((InvocationData)data, (String)errorMessage);
                                ErrorFeature.incrementErrorMetric((IStackElement)data);
                            } else {
                                WMUtils.getLogger().debug("WSClientFaultTracer::Got body as null");
                            }
                        } else {
                            WMUtils.getLogger().debug("WSClientFaultTracer::Got reasons as null");
                        }
                    } else {
                        WMUtils.getLogger().debug("WSClientFaultTracer::Got fault as null");
                    }
                } else {
                    WMUtils.getLogger().debug("WSClientFaultTracer::Got response as null");
                }
            }
        }
        catch (Exception e) {
            WMUtils.handleError(this.getAgent(), "ERROR_IN_FAULT_TRACER", e);
        }
    }

    public void ITracer_startTrace(int index, InvocationData data) {
        WMUtils.getLogger().debug("WSClientFaultTracer::startTrace()");
        try {
            String component = this.getComponentName(data);
            data.put("ComponentName", (Object)component);
        }
        catch (Exception e) {
            WMUtils.handleError(this.getAgent(), "ERROR_IN_FAULT_TRACER", e);
            WMUtils.getLogger().debug("Error in Fault Tracer:" + e.getMessage());
        }
    }

    protected String constructErrorMessage(InvocationData data) {
        String errorMessage = null;
        Throwable error = data.getInvocationThrownException();
        errorMessage = error.getMessage();
        String component = (String)data.get("ComponentName");
        if (errorMessage != null) {
            if ((errorMessage = errorMessage.trim()).equals("")) {
                errorMessage = String.valueOf(component) + "::" + "Error Occured";
            }
        } else {
            errorMessage = String.valueOf(component) + "::" + "Error Occured";
        }
        return errorMessage;
    }

    public void doOnEndTrace(int index, IStackElement elementData, ITransactionElement element) {
        InvocationData data = (InvocationData)elementData;
        long startTime = data.getWallClockStartTime();
        long endTime = data.getWallClockFinishTime();
        if (data.hasInvocationThrownException()) {
            try {
                String errorMessage = this.constructErrorMessage(data);
                ErrorFeature.constructAndSendErrorSnapshotToServer((InvocationData)data, (String)errorMessage, (IAgent)this.getAgent());
                ErrorFeature.decorateTransactionsWithError((InvocationData)data, (String)errorMessage);
                ErrorFeature.incrementErrorMetric((IStackElement)data);
            }
            catch (Exception e) {
                WMUtils.handleError(this.getAgent(), "ERROR_IN_FAULT_TRACER", e);
                WMUtils.getLogger().debug("Error in Fault Tracer:" + e.getMessage());
            }
        }
        boolean hasFault = false;
        if (data.get("hasFault") != null) {
            hasFault = (Boolean)data.get("hasFault");
        }
        if (hasFault) {
            try {
                IRepository newFault;
                AgentMetric faultMetric;
                IRepository prevFault;
                String faultMessage = (String)data.get("faultMessage");
                if (faultMessage != null) {
                    FaultFeature.constructAndSendFaultSnapshotToServer((InvocationData)data, (String)faultMessage, (IAgent)this.getAgent());
                    FaultFeature.decorateTransactionsWithFault((InvocationData)data, (String)faultMessage);
                }
                if ((prevFault = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AgentMetric)(faultMetric = this.getDataAccumulatorFactory().safeGetMetricOfType(String.valueOf(data.getComponentNameAt(index)) + ":" + "SOAP Faults Per Interval", 8194, "Invalid Names:Invalid name given for a long interval counter metric")), (IRepository)(newFault = BlamePointTracer.getCountQueuedRepository((boolean)true)))) != null) {
                    this.fFaultRep.set(prevFault);
                } else {
                    this.fFaultRep.set(newFault);
                }
                this.fFaultRep.get().update(BlamePointTracer.getIncreaser(), 0L, startTime, endTime);
            }
            catch (Exception e) {
                WMUtils.handleError(this.getAgent(), "ERROR_IN_FAULT_TRACER", e);
                WMUtils.getLogger().debug("Error in Fault Tracer:" + e.getMessage());
            }
        }
    }

    protected String getComponentName(InvocationData data) {
        String wsname = "";
        String operation = "";
        try {
            Object idataObj = data.getInvocationParameterAsObject(0);
            Object[] objArr = new Object[]{idataObj, "wsdOperationName"};
            operation = WMUtils.invokeGetStringOnValuesEmulator(objArr);
            objArr[1] = "wsdName";
            String wsdName = WMUtils.invokeGetStringOnValuesEmulator(objArr);
            Object[] objArrCreate = new Object[]{wsdName};
            Object nsObj = WMUtils.invokeCreateOnName(objArrCreate);
            Object[] nsObjArr = new Object[]{nsObj};
            Object wsdObj = WMUtils.invokeGetWSDescOnNamespace(nsObjArr);
            if (wsdObj != null) {
                Method getTargetNS = WMUtils.getTargetNSonWSD(wsdObj);
                wsname = (String)getTargetNS.invoke(wsdObj, new Object[0]);
            }
            WMUtils.getLogger().debug("WSClientFaultTracer Client::WebService Namespace:" + wsname);
            WMUtils.getLogger().debug("WSClientFaultTracer Client::WebService Operation:" + operation);
        }
        catch (Exception e) {
            WMUtils.handleError(this.getAgent(), "ERROR_IN_FAULT_TRACER", e);
            WMUtils.getLogger().debug("Error in Fault Tracer:" + e.getMessage());
        }
        wsname = WMUtils.formatToBeResourceSafe(wsname);
        if (wsname == null || wsname.equals("")) {
            wsname = "UnknownService";
        }
        if ((operation = WMUtils.formatToBeResourceSafe(operation)) == null || operation.equals("")) {
            operation = "UnknownOperation";
        }
        data.put("ServiceName", (Object)wsname);
        data.put("Operation", (Object)operation);
        WMUtils.getLogger().debug("WSClientFaultTracer::Got ServiceName as:" + wsname + " & Operation as:" + operation);
        String component = this.getParameter("name");
        if (component.indexOf("{namespace}", 0) >= 0) {
            component = StringUtils.replace((String)component, (String)"{namespace}", (String)wsname);
        }
        if (component.indexOf("{operationname}", 0) >= 0) {
            component = StringUtils.replace((String)component, (String)"{operationname}", (String)operation);
        }
        data.put("ComponentName", (Object)component);
        return component;
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }
}

