/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.acc.common;

import com.ca.apm.acc.common.ACCMessage;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ACCTextMessage
extends ACCMessage
implements Externalizable {
    private int deliveryMode;
    private String messageText;
    private String pluginCheckSum;
    private String messageType;
    private String destination;

    public ACCTextMessage() {
    }

    public ACCTextMessage(String messageText) {
        this.messageText = messageText;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.deliveryMode);
        byte[] messageTextAsBytes = this.messageText.getBytes();
        out.writeInt(messageTextAsBytes.length);
        out.write(messageTextAsBytes, 0, messageTextAsBytes.length);
        out.writeObject(this.pluginCheckSum);
        out.writeObject(this.messageType);
        out.writeObject(this.destination);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.deliveryMode = in.readInt();
        int byteLength = in.readInt();
        byte[] textMessageBytes = new byte[byteLength];
        in.readFully(textMessageBytes, 0, byteLength);
        this.messageText = new String(textMessageBytes, "UTF-8");
        this.pluginCheckSum = (String)in.readObject();
        this.messageType = (String)in.readObject();
        this.destination = (String)in.readObject();
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public String getMessageText() {
        return this.messageText;
    }

    public void setMessageText(String messageText) {
        this.messageText = messageText;
    }

    public String getPluginCheckSum() {
        return this.pluginCheckSum;
    }

    public void setPluginCheckSum(String pluginCheckSum) {
        this.pluginCheckSum = pluginCheckSum;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String toString() {
        return "ACCTextMessage [deliveryMode=" + this.deliveryMode + ", messageText=" + this.messageText + ", pluginCheckSum=" + this.pluginCheckSum + ", messageType=" + this.messageType + ", destination=" + this.destination + "]";
    }
}

