/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.tracer.builder;

import com.wily.diagnos.cmp.classmatcher.IClassMatcher;
import com.wily.diagnos.cmp.directives.TracerGroup;
import com.wily.diagnos.cmp.directives.TracerName;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.directives.builder.TracerClassMapping;
import com.wily.diagnos.cmp.directives.builder.TracerGroupBuilder;
import com.wily.diagnos.cmp.methodmatcher.IMethodMatcher;
import com.wily.diagnos.cmp.tracer.IMethodTracerValidator;
import com.wily.diagnos.cmp.tracer.MethodTracer;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.extension.OptionalExtensionsManager;
import com.wily.util.classfile.IClassName;
import com.wily.util.properties.AttributeListing;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.LocalizedMessage;
import com.wily.util.validate.IValidatable;
import com.wily.util.validate.ValidationException;
import java.io.File;
import java.util.Map;

public class MethodTracerBuilder
implements IValidatable {
    public static final MethodTracerBuilder[] kZeroLengthArray = new MethodTracerBuilder[0];
    public static final int kDefaultOrdering = 0;
    private final String fSourceFile;
    private final int fLineNumber;
    private final TracerGroupBuilder fFlag;
    private IClassMatcher fClassMatcher;
    private final IMethodMatcher fMethodMatcher;
    private final TracerName fTracerName;
    private final IClassName fTracerClass;
    private final int fTracerOrdering;
    private final AttributeListing fTracerParameters;
    private final boolean fNeedsParameterAccess;
    private TracerClassMapping fTracerMapping;

    public MethodTracerBuilder(String sourceFile, int lineNumber, IClassMatcher classMatcher, IMethodMatcher methodMatcher, TracerName tracerName, String tracerParameter) {
        this(sourceFile, lineNumber, classMatcher, methodMatcher, tracerName, tracerParameter, null, null, false);
    }

    public MethodTracerBuilder(String sourceFile, int lineNumber, IClassMatcher classMatcher, IMethodMatcher methodMatcher, TracerName tracerName, String tracerParameter, boolean needsParameterAccess) {
        this(sourceFile, lineNumber, classMatcher, methodMatcher, tracerName, tracerParameter, null, null, needsParameterAccess);
    }

    public MethodTracerBuilder(String sourceFile, int lineNumber, IClassMatcher classMatcher, IMethodMatcher methodMatcher, TracerName tracerName, String name, TracerGroupBuilder flag) {
        this(sourceFile, lineNumber, classMatcher, methodMatcher, tracerName, name, null, flag, false);
    }

    public MethodTracerBuilder(String sourceFile, int lineNumber, IClassMatcher classMatcher, IMethodMatcher methodMatcher, TracerName tracerName, String name, TracerGroupBuilder flag, boolean needsParameterAccess) {
        this(sourceFile, lineNumber, classMatcher, methodMatcher, tracerName, name, null, flag, needsParameterAccess);
    }

    public MethodTracerBuilder(String sourceFile, int lineNumber, IClassMatcher classMatcher, IMethodMatcher methodMatcher, TracerName tracerName, String tracerParameter, String thresholdParameter) {
        this(sourceFile, lineNumber, classMatcher, methodMatcher, tracerName, tracerParameter, thresholdParameter, null, false);
    }

    public MethodTracerBuilder(String sourceFile, int lineNumber, IClassMatcher classMatcher, IMethodMatcher methodMatcher, TracerName tracerName, String tracerParameter, String thresholdParameter, TracerGroupBuilder flag) {
        this(sourceFile, lineNumber, classMatcher, methodMatcher, tracerName, tracerParameter, thresholdParameter, null, false);
    }

    public MethodTracerBuilder(String sourceFile, int lineNumber, IClassMatcher classMatcher, IMethodMatcher methodMatcher, TracerName tracerName, String tracerParameter, String thresholdParameter, TracerGroupBuilder flag, boolean needsParameterAccess) {
        this(sourceFile, lineNumber, classMatcher, methodMatcher, tracerName, null, 0, MethodTracerBuilder.generateTracerParameters(tracerParameter, thresholdParameter), flag, needsParameterAccess);
    }

    public MethodTracerBuilder(CompilerSettingsBuilder builder, MethodTracer tracer) {
        this(null, 0, tracer.getClassMatcher(), tracer.getMethodMatcher(), null, tracer.getTracerClass(), tracer.getTracerOrdering(), new AttributeListing(tracer.getTracerParameters()), builder.getTracerGroupBuilder(tracer.getTracerGroup()), tracer.needsParameterAccess());
    }

    protected MethodTracerBuilder(String sourceFile, int lineNumber, IClassMatcher classMatcher, IMethodMatcher methodMatcher, TracerName tracerName, IClassName tracerClass, int tracerOrdering, AttributeListing tracerParameters, TracerGroupBuilder flag, boolean needsParameterAccess) {
        this.fSourceFile = sourceFile;
        this.fLineNumber = lineNumber;
        this.fFlag = flag;
        this.fClassMatcher = classMatcher;
        this.fMethodMatcher = methodMatcher;
        this.fTracerName = tracerName;
        this.fTracerClass = tracerClass;
        this.fTracerOrdering = tracerOrdering;
        this.fNeedsParameterAccess = needsParameterAccess;
        this.fTracerParameters = tracerParameters;
        this.fTracerMapping = null;
    }

    protected static AttributeListing generateTracerParameters(String nameParameter, String thresholdParameter) {
        AttributeListing parameters = new AttributeListing();
        if (nameParameter != null) {
            parameters.put("name", nameParameter);
        }
        if (thresholdParameter != null) {
            parameters.put("threshold", thresholdParameter);
        }
        return parameters;
    }

    public void setTracerClassMapping(TracerClassMapping tracerMapping) {
        this.fTracerMapping = tracerMapping;
    }

    private TracerClassMapping getTracerClassMapping() {
        return this.fTracerMapping;
    }

    public void addParameter(String attribute, String value) {
        this.fTracerParameters.put(attribute, value);
    }

    public String getParameter(String attribute) {
        return this.fTracerParameters.get(attribute);
    }

    public TracerGroupBuilder getFlag() {
        return this.fFlag;
    }

    public IClassMatcher getClassMatcher() {
        return this.fClassMatcher;
    }

    public IMethodMatcher getMethodMatcher() {
        return this.fMethodMatcher;
    }

    public String getTracerParameters() {
        return this.fTracerParameters.save();
    }

    protected int getLineNumber() {
        return this.fLineNumber;
    }

    protected String getSourceFile() {
        return this.fSourceFile;
    }

    protected TracerName getTracerName() {
        return this.fTracerName;
    }

    public boolean needsParameterAccess() {
        return this.fNeedsParameterAccess;
    }

    public IClassName getTracerClass() {
        if (this.fTracerClass != null) {
            return this.fTracerClass;
        }
        return this.getTracerClassMapping().getMapping(this.fTracerName);
    }

    public int getTracerOrdering() {
        if (this.fTracerClass != null) {
            return this.fTracerOrdering;
        }
        return this.getTracerClassMapping().getTracerOrdering(this.fTracerName, 0);
    }

    private void addFixedParameters() {
        Map fixedParameters = this.getTracerClassMapping().getTracerParameters(this.fTracerName);
        if (fixedParameters != null) {
            for (Map.Entry entry : fixedParameters.entrySet()) {
                this.addParameter((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    @Override
    public final void IValidatable_validate() throws ValidationException {
        try {
            if (this.fTracerClass == null) {
                if (!this.getTracerClassMapping().hasMapping(this.fTracerName)) {
                    throw new ValidationException(new FormattedLocalizableMessage("Diagnos_Exception_Invalid_Settings_Unknown_Tracer_Class", this.fTracerName.toString(), false));
                }
                IMethodTracerValidator validator = this.getTracerClassMapping().getValidator(this.fTracerName);
                validator.IMethodTracerValidator_validateParameters(this.fTracerParameters);
                this.addFixedParameters();
            }
        }
        catch (ValidationException ve) {
            if (this.fSourceFile != null) {
                this.reportErrorToExtensionManager(this.fSourceFile);
                throw new ValidationException(new FormattedLocalizableMessage("Diagnos_Exception_Parsing_Location_Specific_Wrapper", new LocalizedMessage(this.fSourceFile), new LocalizedMessage(String.valueOf(this.fLineNumber)), ve.getRequiredCondition()));
            }
            throw ve;
        }
    }

    @Override
    public final void IValidatable_validate(int validationConstraintFlags) throws ValidationException {
        this.IValidatable_validate();
    }

    public void postValidate() {
    }

    public MethodTracer generateMethodTracer(IClassName instrumentationClass, Map tracerGroups) throws ValidationException {
        this.IValidatable_validate();
        this.postValidate();
        TracerGroup tracerGroup = this.getFlag() == null ? null : (TracerGroup)tracerGroups.get(this.getFlag().getName());
        String tracerResource = this.getParameter("name");
        boolean isNewTracer = this.computeNewTracer();
        return new MethodTracer(this.fSourceFile, this.fLineNumber, instrumentationClass, tracerGroup, this.getClassMatcher(), this.getMethodMatcher(), this.getTracerParameters(), this.needsParameterAccess(), this.getTracerClass(), this.getTracerOrdering(), this.getTracerName(), tracerResource, isNewTracer, !isNewTracer && this.computeDeclaredBlame(), !this.computeDeclaredNotBlame(), this.computeNeedsStubbing(), this.computeOptionalRunning());
    }

    private void reportErrorToExtensionManager(String fileName) {
        IAgent agent;
        if (this.fFlag != null && (agent = this.fFlag.getAgent()) != null) {
            String strExt = String.valueOf(File.separatorChar) + "extensions" + File.separatorChar;
            int index = fileName.lastIndexOf(strExt);
            OptionalExtensionsManager oem = agent.IAgent_getExtensionAdministrator().getOptionalExtensionManager();
            if (oem != null && index != -1) {
                int indexOfSep = fileName.indexOf(File.separatorChar, index + strExt.length());
                String ext = fileName.substring(index + strExt.length(), indexOfSep);
                oem.addExtensionWithError(ext);
            }
        }
    }

    private boolean computeNeedsStubbing() {
        String s = this.fTracerParameters.get("stubbing");
        if (s != null) {
            return s.equalsIgnoreCase("true");
        }
        return false;
    }

    private boolean computeOptionalRunning() {
        String s = this.fTracerParameters.get("optionalRunning");
        if (s != null) {
            return s.equalsIgnoreCase("true");
        }
        return false;
    }

    private boolean computeDeclaredBlame() {
        String s = this.fTracerParameters.get("useblame");
        if (s != null) {
            return s.equalsIgnoreCase("true");
        }
        return false;
    }

    private boolean computeDeclaredNotBlame() {
        String s = this.fTracerParameters.get("useblame");
        if (s != null) {
            return s.equalsIgnoreCase("false");
        }
        return false;
    }

    private boolean computeNewTracer() {
        String s = this.fTracerParameters.get("newmode");
        if (s != null) {
            return s.equalsIgnoreCase("true");
        }
        return false;
    }

    public void setClassMatcher(IClassMatcher classMatcher) {
        this.fClassMatcher = classMatcher;
    }
}

