/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.classfile.attributes.annotations;

import com.wily.diagnos.personality.java.classfile.attributes.DGAttribute;
import com.wily.diagnos.personality.java.classfile.attributes.annotations.DGAnnotation;
import com.wily.diagnos.personality.java.classfile.attributes.annotations.ParameterAnnotations;
import com.wily.diagnos.personality.java.classfile.constants.DGConstantPool;
import com.wily.util.classfile.IClassName;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DGRuntimeParameterAnnotationAttribute
extends DGAttribute {
    private DGConstantPool fConstantPool;
    private List fParameterAnnotations;

    public DGRuntimeParameterAnnotationAttribute(DGConstantPool constantPool, int nameIndex, String name, byte[] data) throws IOException {
        super(nameIndex, name, data);
        this.fConstantPool = constantPool;
        this.fParameterAnnotations = new ArrayList();
        this.loadData(data);
    }

    public void loadData(byte[] data) throws IOException {
        FilterInputStream input = null;
        try {
            input = new DataInputStream(new ByteArrayInputStream(data));
            this.loadData((DataInputStream)input);
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }

    private void loadData(DataInputStream input) throws IOException {
        byte numberOfParameters = input.readByte();
        byte i = 0;
        while (i < numberOfParameters) {
            ParameterAnnotations paramAnnotations = new ParameterAnnotations();
            short numberOfAnnotations = input.readShort();
            short j = 0;
            while (j < numberOfAnnotations) {
                DGAnnotation annotation = new DGAnnotation(input, this.fConstantPool);
                paramAnnotations.addAnnotation(annotation);
                j = (short)(j + 1);
            }
            this.fParameterAnnotations.add(paramAnnotations);
            i = (byte)(i + 1);
        }
    }

    public boolean containsAnnotation(IClassName annotationName) {
        int i = 0;
        while (i < this.fParameterAnnotations.size()) {
            ParameterAnnotations paramAnnotation = (ParameterAnnotations)this.fParameterAnnotations.get(i);
            List annotations = paramAnnotation.getAnnotations();
            int j = 0;
            while (j < annotations.size()) {
                DGAnnotation annotation = (DGAnnotation)annotations.get(j);
                if (annotation.getAnnotationClassName().equals(annotationName.getReflectionFriendlyQualifiedNameString())) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public boolean isInvisible() {
        return this.getName().equals("RuntimeInvisibleParameterAnnotations");
    }
}

