/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent;

import com.wily.introscope.agent.AgentErrorReporter;
import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShimFeedbackChannel;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.IAgentShim;
import com.wily.introscope.agent.enterprise.EnterpriseAgent;
import com.wily.introscope.agent.exception.ExceptionProcessor;
import com.wily.introscope.agent.remote.RemoteAgentShim;
import com.wily.introscope.agent.runtime.NativeConcreteAgentFactory;
import com.wily.introscope.agent.trace.EmptyMethodTracer;
import com.wily.introscope.agent.trace.IMethodTracer;
import com.wily.introscope.agent.trace.IParameterizedMethodTracer;
import com.wily.introscope.agent.transformer.dynamic.AInstrumentationHelper;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;
import com.wily.util.classfile.NameUtilities;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.security.ProtectionDomain;
import java.text.DateFormat;
import java.util.Date;
import sun.misc.Unsafe;

public class AgentShim
implements IAgentShim {
    private static AgentShim sSingletonAgentShim;
    private static IParameterizedMethodTracer sDesperationTracer;
    private AgentShimFeedbackChannel fFeedbackChannel;
    private String fMainClassName;
    protected IAgent fDelegate;
    private static ThreadLocal fThreadLocalData;
    private boolean fDelegateCreationHasFailed;
    private static boolean fDebug_ForceAgentNotAvailable;
    private static Throwable sExceptionCapturedDuringDesparationTracerCreation;
    public static String sRemoteAgentArgs;

    static {
        fThreadLocalData = new ThreadLocal(){

            protected Object initialValue() {
                AgentShimThreadLocalData tl = new AgentShimThreadLocalData();
                tl.fDelegateCreationInProgress = false;
                tl.fExecutionInsideAgentCode = 0;
                return tl;
            }
        };
        fDebug_ForceAgentNotAvailable = false;
        try {
            sDesperationTracer = new EmptyMethodTracer();
        }
        catch (Throwable t) {
            try {
                sExceptionCapturedDuringDesparationTracerCreation = t;
            }
            catch (Throwable throwable) {}
        }
        sRemoteAgentArgs = null;
    }

    private static void reportStaticInitializationExceptions(IModuleFeedbackChannel feedback) {
        if (sExceptionCapturedDuringDesparationTracerCreation != null) {
            feedback.error(sExceptionCapturedDuringDesparationTracerCreation);
        }
    }

    private static String safeGetTimestamp() {
        try {
            DateFormat format = DateFormat.getDateTimeInstance(3, 1);
            if (format != null) {
                return format.format(new Date());
            }
        }
        catch (Throwable throwable) {}
        return "";
    }

    public static IAgentShim getAgentShim() {
        return AgentShim.getAgentShim(null);
    }

    public static IAgentShim getAgentShim(String mainClassName) {
        return AgentShim.internalGetAgentShim(mainClassName);
    }

    public static IAgent getAgent() throws AgentNotAvailableException {
        return AgentShim.getAgentShim().IAgentShim_getAgent();
    }

    public static IAgent getAgent(String mainClassName) throws AgentNotAvailableException {
        return AgentShim.getAgentShim(mainClassName).IAgentShim_getAgent();
    }

    private static AgentShim internalGetAgentShim(String mainClassName) {
        if (sSingletonAgentShim == null) {
            AgentShim.createAgentShim(mainClassName);
        }
        return sSingletonAgentShim;
    }

    private static synchronized void createAgentShim(String mainClassName) {
        try {
            if (sSingletonAgentShim == null) {
                sSingletonAgentShim = AgentShim.doCreateAgentShim(mainClassName);
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                if (AInstrumentationHelper.isValidate()) {
                    AInstrumentationHelper.getValidationFeedbackChannel().error(String.valueOf(AgentShim.safeGetTimestamp()) + " [ERROR] [IntroscopeAgent] " + "Unable to create AgentShim", t);
                }
                System.err.println(String.valueOf(AgentShim.safeGetTimestamp()) + " [ERROR] [IntroscopeAgent] " + "Unable to create AgentShim");
                t.printStackTrace(System.err);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
    }

    private static AgentShim doCreateAgentShim(String mainClassName) throws AgentNotAvailableException {
        boolean caughtInterrupted = false;
        AgentShim agentShim = null;
        while (agentShim == null) {
            try {
                if (sRemoteAgentArgs == null) {
                    agentShim = new AgentShim(mainClassName);
                    continue;
                }
                agentShim = new RemoteAgentShim(mainClassName, sRemoteAgentArgs);
            }
            catch (InterruptedException interruptedException) {
                if (caughtInterrupted) {
                    throw new AgentNotAvailableException("The thread was interrupted multiple times while creating the AgentShim.  The Agent will not run.");
                }
                caughtInterrupted = true;
            }
        }
        if (caughtInterrupted) {
            Thread.currentThread().interrupt();
        }
        return agentShim;
    }

    public static void handleError(String message, Throwable t) {
        try {
            AgentErrorReporter.safeReportError(AgentShim.getAgentShim().IAgentShim_getModuleFeedback(), message, t);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {}
    }

    public static void handleDebug(String message, Throwable t) {
        try {
            AgentErrorReporter.safeReportDebug(AgentShim.getAgentShim().IAgentShim_getModuleFeedback(), message, t);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {}
    }

    protected AgentShim(String mainClassName) throws InterruptedException {
        fDebug_ForceAgentNotAvailable = false;
        try {
            this.fMainClassName = mainClassName;
            this.fDelegate = null;
            this.fDelegateCreationHasFailed = false;
            this.fFeedbackChannel = new AgentShimFeedbackChannel();
            AgentShim.reportStaticInitializationExceptions(this.fFeedbackChannel);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                System.err.println(String.valueOf(AgentShim.safeGetTimestamp()) + " [ERROR] [IntroscopeAgent] " + "A problem occurred while attempting to initialize");
                t.printStackTrace(System.err);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
    }

    private final IAgent getDelegateAgent() {
        if (fDebug_ForceAgentNotAvailable) {
            return null;
        }
        if (this.fDelegate != null) {
            return this.fDelegate;
        }
        if (AgentShim.isDelegateCreationInProgress()) {
            return null;
        }
        if (this.fDelegateCreationHasFailed) {
            return this.fDelegate;
        }
        return this.createDelegate(this.fMainClassName);
    }

    private final synchronized IAgent createDelegate(String mainClassName) {
        if (this.fDelegate != null) {
            return this.fDelegate;
        }
        if (this.fDelegateCreationHasFailed) {
            return this.fDelegate;
        }
        AgentShim.setDelegateCreationInProgress();
        try {
            try {
                this.doCreateDelegate(mainClassName);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                if (System.getProperty("com.wily.probebuilder.wizard") == null) {
                    if (AInstrumentationHelper.isValidate()) {
                        AInstrumentationHelper.getValidationFeedbackChannel().error("A problem occurred while attempting to create the delegate agent", t);
                    }
                    try {
                        this.fFeedbackChannel.removeAsyncLoggingFromHeartbeat();
                        this.fFeedbackChannel.setShouldBuffer(false);
                        AgentShim.handleError("A problem occurred while attempting to create the delegate agent", t);
                    }
                    catch (ThreadDeath td2) {
                        throw td2;
                    }
                    catch (Throwable throwable) {}
                }
                this.fDelegateCreationHasFailed = true;
                AgentShim.clearDelegateCreationInProgress();
            }
        }
        finally {
            AgentShim.clearDelegateCreationInProgress();
        }
        return this.fDelegate;
    }

    protected void doCreateDelegate(String mainClassName) throws Throwable {
        boolean caughtInterrupted = false;
        EnterpriseAgent delegateAgent = null;
        boolean completed = false;
        while (!completed) {
            try {
                delegateAgent = NativeConcreteAgentFactory.newConcreteAgent(this.fFeedbackChannel, mainClassName);
                this.fDelegate = delegateAgent.createAgentWrapper(delegateAgent);
                completed = true;
            }
            catch (InterruptedException ie) {
                if (caughtInterrupted) {
                    this.fFeedbackChannel.error("The thread was interrupted multiple times while creating the Agent.  The Agent will not run.");
                    this.fFeedbackChannel.debug(ie);
                    throw new AgentNotAvailableException();
                }
                this.fFeedbackChannel.info("The thread was interrupted while creating the Agent.  Agent creation will be retried.");
                caughtInterrupted = true;
            }
        }
        completed = false;
        while (!completed) {
            try {
                delegateAgent.postConstructionInitialize();
                completed = true;
            }
            catch (InterruptedException ie) {
                if (caughtInterrupted) {
                    this.fDelegate = null;
                    this.fFeedbackChannel.error("The thread was interrupted multiple times while initializing the Agent.  The Agent will not run.");
                    this.fFeedbackChannel.debug(ie);
                    throw new AgentNotAvailableException();
                }
                this.fFeedbackChannel.info("The thread was interrupted while initializing the Agent.  Agent initialization will be retried.");
                caughtInterrupted = true;
            }
        }
        if (caughtInterrupted) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public final IModuleFeedbackChannel IAgentShim_getModuleFeedback() {
        IAgent delegateAgent = this.getDelegateAgent();
        if (delegateAgent != null) {
            return delegateAgent.IAgent_getModuleFeedback();
        }
        return this.fFeedbackChannel;
    }

    @Override
    public final IAgent IAgentShim_getAgent() throws AgentNotAvailableException {
        IAgent delegateAgent = this.getDelegateAgent();
        if (delegateAgent == null) {
            if (AgentShim.isDelegateCreationInProgress()) {
                return null;
            }
            throw new AgentNotAvailableException();
        }
        return delegateAgent;
    }

    @Override
    public boolean IAgentShim_isMetricShutOff(AgentMetric metric) {
        IAgent delegateAgent = this.getDelegateAgent();
        if (delegateAgent != null) {
            return delegateAgent.IAgent_isMetricShutOff(metric);
        }
        return true;
    }

    @Override
    public final void debug_forceAgentNotAvailable(boolean forceAgentNotAvailable) {
        fDebug_ForceAgentNotAvailable = forceAgentNotAvailable;
    }

    public static final Object getAgentShimThreadLocal() {
        return fThreadLocalData.get();
    }

    public static final Object getUnsafe() {
        try {
            Unsafe unsafe = Unsafe.getUnsafe();
            return unsafe;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static final void throwApplicationException(Throwable t) {
        Unsafe unsafe = (Unsafe)AgentShim.getUnsafe();
        if (unsafe != null) {
            unsafe.throwException(t);
        }
    }

    public static final boolean isDelegateCreationInProgress() {
        return AgentShim.isDelegateCreationInProgress(AgentShim.getAgentShimThreadLocal());
    }

    public static final boolean isDelegateCreationInProgress(Object tl) {
        return ((AgentShimThreadLocalData)tl).fDelegateCreationInProgress;
    }

    public static final void setDelegateCreationInProgress() {
        AgentShim.setDelegateCreationInProgress(AgentShim.getAgentShimThreadLocal());
    }

    public static final void setDelegateCreationInProgress(Object tl) {
        ((AgentShimThreadLocalData)tl).fDelegateCreationInProgress = true;
    }

    public static final void clearDelegateCreationInProgress() {
        AgentShim.clearDelegateCreationInProgress(AgentShim.getAgentShimThreadLocal());
    }

    public static final void clearDelegateCreationInProgress(Object tl) {
        ((AgentShimThreadLocalData)tl).fDelegateCreationInProgress = false;
    }

    public static final boolean isThreadInAgentCode() {
        return AgentShim.isThreadInAgentCode(AgentShim.getAgentShimThreadLocal());
    }

    public static final boolean isThreadInAgentCode(Object tl) {
        return ((AgentShimThreadLocalData)tl).fExecutionInsideAgentCode > 0;
    }

    public static final void setThreadInAgentCode() {
        AgentShim.setThreadInAgentCode(AgentShim.getAgentShimThreadLocal());
    }

    public static final void setThreadInAgentCode(Object tl) {
        ++((AgentShimThreadLocalData)tl).fExecutionInsideAgentCode;
    }

    public static final void clearThreadInAgentCode() {
        AgentShim.clearThreadInAgentCode(AgentShim.getAgentShimThreadLocal());
    }

    public static final void clearThreadInAgentCode(Object tl) {
        ((AgentShimThreadLocalData)tl).fExecutionInsideAgentCode = 0;
    }

    public static final void exitThreadInAgentCode() {
        AgentShim.clearThreadInAgentCode(AgentShim.getAgentShimThreadLocal());
    }

    public static final void exitThreadInAgentCode(Object tl) {
        --((AgentShimThreadLocalData)tl).fExecutionInsideAgentCode;
    }

    public static final void ProbeBuilderEntryPoint_initializeAgentShim(String mainClassName) {
        if (!AgentShim.isDelegateCreationInProgress()) {
            try {
                AgentShim singleton = AgentShim.internalGetAgentShim(mainClassName);
                if (singleton != null) {
                    singleton.getDelegateAgent();
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("A problem occurred while initializing the Agent shim", t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static final void ProbeBuilderEntryPoint_traceThrownException(Throwable exception, String className, String methodName) {
        Object tl = AgentShim.getAgentShimThreadLocal();
        if (AgentShim.isDelegateCreationInProgress(tl)) {
            return;
        }
        if (AgentShim.isThreadInAgentCode(tl)) {
            return;
        }
        try {
            try {
                AgentShim.setThreadInAgentCode(tl);
                ExceptionProcessor.traceThrownException(exception, className, methodName);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("A problem occurred while tracing a thrown exception", t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {}
                AgentShim.clearThreadInAgentCode(tl);
            }
        }
        finally {
            AgentShim.clearThreadInAgentCode(tl);
        }
    }

    public static final void ProbeBuilderEntryPoint_traceCaughtException(Throwable exception, String className, String methodName) {
        Object tl = AgentShim.getAgentShimThreadLocal();
        if (AgentShim.isDelegateCreationInProgress(tl)) {
            return;
        }
        if (AgentShim.isThreadInAgentCode(tl)) {
            return;
        }
        try {
            try {
                AgentShim.setThreadInAgentCode(tl);
                ExceptionProcessor.traceCaughtException(exception, className, methodName);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("A problem occurred while tracing a caught exception", t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {}
                AgentShim.clearThreadInAgentCode(tl);
            }
        }
        finally {
            AgentShim.clearThreadInAgentCode(tl);
        }
    }

    public static final IMethodTracer ProbeBuilderEntryPoint_loadTracer(int probeHashCode, String probeClassName, String probeMethodName, String probeMethodDescriptor, Object tracedObject, String tracerEncoding) {
        Object tl = AgentShim.getAgentShimThreadLocal();
        if (AgentShim.isDelegateCreationInProgress(tl)) {
            return sDesperationTracer;
        }
        if (AgentShim.isThreadInAgentCode(tl)) {
            return sDesperationTracer;
        }
        try {
            AgentShim.setThreadInAgentCode(tl);
            IMethodTracer iMethodTracer = AgentShim.getAgentShim().IAgentShim_getAgent().IAgent_loadTracer(probeHashCode, probeClassName, probeMethodName, probeMethodDescriptor, tracedObject, tracerEncoding);
            return iMethodTracer;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("A problem occurred while loading the tracers for " + NameUtilities.generateFullMethodName(probeClassName, probeMethodName, probeMethodDescriptor) + ".", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {
            }
        }
        finally {
            AgentShim.clearThreadInAgentCode(tl);
        }
        return sDesperationTracer;
    }

    public static final IParameterizedMethodTracer ProbeBuilderEntryPoint_loadParameterizedTracer(int probeHashCode, String probeClassName, String probeMethodName, String probeMethodDescriptor, Object tracedObject, String tracerEncoding) {
        Object tl = AgentShim.getAgentShimThreadLocal();
        if (AgentShim.isDelegateCreationInProgress(tl)) {
            return sDesperationTracer;
        }
        if (AgentShim.isThreadInAgentCode(tl)) {
            return sDesperationTracer;
        }
        try {
            AgentShim.setThreadInAgentCode(tl);
            IParameterizedMethodTracer iParameterizedMethodTracer = AgentShim.getAgentShim().IAgentShim_getAgent().IAgent_loadParameterizedTracer(probeHashCode, probeClassName, probeMethodName, probeMethodDescriptor, tracedObject, tracerEncoding);
            return iParameterizedMethodTracer;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("A problem occurred while loading the tracers for " + NameUtilities.generateFullMethodName(probeClassName, probeMethodName, probeMethodDescriptor) + ".", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {
            }
        }
        finally {
            AgentShim.clearThreadInAgentCode(tl);
        }
        return sDesperationTracer;
    }

    public static final void ProbeBuilderEntryPoint_noticeEvent(Object eventSpecificReference, String probeClassName, String probeMethodName, String probeMethodDescriptor, String eventNoticingClass, String eventType, String eventSpecificData, String eventSpecificData2) {
        Object tl = AgentShim.getAgentShimThreadLocal();
        if (AgentShim.isDelegateCreationInProgress(tl)) {
            return;
        }
        if (AgentShim.isThreadInAgentCode(tl)) {
            return;
        }
        try {
            try {
                AgentShim.setThreadInAgentCode(tl);
                AgentShim.getAgentShim().IAgentShim_getAgent().IAgent_noticeEvent(probeClassName, probeMethodName, probeMethodDescriptor, eventNoticingClass, eventType, eventSpecificReference, eventSpecificData, eventSpecificData2);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("A problem occurred while noticing an " + eventType + " event in " + NameUtilities.generateFullMethodName(probeClassName, probeMethodName, probeMethodDescriptor) + ".", t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {}
                AgentShim.clearThreadInAgentCode(tl);
            }
        }
        finally {
            AgentShim.clearThreadInAgentCode(tl);
        }
    }

    public static final Object ProbeBuilderEntryPoint_substituteResult(Object origResult, Object tracedObject, String substituterName) {
        Object result = origResult;
        Object tl = AgentShim.getAgentShimThreadLocal();
        if (!AgentShim.isDelegateCreationInProgress(tl) && !AgentShim.isThreadInAgentCode(tl)) {
            try {
                try {
                    AgentShim.setThreadInAgentCode(tl);
                    result = AgentShim.getAgentShim().IAgentShim_getAgent().substituteResult(tracedObject, origResult, substituterName);
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    try {
                        AgentShim.handleError("A problem occurred while doing result substitution", t);
                    }
                    catch (ThreadDeath td2) {
                        throw td2;
                    }
                    catch (Throwable throwable) {}
                    AgentShim.clearThreadInAgentCode(tl);
                }
            }
            finally {
                AgentShim.clearThreadInAgentCode(tl);
            }
        }
        return result;
    }

    public static final void ProbeBuilderEntryPoint_transformAssembly(int assemblyID, String assemblyPath) {
        Object tl = AgentShim.getAgentShimThreadLocal();
        if (AgentShim.isDelegateCreationInProgress(tl)) {
            return;
        }
        try {
            try {
                AgentShim.setThreadInAgentCode(tl);
                AgentShim.getAgentShim().IAgentShim_getAgent().IAgent_transformAssembly(assemblyID, assemblyPath);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("A problem occurred while transforming " + assemblyPath, t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {}
                AgentShim.exitThreadInAgentCode(tl);
            }
        }
        finally {
            AgentShim.exitThreadInAgentCode(tl);
        }
    }

    public static final byte[] ProbeBuilderEntryPoint_transformClass(boolean classLoaderIsAvailable, ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classBytes) {
        Object tl = AgentShim.getAgentShimThreadLocal();
        if (AgentShim.isDelegateCreationInProgress(tl) && classBeingRedefined == null) {
            return null;
        }
        try {
            byte[] result;
            AgentShim.setThreadInAgentCode(tl);
            byte[] byArray = result = AgentShim.getAgentShim().IAgentShim_getAgent().IAgent_transformClass(classLoaderIsAvailable, loader, className, classBeingRedefined, protectionDomain, classBytes);
            return byArray;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("A problem occurred while transforming " + className, t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {
            }
        }
        finally {
            AgentShim.exitThreadInAgentCode(tl);
        }
        return null;
    }

    public static final byte[] ProbeBuilderEntryPoint_transformMethod(IModeledClass modeledClass, IModeledMethod modeledMethod, byte[] methodBytes, Object contextCallback) {
        Object tl = AgentShim.getAgentShimThreadLocal();
        if (AgentShim.isDelegateCreationInProgress(tl)) {
            return null;
        }
        try {
            AgentShim.setThreadInAgentCode(tl);
            byte[] byArray = AgentShim.getAgentShim().IAgentShim_getAgent().IAgent_transformMethod(modeledClass, modeledMethod, methodBytes, contextCallback);
            return byArray;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("A problem occurred while transforming method " + modeledClass.getClassName() + "." + modeledMethod.getMethodName(), t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {
            }
        }
        finally {
            AgentShim.exitThreadInAgentCode(tl);
        }
        return null;
    }

    private static class AgentShimThreadLocalData {
        public boolean fDelegateCreationInProgress;
        public int fExecutionInsideAgentCode;

        private AgentShimThreadLocalData() {
        }
    }
}

