/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.api;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.api.DataRecorder;
import com.wily.introscope.agent.api.DummyDataRecorder;
import com.wily.introscope.agent.api.IllegalMetricNameException;
import com.wily.introscope.agent.api.ImproperlyFormattedMetricNameException;
import com.wily.introscope.agent.api.IntAverageDataRecorder;
import com.wily.introscope.agent.api.IntAverageDataRecorderImpl;
import com.wily.introscope.agent.api.IntCounterDataRecorder;
import com.wily.introscope.agent.api.IntCounterDataRecorderImpl;
import com.wily.introscope.agent.api.IntRateDataRecorder;
import com.wily.introscope.agent.api.IntRateDataRecorderImpl;
import com.wily.introscope.agent.api.LongAverageDataRecorder;
import com.wily.introscope.agent.api.LongAverageDataRecorderImpl;
import com.wily.introscope.agent.api.LongCounterDataRecorder;
import com.wily.introscope.agent.api.LongCounterDataRecorderImpl;
import com.wily.introscope.agent.api.MetricNameAlreadyInUseException;
import com.wily.introscope.agent.api.PerIntervalCounterDataRecorder;
import com.wily.introscope.agent.api.PerIntervalCounterDataRecorderImpl;
import com.wily.introscope.agent.api.StringEventDataRecorder;
import com.wily.introscope.agent.api.StringEventDataRecorderImpl;
import com.wily.introscope.agent.api.TimestampDataRecorder;
import com.wily.introscope.agent.api.TimestampDataRecorderImpl;
import com.wily.introscope.agent.recording.MetricRecordingAdministrator;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.ConflictingTypesException;
import com.wily.introscope.spec.metric.MetricNotFoundException;
import java.text.MessageFormat;
import java.util.Hashtable;

public final class DataRecorderFactory {
    private static final MetricNameToDataRecorderMap fMetricNameToDataRecorderMap = new MetricNameToDataRecorderMap();
    private static final IDataRecorderCreator sLongAverageDataRecorderCreator = new LongAverageDataRecorderCreator();
    private static final IDataRecorderCreator sIntAverageDataRecorderCreator = new IntAverageDataRecorderCreator();
    private static final IDataRecorderCreator sLongCounterDataRecorderCreator = new LongCounterDataRecorderCreator();
    private static final IDataRecorderCreator sIntCounterDataRecorderCreator = new IntCounterDataRecorderCreator();
    private static final IDataRecorderCreator sIntRateDataRecorderCreator = new IntRateDataRecorderCreator();
    private static final IDataRecorderCreator sStringEventDataRecorderCreator = new StringEventDataRecorderCreator();
    private static final IDataRecorderCreator sTimestampDataRecorderCreator = new TimestampDataRecorderCreator();
    private static final IDataRecorderCreator sPerIntervalCounterDataRecorderCreator = new PerIntervalCounterDataRecorderCreator();
    private static final String kNullMetricNameNotAllowedMessage = "null metric names are not allowed";
    private static final String kMetricNameAlreadyInUseMessage = "\"{0}\" is already in use by another DataRecorder of a different type";

    private DataRecorderFactory() {
    }

    public static synchronized LongAverageDataRecorder createLongAverageDataRecorder(String metricName) throws IllegalMetricNameException {
        return (LongAverageDataRecorder)DataRecorderFactory.createDataRecorder(sLongAverageDataRecorderCreator, metricName);
    }

    public static synchronized IntAverageDataRecorder createIntAverageDataRecorder(String metricName) throws IllegalMetricNameException {
        return (IntAverageDataRecorder)DataRecorderFactory.createDataRecorder(sIntAverageDataRecorderCreator, metricName);
    }

    public static synchronized LongCounterDataRecorder createLongCounterDataRecorder(String metricName) throws IllegalMetricNameException {
        return (LongCounterDataRecorder)DataRecorderFactory.createDataRecorder(sLongCounterDataRecorderCreator, metricName);
    }

    public static synchronized IntCounterDataRecorder createIntCounterDataRecorder(String metricName) throws IllegalMetricNameException {
        return (IntCounterDataRecorder)DataRecorderFactory.createDataRecorder(sIntCounterDataRecorderCreator, metricName);
    }

    public static synchronized IntRateDataRecorder createIntRateDataRecorder(String metricName) throws IllegalMetricNameException {
        return (IntRateDataRecorder)DataRecorderFactory.createDataRecorder(sIntRateDataRecorderCreator, metricName);
    }

    public static synchronized StringEventDataRecorder createStringEventDataRecorder(String metricName) throws IllegalMetricNameException {
        return (StringEventDataRecorder)DataRecorderFactory.createDataRecorder(sStringEventDataRecorderCreator, metricName);
    }

    public static synchronized TimestampDataRecorder createTimestampDataRecorder(String metricName) throws IllegalMetricNameException {
        return (TimestampDataRecorder)DataRecorderFactory.createDataRecorder(sTimestampDataRecorderCreator, metricName);
    }

    public static synchronized PerIntervalCounterDataRecorder createPerIntervalCounterDataRecorder(String metricName) throws IllegalMetricNameException {
        return (PerIntervalCounterDataRecorder)DataRecorderFactory.createDataRecorder(sPerIntervalCounterDataRecorderCreator, metricName);
    }

    private static IAgent getAgent() throws AgentNotAvailableException {
        return AgentShim.getAgent();
    }

    private static MetricRecordingAdministrator getMetricRecordingAdministrator() throws AgentNotAvailableException {
        return DataRecorderFactory.getAgent().IAgent_getMetricRecordingAdministrator();
    }

    private static DataAccumulatorFactory getDataAccumulatorFactory() throws AgentNotAvailableException {
        return DataRecorderFactory.getAgent().IAgent_getDataAccumulatorFactory();
    }

    private static synchronized DataRecorder createDataRecorder(IDataRecorderCreator creator, String metricName) throws IllegalMetricNameException {
        DataRecorder dataRecorder = null;
        if (metricName == null) {
            throw new IllegalMetricNameException(kNullMetricNameNotAllowedMessage);
        }
        try {
            dataRecorder = (DataRecorder)fMetricNameToDataRecorderMap.getThreadLocalMap().get(metricName);
            creator.IDataRecorderCreator_checkCast(dataRecorder);
            if (dataRecorder != null && dataRecorder.isRemoved()) {
                dataRecorder = null;
            }
        }
        catch (ClassCastException classCastException) {
            throw new MetricNameAlreadyInUseException(MessageFormat.format(kMetricNameAlreadyInUseMessage, metricName));
        }
        if (dataRecorder == null) {
            try {
                dataRecorder = creator.IDataRecorderCreator_createDataRecorder(metricName);
            }
            catch (BadlyFormedNameException bfne) {
                throw new ImproperlyFormattedMetricNameException(bfne.getMessage());
            }
            catch (ConflictingTypesException cte) {
                throw new MetricNameAlreadyInUseException(cte.getMessage());
            }
            catch (AgentNotAvailableException agentNotAvailableException) {
                dataRecorder = new DummyDataRecorder(metricName);
            }
            fMetricNameToDataRecorderMap.getThreadLocalMap().put(metricName, dataRecorder);
        }
        return dataRecorder;
    }

    static void checkClass(DataRecorder objectToCheck, Class expectedClass) {
        if (objectToCheck != null && !expectedClass.isAssignableFrom(objectToCheck.getClass())) {
            throw new ClassCastException("Expected " + expectedClass.getName() + " received " + objectToCheck.getClass().getName());
        }
    }

    public static synchronized void removeMetric(String metricName) throws BadlyFormedNameException, MetricNotFoundException, AgentNotAvailableException {
        fMetricNameToDataRecorderMap.getThreadLocalMap().remove(metricName);
        DataRecorderFactory.getDataAccumulatorFactory().removeMetric(metricName);
    }

    private static interface IDataRecorderCreator {
        public void IDataRecorderCreator_checkCast(DataRecorder var1) throws ClassCastException;

        public DataRecorder IDataRecorderCreator_createDataRecorder(String var1) throws BadlyFormedNameException, ConflictingTypesException, AgentNotAvailableException;
    }

    private static final class IntAverageDataRecorderCreator
    implements IDataRecorderCreator {
        private IntAverageDataRecorderCreator() {
        }

        @Override
        public void IDataRecorderCreator_checkCast(DataRecorder recorder) throws ClassCastException {
            DataRecorderFactory.checkClass(recorder, IntAverageDataRecorder.class);
        }

        @Override
        public DataRecorder IDataRecorderCreator_createDataRecorder(String metricName) throws BadlyFormedNameException, ConflictingTypesException, AgentNotAvailableException {
            return new IntAverageDataRecorderImpl(DataRecorderFactory.getDataAccumulatorFactory().getIntegerAverageDataAccumulator(metricName), DataRecorderFactory.getMetricRecordingAdministrator());
        }
    }

    private static final class IntCounterDataRecorderCreator
    implements IDataRecorderCreator {
        private IntCounterDataRecorderCreator() {
        }

        @Override
        public void IDataRecorderCreator_checkCast(DataRecorder recorder) throws ClassCastException {
            DataRecorderFactory.checkClass(recorder, IntCounterDataRecorder.class);
        }

        @Override
        public DataRecorder IDataRecorderCreator_createDataRecorder(String metricName) throws BadlyFormedNameException, ConflictingTypesException, AgentNotAvailableException {
            return new IntCounterDataRecorderImpl(DataRecorderFactory.getDataAccumulatorFactory().getIntegerFluctuatingCounterDataAccumulator(metricName), DataRecorderFactory.getMetricRecordingAdministrator());
        }
    }

    private static final class IntRateDataRecorderCreator
    implements IDataRecorderCreator {
        private IntRateDataRecorderCreator() {
        }

        @Override
        public void IDataRecorderCreator_checkCast(DataRecorder recorder) throws ClassCastException {
            DataRecorderFactory.checkClass(recorder, IntRateDataRecorder.class);
        }

        @Override
        public DataRecorder IDataRecorderCreator_createDataRecorder(String metricName) throws BadlyFormedNameException, ConflictingTypesException, AgentNotAvailableException {
            return new IntRateDataRecorderImpl(DataRecorderFactory.getDataAccumulatorFactory().getIntegerRateDataAccumulator(metricName), DataRecorderFactory.getMetricRecordingAdministrator());
        }
    }

    private static final class LongAverageDataRecorderCreator
    implements IDataRecorderCreator {
        private LongAverageDataRecorderCreator() {
        }

        @Override
        public void IDataRecorderCreator_checkCast(DataRecorder recorder) throws ClassCastException {
            DataRecorderFactory.checkClass(recorder, LongAverageDataRecorder.class);
        }

        @Override
        public DataRecorder IDataRecorderCreator_createDataRecorder(String metricName) throws BadlyFormedNameException, ConflictingTypesException, AgentNotAvailableException {
            return new LongAverageDataRecorderImpl(DataRecorderFactory.getDataAccumulatorFactory().getLongAverageDataAccumulator(metricName), DataRecorderFactory.getMetricRecordingAdministrator());
        }
    }

    private static final class LongCounterDataRecorderCreator
    implements IDataRecorderCreator {
        private LongCounterDataRecorderCreator() {
        }

        @Override
        public void IDataRecorderCreator_checkCast(DataRecorder recorder) throws ClassCastException {
            DataRecorderFactory.checkClass(recorder, LongCounterDataRecorder.class);
        }

        @Override
        public DataRecorder IDataRecorderCreator_createDataRecorder(String metricName) throws BadlyFormedNameException, ConflictingTypesException, AgentNotAvailableException {
            return new LongCounterDataRecorderImpl(DataRecorderFactory.getDataAccumulatorFactory().getLongFluctuatingCounterDataAccumulator(metricName), DataRecorderFactory.getMetricRecordingAdministrator());
        }
    }

    private static class MetricNameToDataRecorderMap {
        private ThreadLocal threadLocal = new ThreadLocal(){

            protected Object initialValue() {
                return new Hashtable();
            }
        };

        public Hashtable getThreadLocalMap() {
            return (Hashtable)this.threadLocal.get();
        }
    }

    private static final class PerIntervalCounterDataRecorderCreator
    implements IDataRecorderCreator {
        private PerIntervalCounterDataRecorderCreator() {
        }

        @Override
        public void IDataRecorderCreator_checkCast(DataRecorder recorder) throws ClassCastException {
            DataRecorderFactory.checkClass(recorder, PerIntervalCounterDataRecorder.class);
        }

        @Override
        public DataRecorder IDataRecorderCreator_createDataRecorder(String metricName) throws BadlyFormedNameException, ConflictingTypesException, AgentNotAvailableException {
            return new PerIntervalCounterDataRecorderImpl(DataRecorderFactory.getDataAccumulatorFactory().getLongIntervalCounterDataAccumulator(metricName), DataRecorderFactory.getMetricRecordingAdministrator());
        }
    }

    private static final class StringEventDataRecorderCreator
    implements IDataRecorderCreator {
        private StringEventDataRecorderCreator() {
        }

        @Override
        public void IDataRecorderCreator_checkCast(DataRecorder recorder) throws ClassCastException {
            DataRecorderFactory.checkClass(recorder, StringEventDataRecorder.class);
        }

        @Override
        public DataRecorder IDataRecorderCreator_createDataRecorder(String metricName) throws BadlyFormedNameException, ConflictingTypesException, AgentNotAvailableException {
            return new StringEventDataRecorderImpl(DataRecorderFactory.getDataAccumulatorFactory().getStringEveryEventDataAccumulator(metricName), DataRecorderFactory.getMetricRecordingAdministrator());
        }
    }

    private static final class TimestampDataRecorderCreator
    implements IDataRecorderCreator {
        private TimestampDataRecorderCreator() {
        }

        @Override
        public void IDataRecorderCreator_checkCast(DataRecorder recorder) throws ClassCastException {
            DataRecorderFactory.checkClass(recorder, TimestampDataRecorder.class);
        }

        @Override
        public DataRecorder IDataRecorderCreator_createDataRecorder(String metricName) throws BadlyFormedNameException, ConflictingTypesException, AgentNotAvailableException {
            return new TimestampDataRecorderImpl(DataRecorderFactory.getDataAccumulatorFactory().getTimestampDataAccumulator(metricName), DataRecorderFactory.getMetricRecordingAdministrator());
        }
    }
}

