/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.connection;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.connection.IAgentBridgeCommand;
import com.wily.introscope.agent.connection.IServerConnectionNotification;
import com.wily.introscope.agent.connection.IsengardServerConnectionManager;
import com.wily.introscope.spec.server.beans.agent.IAgentBridgeService;
import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.task.IExecutableItem;

public abstract class AbstractTimestampedCommand
implements ITimestampedRunnable {
    private IAgent fAgent;
    private IModuleFeedbackChannel fFeedback;
    private boolean hasRegisteredConnectionListener;
    private boolean fIsBroadcasting;
    private boolean fHasJustRegistered = false;
    private boolean fRetry;
    private static final String kDIStatusCheckedBehaviorName = "AbstractTimestampedRunnable";
    private static final Module kModule = new Module("AbstractTimestampedRunnable");
    private IRegisteredBehavior fBehaviorHandle;

    protected AbstractTimestampedCommand(IAgent agent) {
        this.fAgent = agent;
        this.setFeedback(agent.IAgent_getModuleFeedback());
    }

    protected IAgent getAgent() {
        return this.fAgent;
    }

    public void start() {
        this.registerBehavior();
    }

    public void stop() {
        this.unregisterBehavior();
    }

    @Override
    public void ITimestampedRunnable_execute(long nowInMillis) {
        if (this.getFeedback().isTraceEnabled(kModule)) {
            this.getFeedback().trace(kModule, "Executing Behavior");
        }
        if (!this.hasRegisteredConnectionListener) {
            IsengardServerConnectionManager manager = this.fAgent.IAgent_getIsengardServerConnection();
            if (manager != null) {
                try {
                    manager.addConnectionObserver(new IServerConnectionNotification(){

                        @Override
                        public void connectionDown() {
                            AbstractTimestampedCommand.this.unregisterBehavior();
                        }

                        @Override
                        public void connectionUp() {
                            AbstractTimestampedCommand.this.registerBehavior();
                        }
                    });
                    this.hasRegisteredConnectionListener = true;
                }
                catch (Exception exception) {}
            }
        } else if (this.isBroadcasting()) {
            if (this.getFeedback().isTraceEnabled(kModule)) {
                this.getFeedback().trace(kModule, "Executing Behavior: Is Brodcasting");
            }
            if (this.fRetry) {
                if (this.getFeedback().isTraceEnabled(kModule)) {
                    this.getFeedback().trace(kModule, "Executing Behavior: Is Retrying");
                }
                this.fRetry = false;
                this.fAgent.IAgent_getIsengardServerConnection().addToCommandQueue(new AAgentBridgeCommand());
            }
        } else {
            if (this.getFeedback().isTraceEnabled(kModule)) {
                this.getFeedback().trace(kModule, "Executing Behavior: Is Not Broadcasting");
            }
            if (this.fHasJustRegistered || this.checkExecuteCondition()) {
                if (this.getFeedback().isTraceEnabled(kModule)) {
                    this.getFeedback().trace(kModule, "Executing Behavior: Executing refresh");
                }
                this.setBroadcasting(true);
                this.fAgent.IAgent_getSharedAsyncQueue().IExecutionQueue_addExecutableItem(new RefresherInBehavior(this));
            }
        }
    }

    private synchronized void setBroadcasting(boolean value) {
        this.fIsBroadcasting = value;
    }

    private synchronized boolean isBroadcasting() {
        return this.fIsBroadcasting;
    }

    private void unregisterBehavior() {
        if (this.getFeedback().isTraceEnabled(kModule)) {
            this.getAgent().IAgent_getModuleFeedback().trace(kModule, "Unregistering Behavior");
        }
        if (this.fBehaviorHandle != null) {
            this.fBehaviorHandle.close();
            this.fBehaviorHandle = null;
        }
        this.setBroadcasting(false);
        this.fHasJustRegistered = false;
        this.onUnregister();
    }

    private void registerBehavior() {
        IntervalHeartbeat heartbeat;
        if (this.getFeedback().isTraceEnabled(kModule)) {
            this.getFeedback().trace(kModule, "Registering Behavior");
        }
        if ((heartbeat = this.fAgent.IAgent_getCommonHeartbeat()) != null && this.fBehaviorHandle == null) {
            long period = 7500L;
            String behaviorName = this.getName();
            this.fBehaviorHandle = heartbeat.addBehavior((ITimestampedRunnable)this, behaviorName == null ? kDIStatusCheckedBehaviorName : behaviorName, true, period, false);
            this.fHasJustRegistered = true;
            this.onRegister();
        }
    }

    protected abstract String getName();

    protected abstract void onRegister();

    protected abstract void onUnregister();

    protected abstract boolean checkExecuteCondition();

    protected abstract boolean executeOnAgent(IAgent var1);

    protected abstract boolean executeOnAgentWhenRegistered(IAgent var1);

    protected abstract void brodcastToAgentBridgeService(IAgentBridgeService var1) throws ConnectionException;

    protected abstract void onBroadcastSuccess();

    protected abstract void onBroadcastFailure();

    protected abstract boolean forceRetry();

    protected void setFeedback(IModuleFeedbackChannel fFeedback) {
        this.fFeedback = fFeedback;
    }

    protected IModuleFeedbackChannel getFeedback() {
        return this.fFeedback;
    }

    private final class AAgentBridgeCommand
    implements IAgentBridgeCommand {
        public int fSuccess;

        private AAgentBridgeCommand() {
        }

        @Override
        public void handleAgentCommand(IAgentBridgeService service) throws ConnectionException {
            if (AbstractTimestampedCommand.this.getFeedback().isTraceEnabled(kModule)) {
                AbstractTimestampedCommand.this.getFeedback().trace(kModule, "Brodcasting to bridge service");
            }
            AbstractTimestampedCommand.this.brodcastToAgentBridgeService(service);
            if (AbstractTimestampedCommand.this.getFeedback().isTraceEnabled(kModule)) {
                AbstractTimestampedCommand.this.getFeedback().trace(kModule, "Done Brodcasting to bridge service");
            }
        }

        @Override
        public void onAgentCommandCompletion(int success) {
            this.fSuccess = success;
            if (success == 0) {
                AbstractTimestampedCommand.this.fAgent.IAgent_getSharedAsyncQueue().IExecutionQueue_addExecutableItem(new IExecutableItem(){

                    @Override
                    public void IExecutableItem_execute() {
                        AbstractTimestampedCommand.this.onBroadcastSuccess();
                        if (AbstractTimestampedCommand.this.getFeedback().isTraceEnabled(kModule)) {
                            AbstractTimestampedCommand.this.getFeedback().trace(kModule, "Setting Brodcasting");
                        }
                        AbstractTimestampedCommand.this.setBroadcasting(false);
                        if (AbstractTimestampedCommand.this.getFeedback().isTraceEnabled(kModule)) {
                            AbstractTimestampedCommand.this.getFeedback().trace(kModule, "Brodcasting set to false");
                        }
                    }

                    @Override
                    public void IExecutableItem_executionAborted() {
                    }

                    @Override
                    public boolean IExecutableItem_shouldStillExecute() {
                        return true;
                    }
                });
            } else {
                AbstractTimestampedCommand.this.fAgent.IAgent_getSharedAsyncQueue().IExecutionQueue_addExecutableItem(new IExecutableItem(){

                    @Override
                    public void IExecutableItem_execute() {
                        AbstractTimestampedCommand.this.onBroadcastFailure();
                        if (!AbstractTimestampedCommand.this.forceRetry()) {
                            if (AbstractTimestampedCommand.this.getFeedback().isTraceEnabled(kModule)) {
                                AbstractTimestampedCommand.this.getFeedback().trace(kModule, "Setting Brodcasting");
                            }
                            AbstractTimestampedCommand.this.setBroadcasting(false);
                            if (AbstractTimestampedCommand.this.getFeedback().isTraceEnabled(kModule)) {
                                AbstractTimestampedCommand.this.getFeedback().trace(kModule, "Brodcasting set to false");
                            }
                        } else {
                            AbstractTimestampedCommand.this.fRetry = true;
                        }
                    }

                    @Override
                    public void IExecutableItem_executionAborted() {
                    }

                    @Override
                    public boolean IExecutableItem_shouldStillExecute() {
                        return true;
                    }
                });
            }
        }
    }

    private final class RefresherInBehavior
    implements IExecutableItem {
        AbstractTimestampedCommand fRunnable;

        public RefresherInBehavior(AbstractTimestampedCommand runnable) {
            this.fRunnable = runnable;
        }

        @Override
        public void IExecutableItem_execute() {
            if (AbstractTimestampedCommand.this.getFeedback().isTraceEnabled(kModule)) {
                AbstractTimestampedCommand.this.getFeedback().trace(kModule, "Executing Refresh Behavior");
            }
            boolean addToBroadcast = false;
            if (AbstractTimestampedCommand.this.fHasJustRegistered) {
                AbstractTimestampedCommand.this.fHasJustRegistered = false;
                addToBroadcast = AbstractTimestampedCommand.this.executeOnAgentWhenRegistered(AbstractTimestampedCommand.this.fAgent);
            } else {
                addToBroadcast = AbstractTimestampedCommand.this.executeOnAgent(AbstractTimestampedCommand.this.fAgent);
            }
            if (addToBroadcast) {
                if (AbstractTimestampedCommand.this.getFeedback().isTraceEnabled(kModule)) {
                    AbstractTimestampedCommand.this.getFeedback().trace(kModule, "Adding for brodcast");
                }
                AbstractTimestampedCommand.this.fAgent.IAgent_getIsengardServerConnection().addToCommandQueue(new AAgentBridgeCommand());
            } else {
                AbstractTimestampedCommand.this.setBroadcasting(false);
            }
        }

        @Override
        public void IExecutableItem_executionAborted() {
        }

        @Override
        public boolean IExecutableItem_shouldStillExecute() {
            return true;
        }
    }
}

