/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.recording;

import com.wily.util.Glob;
import java.util.ArrayList;

public class MetricExclusionFilter {
    private final String[] fFilters;
    private final Glob[] fGlobs;

    public MetricExclusionFilter(String[] filters) {
        this.fFilters = filters;
        ArrayList<Glob> globs = new ArrayList<Glob>();
        if (filters != null) {
            int i = 0;
            while (i < this.fFilters.length) {
                if (this.fFilters[i].length() != 0) {
                    globs.add(new Glob(this.fFilters[i]));
                }
                ++i;
            }
        }
        this.fGlobs = globs.toArray(new Glob[globs.size()]);
    }

    public String[] getFilter() {
        return this.fFilters;
    }

    public boolean isOK(String metricName) {
        return this.computeIsOK(metricName);
    }

    private boolean computeIsOK(String metricName) {
        int i = 0;
        while (i < this.fGlobs.length) {
            if (this.fGlobs[i].matches(metricName)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof MetricExclusionFilter) {
            String[] filter = ((MetricExclusionFilter)obj).getFilter();
            if (this.fFilters.length != filter.length) {
                return false;
            }
            int i = 0;
            while (i < this.fFilters.length) {
                if (!this.fFilters[i].equals(filter[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

