/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.extension.DynamicClassLookup;
import com.wily.introscope.agent.extension.InvalidDynamicClassException;
import com.wily.introscope.agent.trace.ITracerFactory;
import com.wily.introscope.agent.trace.OSGiClassExtensionLoader;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.util.properties.AttributeListing;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.ILocalizableMessage;
import com.wily.wilyassert.Assertion;
import java.lang.reflect.Constructor;

final class TracerFactoryOSGiLoader
extends OSGiClassExtensionLoader {
    private static final String kTracerPluginType = "com.wily.introscope.agent.tracerfactory";
    private static final Class[] kTracerFactoryConstructorParameterTypes = new Class[]{IAgent.class, AttributeListing.class, ProbeIdentification.class, Object.class};

    public TracerFactoryOSGiLoader(IAgent agent) {
        super(agent, ITracerFactory.class, kTracerFactoryConstructorParameterTypes);
    }

    public final ITracerFactory createTracerFactory(String factoryClassName, String parameters, ProbeIdentification identification, Object tracedObject) throws Exception {
        AttributeListing factoryParameters = new AttributeListing();
        factoryParameters.load(parameters);
        DynamicClassLookup.DynamicClassEntry entry = this.loadDynamicClassEntry(factoryClassName);
        Class factoryClass = entry.getDynamicClass();
        IAgent factoryAgent = entry.getDynamicAgent();
        if (!this.getExpectedType().isAssignableFrom(factoryClass)) {
            throw new InvalidDynamicClassException("Class is not assignable to the expected type", (ILocalizableMessage)new FormattedLocalizableMessage("Agent_Extension_Dynamic_Class_Wrong_Type_Error", factoryClassName));
        }
        Constructor constructor = factoryClass.getConstructor(kTracerFactoryConstructorParameterTypes);
        ITracerFactory factory = (ITracerFactory)constructor.newInstance(factoryAgent, factoryParameters, identification, tracedObject);
        Assertion.wilyAssert(false);
        return factory;
    }

    @Override
    protected String getExtensionPointName() {
        return kTracerPluginType;
    }
}

