/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.intelligent;

import com.wily.introscope.agent.trace.intelligent.SustainabilityMetricsHelper;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class QueueMapCache<K, V> {
    ConcurrentLinkedQueue<K> queue = new ConcurrentLinkedQueue();
    ConcurrentHashMap<K, V> map = new ConcurrentHashMap();
    ArrayList<K> tmpList;

    public void initializeQueue(K entry, int size) {
        int i = 0;
        while (i < size) {
            this.queue.add(entry);
            ++i;
        }
    }

    public void addToQueue(K guid, V val) {
        if (this.map.putIfAbsent(guid, val) == null) {
            this.removeFromQueue();
            this.queue.add(guid);
            SustainabilityMetricsHelper.reportDownstreamGuidCountSustainabilityMetrics(1);
        }
    }

    public void removeFromQueue() {
        K guid = this.queue.poll();
        if (guid != null) {
            this.map.remove(guid);
        }
    }

    public ArrayList<K> getMapEntries() {
        this.tmpList = new ArrayList<K>(this.queue);
        return this.tmpList;
    }

    public void init() {
        this.queue.clear();
        this.map.clear();
        this.tmpList.clear();
    }
}

