/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.nio;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.nio.ChannelPerIntervalCounter;
import com.wily.introscope.agent.trace.nio.SocketChannelMap;
import com.wily.util.properties.AttributeListing;
import java.nio.channels.SocketChannel;

public class SocketChannelFinishConnectPerIntervalCounter
extends ChannelPerIntervalCounter
implements ITracer {
    public SocketChannelFinishConnectPerIntervalCounter(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    protected ILongIntervalCounterDataAccumulator createDataAccumulator(InvocationData data) {
        String formattedName;
        Object invocationObject = data.getInvocationObject();
        SocketChannel channel = (SocketChannel)invocationObject;
        if (SocketChannelMap.isRequired(channel, this.getAgent()) && (formattedName = this.formatParameterizedName(data)) != null) {
            return this.createDataAccumulator(formattedName);
        }
        return null;
    }

    @Override
    public ITracer ITracerFactory_allocateTracer(int tracerIndex, InvocationData data) {
        return this;
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        ILongIntervalCounterDataAccumulator count;
        if (data.isSocketClamped()) {
            return;
        }
        if (!data.hasInvocationThrownException() && data.hasMethodResultAvailable() && ((Boolean)data.getInvocationReturnValueAsObject()).booleanValue() && (count = this.createDataAccumulator(data)) != null && !count.IDataAccumulator_isShutOff()) {
            count.ILongIntervalCounterDataAccumulator_addSingleIncident();
        }
    }
}

