/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.extension;

import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class PlatformCheckUtil {
    private static PlatformCheckUtil fInstance;
    private boolean fOsgiEnvironment = false;

    public static synchronized PlatformCheckUtil getInstance() {
        if (fInstance == null) {
            fInstance = new PlatformCheckUtil();
        }
        return fInstance;
    }

    private PlatformCheckUtil() {
    }

    private String getOsgiAttribute() {
        String attribute = null;
        try {
            int marker;
            Class<PlatformCheckUtil> clazz = PlatformCheckUtil.class;
            String classFileName = "/" + clazz.getName().replace('.', '/') + ".class";
            URL url = clazz.getResource(classFileName);
            String urlString = url.toString();
            if (urlString.startsWith("jar:") && (marker = urlString.indexOf(33)) != -1) {
                String manifestUrlString = String.valueOf(urlString.substring(0, marker + 1)) + "/META-INF/MANIFEST.MF";
                Manifest manifest = new Manifest(new URL(manifestUrlString).openStream());
                Attributes attr = manifest.getMainAttributes();
                attribute = attr.getValue("Boot-Class-Path");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return attribute;
    }

    public boolean isOsgiEnvironment() {
        return this.fOsgiEnvironment;
    }
}

