/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.server.transactiontrace;

import com.wily.introscope.spec.metric.AgentName;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.server.beans.event.IEventData;
import com.wily.introscope.spec.server.beans.event.IEventDataHeader;
import com.wily.introscope.spec.server.beans.event.IEventDataNode;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.wilyassert.Assertion;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public final class TransactionTraceData
implements Externalizable,
IEventData,
IEventDataHeader {
    private static final long serialVersionUID = -8804305358554459447L;
    private AgentName fAgent;
    private TransactionComponentData fRootComponent;
    private String traceId;

    public TransactionTraceData() {
    }

    public TransactionTraceData(AgentName agent, TransactionComponentData rootComponent) {
        Assertion.wilyAssert(agent != null);
        this.fAgent = agent;
        this.fRootComponent = rootComponent;
    }

    @Override
    public AgentName getAgent() {
        return this.fAgent;
    }

    public void setAgent(AgentName agent) {
        Assertion.wilyAssert(agent != null);
        this.fAgent = agent;
    }

    @Override
    public AgentName getRepresentedAgent() {
        if (this.isBrowserResponseTime()) {
            String host = this.fRootComponent.getParameterValue("IP");
            String process = this.fRootComponent.getParameterValue("IP Group");
            process = process.substring(process.lastIndexOf(124) + 1);
            try {
                return AgentName.getAgentName("*Superdomain*", host, process, "Web Browser");
            }
            catch (BadlyFormedNameException badlyFormedNameException) {}
        }
        return this.fAgent;
    }

    public TransactionComponentData getRootComponent() {
        return this.fRootComponent;
    }

    @Override
    public IEventDataNode getRootDataNode() {
        return this.fRootComponent;
    }

    public int getAllComponentCount() {
        return this.fRootComponent.getAllComponentCount();
    }

    @Override
    public String getDescription() {
        return this.getRootComponent().getDescription();
    }

    @Override
    public Set getCorrelationKeys() {
        HashSet keys = new HashSet();
        this.getRootComponent().addCorrelationKeys(keys);
        return Collections.unmodifiableSet(keys);
    }

    public IEventDataHeader getHeader() {
        return this;
    }

    @Override
    public String getEventID() {
        String id = this.getRootComponent().getParameterValue("Trace ID");
        return id == null ? this.traceId : id;
    }

    public void setEventID(String traceId) {
        this.traceId = traceId;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.fAgent);
        out.writeObject(this.fRootComponent);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fAgent = (AgentName)in.readObject();
        this.fRootComponent = (TransactionComponentData)in.readObject();
    }

    public boolean equals(Object o) {
        if (!(o instanceof TransactionTraceData)) {
            return false;
        }
        TransactionTraceData ttd = (TransactionTraceData)o;
        if (ttd.fAgent.equals(this.fAgent)) {
            return this.fRootComponent.equals(ttd.fRootComponent);
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.fRootComponent.getDescription()) + " at " + new Date(this.fRootComponent.getStartTime());
    }

    public int hashCode() {
        Assertion.wilyAssert(this.fAgent != null);
        Assertion.wilyAssert(this.fRootComponent != null);
        return this.fAgent.hashCode() ^ this.fRootComponent.hashCode();
    }

    public boolean isBrowserResponseTime() {
        return this.getRootComponent().getParameterValue("IP Group") != null;
    }

    @Override
    public String getEventType() {
        return this.getRootComponent().getParameterValue("Trace Type");
    }

    @Override
    public long getStartTime() {
        return this.getRootComponent().getStartTime();
    }

    public String getTimeZone() {
        return this.getRootComponent().getTimeZone();
    }

    @Override
    public long getDuration() {
        return this.getRootComponent().getDuration();
    }

    public static int getClampedTotalResults(IEventDataHeader[] data) {
        int totalResults = data.length;
        if (data.length > 0 && data[data.length - 1] instanceof TransactionTraceData) {
            TransactionComponentData clampData = null;
            TransactionTraceData ttd = (TransactionTraceData)data[data.length - 1];
            if ("CL".equalsIgnoreCase(((TransactionTraceData)data[data.length - 1]).getRootComponent().getParameterValue("Trace Type"))) {
                clampData = ttd.getRootComponent();
                String value = clampData.getParameterValue("Total Results");
                totalResults = Integer.parseInt(value);
            }
        }
        return totalResults;
    }

    public static IEventDataHeader[] getClampedHeaders(IEventDataHeader[] data) {
        int length = data.length;
        if (length > 0 && "CL".equalsIgnoreCase(data[length - 1].getEventType())) {
            IEventDataHeader[] dataCopy = new IEventDataHeader[--length];
            System.arraycopy(data, 0, dataCopy, 0, length);
            return dataCopy;
        }
        return data;
    }

    public static TransactionTraceData[] castEventsToTransactions(IEventData[] data) throws ClassCastException {
        TransactionTraceData[] dataCopy = new TransactionTraceData[data.length];
        System.arraycopy(data, 0, dataCopy, 0, data.length);
        return dataCopy;
    }

    public static TransactionTraceData[] castEventHeadersToTransactions(IEventDataHeader[] data) throws ClassCastException {
        TransactionTraceData[] dataCopy = new TransactionTraceData[data.length];
        System.arraycopy(data, 0, dataCopy, 0, data.length);
        return dataCopy;
    }

    @Override
    public Set getParameterNamesForRootNode() {
        return this.getRootComponent().getParameterNames();
    }

    @Override
    public String getParameterValueFromRootNode(String name) {
        return this.getRootComponent().getParameterValue(name);
    }
}

