/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.catalog.server;

import com.wily.isengard.IsengardException;
import com.wily.isengard.catalog.server.CatalogCore;
import com.wily.isengard.catalog.server.CatalogException;
import com.wily.isengard.catalog.server.ICatalogService;
import com.wily.isengard.catalog.server.ICatalogServiceLocal;
import com.wily.isengard.container.BeanActivationException;
import com.wily.isengard.container.BeanUpdateException;
import com.wily.isengard.container.beans.AIsengardBean;
import com.wily.isengard.container.beans.IsengardBeanDescriptor;
import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.messageprimitives.service.MessageServiceFactory;
import com.wily.isengard.messageprimitives.service.ServiceException;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.isengard.util.tree.EntryAlreadyExistsException;
import com.wily.isengard.util.tree.EntryNotFoundException;
import com.wily.isengard.util.tree.InvalidPathException;
import com.wily.util.exception.UnexpectedExceptionError;
import java.util.LinkedList;

public class CatalogBean
extends AIsengardBean
implements ICatalogService,
ICatalogServiceLocal {
    public static final String kCatalogSeparator = "/";
    public static final String kDatabaseServiceAttributeName = "database-service";
    public static final String kUseDatabaseAttributeName = "use-database";
    public static final String kCatalogFilenameAttributeName = "catalog-file";
    private CatalogCore fCatalogCore;

    private void createCatalogCore() {
        this.fCatalogCore = new CatalogCore(this.getPostOffice(), this.getFeedbackChannel());
    }

    @Override
    public void activate() throws IsengardException {
        this.createCatalogCore();
        this.createMessageService(ICatalogService.class, null);
    }

    @Override
    public synchronized void addBean(IsengardBeanDescriptor bean) throws BeanActivationException, CatalogException {
        try {
            this.fCatalogCore.addBean(bean);
        }
        catch (EntryAlreadyExistsException e) {
            throw new CatalogException(e);
        }
    }

    @Override
    public synchronized Object updateBean(String instanceName, Object data) throws CatalogException, BeanUpdateException {
        try {
            return this.fCatalogCore.updateBean(instanceName, data);
        }
        catch (EntryNotFoundException e) {
            throw new CatalogException(e);
        }
        catch (InvalidPathException e) {
            throw new CatalogException(e);
        }
    }

    @Override
    public synchronized void addBeans(IsengardBeanDescriptor[] beans) throws CatalogException {
        LinkedList<IsengardBeanDescriptor> failedDescriptors = new LinkedList<IsengardBeanDescriptor>();
        int i = 0;
        while (i < beans.length) {
            block4: {
                try {
                    this.fCatalogCore.addBean(beans[i]);
                }
                catch (IsengardException e) {
                    failedDescriptors.add(beans[i]);
                    if (!this.getFeedbackChannel().isDebugEnabled(this.getModule())) break block4;
                    this.getFeedbackChannel().debug(this.getModule(), "Exception while adding beans.", e);
                }
            }
            ++i;
        }
        if (failedDescriptors.size() > 0) {
            throw new CatalogException(String.valueOf(failedDescriptors.size()) + " of " + beans.length + " beans failed to activate.", failedDescriptors.toArray(new IsengardBeanDescriptor[0]));
        }
    }

    @Override
    public void removeBean(String bean) throws CatalogException {
        try {
            this.fCatalogCore.removeBeanFromCore(bean);
        }
        catch (Exception e) {
            throw new CatalogException(e);
        }
    }

    @Override
    public synchronized void removeBeans(String[] beans) throws CatalogException {
        try {
            this.fCatalogCore.removeBeans(beans);
        }
        catch (EntryNotFoundException e) {
            throw new CatalogException(e);
        }
    }

    @Override
    public synchronized IsengardBeanDescriptor[] query(String query) {
        return this.fCatalogCore.queryBeans(query);
    }

    public static ICatalogService getCatalogService(PostOffice po) throws ConnectionException {
        try {
            return (ICatalogService)MessageServiceFactory.getService(po, ICatalogService.class);
        }
        catch (ServiceException e) {
            throw new UnexpectedExceptionError(e);
        }
    }

    @Override
    public void addClassBean(Class beanClazz) throws CatalogException, BeanActivationException {
        IsengardBeanDescriptor bean = IsengardBeanDescriptor.getInitialBeanDescriptor("controller", beanClazz);
        this.addBean(bean);
    }

    @Override
    public synchronized void passivateBeans() {
        this.fCatalogCore.passivateBeans();
    }
}

