/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.properties.hot;

import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.feedback.SeverityLevel;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;

public class ConfigurationProperty {
    private final IModuleFeedbackChannel feedback;
    private final Module module;
    private final IStringLocalizer localizer;
    private final String name;
    private final String descriptionKey;
    private final String description;
    private final String unitsKey;
    private final String units;
    private final String[] validValues;
    private final boolean isFixed;
    private final boolean isHot;
    private final boolean isIndexed;
    private final boolean isNullValid;
    private final Object defaultValueLock = new Object();
    private final Object valueLock = new Object();
    private Object defaultValue;
    private Object initValue;
    private Object value;
    private boolean valueIsDefault;
    private boolean initialized = false;
    private Object newValue;
    private boolean newValueIsDefault;

    public ConfigurationProperty(String name, Object defaultValue, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
        this(name, defaultValue, null, "Hot_Property_Configuration_Property", null, true, false, feedback, module, localizer);
    }

    public ConfigurationProperty(String name, Object defaultValue, String descriptionKey, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
        this(name, defaultValue, null, descriptionKey, null, true, false, feedback, module, localizer);
    }

    public ConfigurationProperty(String name, Object defaultValue, String descriptionKey, String unitsKey, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
        this(name, defaultValue, null, descriptionKey, unitsKey, true, false, feedback, module, localizer);
    }

    public ConfigurationProperty(String name, Object defaultValue, String descriptionKey, String unitsKey, boolean isHot, boolean isNullValid, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
        this(name, defaultValue, null, descriptionKey, unitsKey, isHot, isNullValid, feedback, module, localizer);
    }

    public ConfigurationProperty(String name, Object defaultValue, String descriptionKey, String unitsKey, boolean isHot, boolean isNullValid, boolean isIndexed, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
        this(name, defaultValue, null, descriptionKey, unitsKey, isHot, isNullValid, isIndexed, feedback, module, localizer);
    }

    protected ConfigurationProperty(String name, Object defaultValue, String[] validValues, String descriptionKey, String unitsKey, boolean isHot, boolean isNullValid, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
        this(name, defaultValue, validValues, descriptionKey, unitsKey, isHot, isNullValid, false, feedback, module, localizer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConfigurationProperty(String name, Object defaultValue, String[] validValues, String descriptionKey, String unitsKey, boolean isHot, boolean isNullValid, boolean isIndexed, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
        this.feedback = feedback;
        this.module = module;
        Assertion.wilyAssert(localizer != null, "Localizer is null");
        this.localizer = localizer;
        this.name = name;
        this.validValues = validValues;
        this.isNullValid = isNullValid;
        this.isIndexed = isIndexed;
        this.descriptionKey = descriptionKey;
        this.description = this.localizer.IStringLocalizer_getLocalizedString(StringUtils.isEmpty(this.descriptionKey) ? "Hot_Property_Configuration_Property" : this.descriptionKey);
        this.unitsKey = unitsKey;
        this.units = StringUtils.isEmpty(this.unitsKey) ? "" : this.localizer.IStringLocalizer_getLocalizedString(this.unitsKey);
        this.isHot = isHot;
        this.validateValue(defaultValue, "Hot_Property_Invalid_Initial_Default_Message", true);
        Object object = this.defaultValueLock;
        synchronized (object) {
            this.defaultValue = defaultValue;
        }
        String fixedValue = System.getProperty(this.name);
        boolean makeFixed = false;
        if (fixedValue != null) {
            Object cv;
            block11: {
                cv = null;
                try {
                    cv = this.convert(fixedValue);
                    if (this.validateValue(cv, "Hot_Property_Invalid_Fixed_Message", false)) {
                        if (!this.isSilent()) {
                            this.feedback.info(this.module, this.formatLocalizedMessage("Hot_Property_Fixed_Set_Message", null, this.toString(cv)));
                        }
                        makeFixed = true;
                    }
                }
                catch (IllegalArgumentException e) {
                    if (!this.isSilent()) {
                        this.feedback.error(this.module, this.formatLocalizedMessage("Hot_Property_Invalid_Fixed_Message", e.getMessage(), this.toString(fixedValue)));
                    }
                }
                catch (NullPointerException e) {
                    if (this.isSilent()) break block11;
                    this.feedback.error(this.module, this.formatLocalizedMessage("Hot_Property_Invalid_Fixed_Message", e.getMessage(), this.toString(fixedValue)));
                }
            }
            if (makeFixed) {
                this.setValue(cv);
            }
        }
        this.isFixed = makeFixed;
    }

    public Object convert(String s) {
        return s;
    }

    public void set(Object value) {
    }

    public String toString(Object v) {
        return this.toString(v == null ? null : v.toString());
    }

    public boolean validate(Object value) {
        return true;
    }

    public final String formatLocalizedMessage(String messageKey, String reason, String value) {
        return this.localizer.IStringLocalizer_getFormattedLocalizedString(messageKey, this.description, this.name, value, StringUtils.isEmpty(reason) ? "" : reason);
    }

    public final String formatLocalizedMessage(String propName, String messageKey, String reason, String value) {
        return this.localizer.IStringLocalizer_getFormattedLocalizedString(messageKey, this.description, propName, value, StringUtils.isEmpty(reason) ? "" : reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getDefaultValue() {
        Object object = this.defaultValueLock;
        synchronized (object) {
            return this.defaultValue;
        }
    }

    public final IModuleFeedbackChannel getFeedback() {
        return this.feedback;
    }

    public final IStringLocalizer getLocalizer() {
        return this.localizer;
    }

    public final Module getModule() {
        return this.module;
    }

    public final String getName() {
        return this.name;
    }

    public final Object getNewValue() {
        return this.newValue;
    }

    public final String[] getValidValues() {
        return this.validValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getValue() {
        Object object = this.valueLock;
        synchronized (object) {
            if (this.isInitialized()) {
                return this.value;
            }
        }
        return this.getDefaultValue();
    }

    public final boolean isFixed() {
        return this.isFixed;
    }

    public final boolean isHot() {
        return this.isHot;
    }

    public final boolean isSilent() {
        return this.feedback == null;
    }

    public boolean isIndexed() {
        return this.isIndexed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isInitialized() {
        Object object = this.valueLock;
        synchronized (object) {
            return this.initialized;
        }
    }

    public final boolean isNullValid() {
        return this.isNullValid;
    }

    public final String toString() {
        Object v = this.getValue();
        return this.toString(v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setDefaultValue(Object newDefaultValue) {
        if (this.isFixed() || !this.isHot()) {
            return;
        }
        Object object = this.defaultValueLock;
        synchronized (object) {
            if (newDefaultValue != null && newDefaultValue.equals(this.defaultValue) || newDefaultValue == null && this.defaultValue == null) {
                return;
            }
            if (!this.validateValue(newDefaultValue, "Hot_Property_Invalid_New_Default_Message", false)) {
                return;
            }
            this.defaultValue = newDefaultValue;
        }
        if (!this.isSilent()) {
            this.feedback.log(SeverityLevel.INFO, this.module, this.formatLocalizedMessage("Hot_Property_Default_Reset_Message", null, newDefaultValue == null ? "" : this.toString(newDefaultValue)));
        }
        object = this.valueLock;
        synchronized (object) {
            if (!this.valueIsDefault) {
                return;
            }
        }
        this.setNewValueToDefault();
        this.setValueAndLog();
    }

    final void setNewValue(Object value) {
        this.newValue = value;
        this.newValueIsDefault = false;
    }

    final void setNewValueToDefault() {
        this.newValue = this.getDefaultValue();
        this.newValueIsDefault = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setInitValue(Object inObj) {
        if (!this.isInitialized() && !this.isHot()) {
            Object object = this.valueLock;
            synchronized (object) {
                this.initValue = inObj;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isInitValue(Object inObj) {
        if (this.isInitialized() && this.initValue != null && inObj != null) {
            Object object = this.valueLock;
            synchronized (object) {
                return this.initValue.equals(inObj);
            }
        }
        return false;
    }

    final void setValueAndLog() {
        this.setValue(this.newValue);
        if (!this.isSilent()) {
            String logMessage = this.newValueIsDefault ? "Hot_Property_Set_To_Default_Message" : "Hot_Property_Set_Message";
            this.feedback.log(SeverityLevel.INFO, this.formatLocalizedMessage(logMessage, null, this.toString()));
        }
    }

    final String toString(String valueAsString) {
        String formatValueKey = valueAsString == null ? "null" : "Hot_Property_Value_Units";
        return this.localizer.IStringLocalizer_getFormattedLocalizedString(formatValueKey, valueAsString, this.units).trim();
    }

    final boolean valueEquals(Object otherValue) {
        Object v = this.getValue();
        if (v == null) {
            return otherValue == null;
        }
        return v.equals(otherValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setValue(Object v) {
        this.set(v);
        Object object = this.valueLock;
        synchronized (object) {
            this.value = v;
            this.valueIsDefault = this.newValueIsDefault;
            this.initialized = true;
            if (!this.isHot && this.initValue != null && this.value != null && this.initValue.equals(this.value)) {
                this.initValue = this.value;
            }
        }
    }

    private final boolean validateValue(Object value, String errMsgKey, boolean assertIfInvalid) {
        boolean valueOK = false;
        String reason = null;
        if (value == null && !this.isNullValid) {
            valueOK = false;
            reason = this.localizer.IStringLocalizer_getLocalizedString("Hot_Property_Null_Is_Invalid");
        }
        try {
            valueOK = this.validate(value);
        }
        catch (IllegalArgumentException e) {
            reason = e.getMessage();
        }
        catch (NullPointerException e) {
            reason = e.getMessage();
        }
        if (!valueOK && !this.isSilent()) {
            String errMsg = this.formatLocalizedMessage(errMsgKey, reason, value == null ? "null" : this.toString(value));
            this.feedback.error(this.module, errMsg);
            if (assertIfInvalid) {
                Assertion.wilyAssert(errMsg);
            }
        }
        return valueOK;
    }
}

